/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;

public class MSExcelDocumentReader
extends BaseDocumentReader {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";

    public String[] getMimeTypes() {
        return new String[]{"application/excel", "application/xls", "application/vnd.ms-excel"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        StringBuilder builder = new StringBuilder("");
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            HSSFWorkbook wb;
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                wb = new HSSFWorkbook(is);
            }
            catch (IOException e) {
                throw new DocumentReadException("Can't open spreadsheet.", e);
            }
            for (int sheetNum = 0; sheetNum < wb.getNumberOfSheets(); ++sheetNum) {
                HSSFSheet sheet = wb.getSheetAt(sheetNum);
                if (sheet == null) continue;
                for (int rowNum = sheet.getFirstRowNum(); rowNum <= sheet.getLastRowNum(); ++rowNum) {
                    HSSFRow row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    int lastcell = row.getLastCellNum();
                    block21: for (int k = 0; k < lastcell; ++k) {
                        HSSFCell cell = row.getCell((short)k);
                        if (cell == null) continue;
                        switch (cell.getCellType()) {
                            case 0: {
                                double d = cell.getNumericCellValue();
                                if (MSExcelDocumentReader.isCellDateFormatted(cell)) {
                                    Date date = HSSFDateUtil.getJavaDate((double)d);
                                    String cellText = dateFormat.format(date);
                                    builder.append(cellText).append(" ");
                                    continue block21;
                                }
                                builder.append(d).append(" ");
                                continue block21;
                            }
                            case 2: {
                                builder.append(cell.getCellFormula().toString()).append(" ");
                                continue block21;
                            }
                            case 4: {
                                builder.append(cell.getBooleanCellValue()).append(" ");
                                continue block21;
                            }
                            case 5: {
                                builder.append(cell.getErrorCellValue()).append(" ");
                                continue block21;
                            }
                            case 1: {
                                builder.append(cell.getStringCellValue().toString()).append(" ");
                                continue block21;
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return builder.toString();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties(is);
        return reader.getProperties();
    }

    public static boolean isCellDateFormatted(HSSFCell cell) {
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate((double)d)) {
            HSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            switch (i) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 45: 
                case 46: 
                case 47: 
                case 165: 
                case 167: 
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: {
                    bDate = true;
                    break;
                }
                default: {
                    bDate = false;
                }
            }
        }
        return bDate;
    }
}

