/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerResponse
implements GenericContainerResponse {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.ContainerResponse");
    private ContainerResponseWriter responseWriter;
    private int status;
    private Type entityType;
    private Object entity;
    private MultivaluedMap<String, Object> headers;
    private MediaType contentType;
    private Response response;

    public ContainerResponse(ContainerResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    @Override
    public void setResponse(Response response) {
        this.response = response;
        if (response == null) {
            this.reset();
            return;
        }
        this.status = response.getStatus();
        this.headers = response.getMetadata();
        this.entity = response.getEntity();
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            this.entity = ge.getEntity();
            this.entityType = ge.getType();
        } else if (this.entity != null) {
            this.entityType = this.entity.getClass();
        }
        Object contentTypeHeader = this.getHttpHeaders().getFirst((Object)"Content-Type");
        this.contentType = contentTypeHeader instanceof MediaType ? (MediaType)contentTypeHeader : (contentTypeHeader != null ? MediaType.valueOf((String)contentTypeHeader.toString()) : null);
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    private void reset() {
        this.status = Response.Status.NO_CONTENT.getStatusCode();
        this.entity = null;
        this.entityType = null;
        this.contentType = null;
        this.headers = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeResponse() throws IOException {
        long contentLength;
        MessageBodyWriter<?> entityWriter;
        if (this.entity == null) {
            this.responseWriter.writeHeaders(this);
            return;
        }
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        MediaType contentType = this.getContentType();
        if (contentType == null) {
            List<MediaType> l = context.getProviders().getAcceptableWriterMediaTypes(this.entity.getClass(), this.entityType, null);
            contentType = context.getContainerRequest().getAcceptableMediaType(l);
            if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            this.contentType = contentType;
            this.getHttpHeaders().putSingle((Object)"Content-Type", (Object)contentType);
        }
        if ((entityWriter = context.getProviders().getMessageBodyWriter(this.entity.getClass(), this.entityType, null, contentType)) == null) {
            String message = "Not found writer for " + this.entity.getClass() + " and MIME type " + contentType;
            if (!context.getContainerRequest().getMethod().equals("HEAD")) {
                LOG.error((Object)message);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build());
            }
            LOG.warn((Object)message);
            this.getHttpHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(-1L));
        } else if (this.getHttpHeaders().getFirst((Object)"Content-Length") == null && (contentLength = entityWriter.getSize(this.entity, this.entity.getClass(), this.entityType, null, contentType)) >= 0L) {
            this.getHttpHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
        }
        if (context.getContainerRequest().getMethod().equals("HEAD")) {
            this.entity = null;
        }
        this.responseWriter.writeHeaders(this);
        this.responseWriter.writeBody(this, entityWriter);
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public Type getEntityType() {
        return this.entityType;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public MultivaluedMap<String, Object> getHttpHeaders() {
        return this.headers;
    }

    @Override
    public int getStatus() {
        return this.status;
    }
}

