/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.search.ExcludeIncludeDataTypePlugin;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.SmallPaginatedQueryResult;
import org.exoplatform.services.wcm.search.WCMPaginatedQueryResult;
import org.exoplatform.services.wcm.utils.AbstractQueryBuilder;
import org.exoplatform.services.wcm.utils.SQLQueryBuilder;

public class SiteSearchServiceImpl
implements SiteSearchService {
    private LivePortalManagerService livePortalManagerService;
    private TemplateService templateService;
    private WCMConfigurationService configurationService;
    private RepositoryService repositoryService;
    private CopyOnWriteArraySet<String> excludeNodeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> includeNodeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> excludeMimeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> includeMimeTypes = new CopyOnWriteArraySet();

    public SiteSearchServiceImpl(LivePortalManagerService portalManagerService, TemplateService templateService, WCMConfigurationService configurationService, RepositoryService repositoryService, InitParams initParams) throws Exception {
        this.livePortalManagerService = portalManagerService;
        this.templateService = templateService;
        this.repositoryService = repositoryService;
        this.configurationService = configurationService;
    }

    public void addExcludeIncludeDataTypePlugin(ExcludeIncludeDataTypePlugin plugin) {
        this.excludeNodeTypes.addAll(plugin.getExcludeNodeTypes());
        this.excludeMimeTypes.addAll(plugin.getExcludeMimeTypes());
        this.includeMimeTypes.addAll(plugin.getIncludeMimeTypes());
        this.includeNodeTypes.addAll(plugin.getIncludeNodeTypes());
    }

    public WCMPaginatedQueryResult searchSiteContents(SessionProvider sessionProvider, QueryCriteria queryCriteria, int pageSize, boolean isSearchContent) throws Exception {
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        NodeLocation location = this.configurationService.getLivePortalsLocation(currentRepository.getConfiguration().getName());
        Session session = sessionProvider.getSession(location.getWorkspace(), currentRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        long startTime = System.currentTimeMillis();
        QueryResult queryResult = this.searchSiteContent(queryCriteria, queryManager);
        String suggestion = this.getSpellSuggestion(queryCriteria.getKeyword(), currentRepository);
        long queryTime = System.currentTimeMillis() - startTime;
        WCMPaginatedQueryResult paginatedQueryResult = null;
        paginatedQueryResult = queryResult.getNodes().getSize() > 250L ? new WCMPaginatedQueryResult(queryResult, queryCriteria, pageSize, isSearchContent) : new SmallPaginatedQueryResult(queryResult, queryCriteria, pageSize, isSearchContent);
        paginatedQueryResult.setQueryTime(queryTime);
        paginatedQueryResult.setSpellSuggestion(suggestion);
        return paginatedQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSpellSuggestion(String checkingWord, ManageableRepository manageableRepository) throws Exception {
        String suggestion = null;
        Session session = null;
        try {
            session = manageableRepository.getSystemSession(manageableRepository.getConfiguration().getDefaultWorkspaceName());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("SELECT rep:spellcheck() FROM nt:base WHERE jcr:path like '/' AND SPELLCHECK('" + checkingWord + "')", "sql");
            RowIterator rows = query.execute().getRows();
            Value value = rows.nextRow().getValue("rep:spellcheck()");
            if (value != null) {
                suggestion = value.getString();
            }
        }
        catch (Exception e) {
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return suggestion;
    }

    private QueryResult searchSiteContent(QueryCriteria queryCriteria, QueryManager queryManager) throws Exception {
        SQLQueryBuilder queryBuilder = new SQLQueryBuilder();
        this.mapQueryTypes(queryCriteria, queryBuilder);
        if (queryCriteria.isFulltextSearch()) {
            this.mapQueryPath(queryCriteria, queryBuilder);
            this.mapFulltextQueryTearm(queryCriteria, queryBuilder);
        } else {
            this.searchByNodeName(queryCriteria, queryBuilder);
        }
        this.mapCategoriesCondition(queryCriteria, queryBuilder);
        this.mapDatetimeRangeSelected(queryCriteria, queryBuilder);
        this.mapMetadataProperties(queryCriteria, queryBuilder);
        this.orderBy(queryCriteria, queryBuilder);
        String queryStatement = queryBuilder.createQueryStatement();
        Query query = queryManager.createQuery(queryStatement, "sql");
        return query.execute();
    }

    private void mapQueryPath(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.setQueryPath(this.getSitePath(queryCriteria), AbstractQueryBuilder.PATH_TYPE.DECENDANTS);
    }

    private String getSitePath(QueryCriteria queryCriteria) throws Exception {
        String siteName = queryCriteria.getSiteName();
        String sitePath = null;
        if (siteName != null) {
            sitePath = this.livePortalManagerService.getPortalPathByName(siteName);
        } else {
            String repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            sitePath = this.configurationService.getLivePortalsLocation(repository).getPath();
        }
        return sitePath;
    }

    private void mapFulltextQueryTearm(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        String keyword = queryCriteria.getKeyword();
        if (keyword == null || keyword.length() == 0) {
            return;
        }
        AbstractQueryBuilder.QueryTermHelper queryTermHelper = new AbstractQueryBuilder.QueryTermHelper();
        String queryTerm = null;
        queryTerm = (keyword = keyword.replaceAll("'", "''")).contains("*") || keyword.contains("?") || keyword.contains("~") ? queryTermHelper.contains(keyword).buildTerm() : queryTermHelper.contains(keyword).allowFuzzySearch().buildTerm();
        String scope = queryCriteria.getFulltextSearchProperty();
        if (".".equals(scope) || scope == null) {
            queryBuilder.contains(null, queryTerm, AbstractQueryBuilder.LOGICAL.NULL);
        } else {
            queryBuilder.contains(scope, queryTerm, AbstractQueryBuilder.LOGICAL.NULL);
        }
    }

    private void searchByNodeName(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.queryByNodeName(this.getSitePath(queryCriteria), queryCriteria.getKeyword());
    }

    private void mapDatetimeRangeSelected(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        QueryCriteria.DATE_RANGE_SELECTED selectedDateRange = queryCriteria.getDateRangeSelected();
        if (selectedDateRange == null) {
            return;
        }
        if (QueryCriteria.DATE_RANGE_SELECTED.CREATED == selectedDateRange) {
            QueryCriteria.DatetimeRange createdDateRange = queryCriteria.getCreatedDateRange();
            queryBuilder.betweenDates("exo:dateCreated", createdDateRange.getFromDate(), createdDateRange.getToDate(), AbstractQueryBuilder.LOGICAL.AND);
        } else if (QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED == selectedDateRange) {
            QueryCriteria.DatetimeRange modifiedDateRange = queryCriteria.getLastModifiedDateRange();
            queryBuilder.betweenDates("exo:dateModified", modifiedDateRange.getFromDate(), modifiedDateRange.getToDate(), AbstractQueryBuilder.LOGICAL.AND);
        } else {
            if (QueryCriteria.DATE_RANGE_SELECTED.START_PUBLICATION == selectedDateRange) {
                throw new UnsupportedOperationException();
            }
            if (QueryCriteria.DATE_RANGE_SELECTED.END_PUBLICATION == selectedDateRange) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void mapCategoriesCondition(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        String[] categoryUUIDs = queryCriteria.getCategoryUUIDs();
        if (categoryUUIDs == null) {
            return;
        }
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        queryBuilder.like("exo:category", categoryUUIDs[0], AbstractQueryBuilder.LOGICAL.NULL);
        if (categoryUUIDs.length > 1) {
            for (int i = 1; i < categoryUUIDs.length; ++i) {
                queryBuilder.like("exo:category", categoryUUIDs[i], AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
    }

    private void mapMetadataProperties(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        QueryCriteria.QueryProperty[] queryProperty = queryCriteria.getQueryMetadatas();
        if (queryProperty == null) {
            return;
        }
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        queryBuilder.like(queryProperty[0].getName(), queryProperty[0].getName(), AbstractQueryBuilder.LOGICAL.NULL);
        if (queryProperty.length > 1) {
            for (int i = 1; i < queryProperty.length; ++i) {
                queryBuilder.like(queryProperty[i].getName(), queryProperty[i].getName(), AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
    }

    private void mapQuerySpecificNodeTypes(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder, NodeTypeManager nodeTypeManager) throws Exception {
        String[] contentTypes = queryCriteria.getContentTypes();
        NodeType fistType = nodeTypeManager.getNodeType(contentTypes[0]);
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        if (fistType.isMixin()) {
            queryBuilder.like("jcr:mixinTypes", contentTypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        } else {
            queryBuilder.equal("jcr:primaryType", contentTypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        }
        if (contentTypes.length > 1) {
            for (int i = 1; i < contentTypes.length; ++i) {
                String type = contentTypes[i];
                NodeType nodetype = nodeTypeManager.getNodeType(type);
                if (nodetype.isMixin()) {
                    queryBuilder.like("jcr:mixinTypes", type, AbstractQueryBuilder.LOGICAL.OR);
                    continue;
                }
                queryBuilder.equal("jcr:primaryType", type, AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        queryBuilder.like("jcr:mixinTypes", "exo:cssFile", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.like("jcr:mixinTypes", "exo:jsFile", AbstractQueryBuilder.LOGICAL.OR);
        queryBuilder.closeGroup();
    }

    private void mapQueryTypes(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.selectTypes(null);
        queryBuilder.fromNodeTypes(null);
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        ExtendedNodeTypeManager manager = currentRepository.getNodeTypeManager();
        String[] contentTypes = queryCriteria.getContentTypes();
        if (contentTypes != null && contentTypes.length > 0 && queryCriteria.getKeyword() == null) {
            this.mapQuerySpecificNodeTypes(queryCriteria, queryBuilder, (NodeTypeManager)manager);
            return;
        }
        List selectedNodeTypes = this.templateService.getDocumentTemplates(currentRepository.getConfiguration().getName());
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        queryBuilder.equal("jcr:primaryType", "nt:resource", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.equal("jcr:mixinTypes", "exo:rss-enable", AbstractQueryBuilder.LOGICAL.OR);
        ArrayList<String> publicatioTypes = new ArrayList<String>(4);
        NodeTypeIterator iterator = manager.getAllNodeTypes();
        while (iterator.hasNext()) {
            NodeType nodeType = iterator.nextNodeType();
            if (nodeType.isNodeType("publication:webpagesPublication")) {
                publicatioTypes.add(nodeType.getName());
                continue;
            }
            if (!nodeType.isNodeType("exo:metadata")) continue;
            if (nodeType.isMixin()) {
                queryBuilder.equal("jcr:mixinTypes", nodeType.getName(), AbstractQueryBuilder.LOGICAL.OR);
                continue;
            }
            queryBuilder.equal("jcr:primaryType", nodeType.getName(), AbstractQueryBuilder.LOGICAL.OR);
        }
        for (String type : selectedNodeTypes) {
            NodeType nodetype = manager.getNodeType(type);
            if (nodetype.isMixin()) {
                queryBuilder.like("jcr:mixinTypes", type, AbstractQueryBuilder.LOGICAL.OR);
                continue;
            }
            queryBuilder.equal("jcr:primaryType", type, AbstractQueryBuilder.LOGICAL.OR);
        }
        queryBuilder.closeGroup();
        if (this.excludeMimeTypes.size() < 1) {
            return;
        }
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        String[] mimetypes = this.excludeMimeTypes.toArray(new String[0]);
        queryBuilder.equal("jcr:mimeType", mimetypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        for (int i = 1; i < mimetypes.length; ++i) {
            queryBuilder.equal("jcr:mimeType", mimetypes[i], AbstractQueryBuilder.LOGICAL.OR);
        }
        queryBuilder.closeGroup();
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        queryBuilder.like("jcr:mixinTypes", "exo:cssFile", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.like("jcr:mixinTypes", "exo:jsFile", AbstractQueryBuilder.LOGICAL.OR);
        queryBuilder.closeGroup();
    }

    private void orderBy(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        queryBuilder.orderBy("jcr:score", AbstractQueryBuilder.ORDERBY.DESC);
    }
}

