/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.renditions.impl;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.RenditionContentStream;
import org.xcmis.spi.RenditionProvider;
import org.xcmis.spi.utils.MimeType;

public class ImageRenditionProvider
implements RenditionProvider {
    private static final MimeType[] SUPPORTED_MEDIA_TYPES;
    private static final MimeType PRODUCED;
    private int maxHeight = 100;
    private int maxWidth = 100;

    public int getHeight() {
        return -1;
    }

    public String getKind() {
        return "cmis:thumbnail";
    }

    public MimeType getProducedMediaType() {
        return PRODUCED;
    }

    public RenditionContentStream getRenditionStream(ContentStream stream) throws IOException {
        BufferedImage image = ImageIO.read(stream.getStream());
        int scale = (int)Math.max(Math.floor((double)(image.getHeight() / this.maxHeight) + 1.0), Math.floor((double)(image.getWidth() / this.maxWidth) + 1.0));
        int height = image.getHeight() / scale;
        int width = image.getWidth() / scale;
        BufferedImage scaledImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = scaledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        graphics2D.dispose();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)scaledImage, "png", out);
        RenditionContentStream renditionStream = new RenditionContentStream(out.toByteArray(), null, new MimeType("image", "png"), this.getKind(), height, width);
        return renditionStream;
    }

    public MimeType[] getSupportedMediaType() {
        return SUPPORTED_MEDIA_TYPES;
    }

    public int getWidth() {
        return -1;
    }

    static {
        String[] types = ImageIO.getReaderMIMETypes();
        SUPPORTED_MEDIA_TYPES = new MimeType[types.length];
        for (int i = 0; i < types.length; ++i) {
            ImageRenditionProvider.SUPPORTED_MEDIA_TYPES[i] = MimeType.fromString((String)types[i]);
        }
        PRODUCED = new MimeType("image", "png");
    }
}

