/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.BaseSortedEvictionAlgorithm;
import org.jboss.cache.eviction.ElementSizeAlgorithmConfig;
import org.jboss.cache.eviction.ElementSizeQueue;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSizeAlgorithm
extends BaseSortedEvictionAlgorithm {
    @Override
    protected EvictionQueue setupEvictionQueue() throws EvictionException {
        return new ElementSizeQueue();
    }

    @Override
    protected boolean shouldEvictNode(NodeEntry ne) {
        if (this.isYoungerThanMinimumTimeToLive(ne)) {
            return false;
        }
        int size = this.getEvictionQueue().getNumberOfNodes();
        ElementSizeAlgorithmConfig config = (ElementSizeAlgorithmConfig)this.evictionAlgorithmConfig;
        return config.getMaxNodes() > -1 && size > config.getMaxNodes() || ne.getNumberOfElements() > config.getMaxElementsPerNode();
    }

    @Override
    protected void prune() throws EvictionException {
        super.prune();
        ((ElementSizeQueue)this.evictionQueue).prune();
    }

    @Override
    public Class<? extends EvictionAlgorithmConfig> getConfigurationClass() {
        return ElementSizeAlgorithmConfig.class;
    }
}

