/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.jboss.cache.eviction.FIFOQueue;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOAlgorithm
extends BaseEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(FIFOAlgorithm.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected EvictionQueue setupEvictionQueue() throws EvictionException {
        return new FIFOQueue();
    }

    @Override
    protected boolean shouldEvictNode(NodeEntry ne) {
        if (this.isYoungerThanMinimumTimeToLive(ne)) {
            return false;
        }
        FIFOAlgorithmConfig config = (FIFOAlgorithmConfig)this.evictionAlgorithmConfig;
        if (trace) {
            log.trace((Object)("Deciding whether node in queue " + ne.getFqn() + " requires eviction."));
        }
        int size = this.getEvictionQueue().getNumberOfNodes();
        return config.getMaxNodes() != -1 && size > config.getMaxNodes();
    }

    @Override
    public Class<? extends EvictionAlgorithmConfig> getConfigurationClass() {
        return FIFOAlgorithmConfig.class;
    }
}

