/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/organization/webui/component/UIGroupSelector.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={ChangeNodeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectPathActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectGroupActionListener.class})}), @ComponentConfig(type=UITree.class, id="UITreeGroupSelector", template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbGroupSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={UIBreadcumbs.SelectPathActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIGroupSelector
extends UIContainer {
    private Group selectedGroup;

    public UIGroupSelector() throws Exception {
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.addChild(UIBreadcumbs.class, "BreadcumbGroupSelector", "BreadcumbGroupSelector");
        UITree tree = (UITree)this.addChild(UITree.class, "UITreeGroupSelector", "TreeGroupSelector");
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        Collection sibblingsGroup = service.getGroupHandler().findGroups(null);
        tree.setSibbling((List)sibblingsGroup);
        tree.setIcon("GroupAdminIcon");
        tree.setSelectedIcon("PortalIcon");
        tree.setBeanIdField("id");
        tree.setBeanLabelField("label");
        uiBreadcumbs.setBreadcumbsStyle("UIExplorerHistoryPath");
    }

    public Group getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(Group group) {
        this.selectedGroup = group;
    }

    public void changeGroup(String groupId) throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        uiBreadcumb.setPath(this.getPath(null, groupId));
        UITree tree = (UITree)this.getChild(UITree.class);
        if (groupId == null) {
            Collection sibblingGroup = service.getGroupHandler().findGroups(null);
            tree.setSibbling((List)sibblingGroup);
            tree.setChildren(null);
            tree.setSelected(null);
            this.selectedGroup = null;
            return;
        }
        this.selectedGroup = service.getGroupHandler().findGroupById(groupId);
        String parentGroupId = null;
        if (this.selectedGroup != null) {
            parentGroupId = this.selectedGroup.getParentId();
        }
        Group parentGroup = null;
        if (parentGroupId != null) {
            parentGroup = service.getGroupHandler().findGroupById(parentGroupId);
        }
        Collection childrenGroup = service.getGroupHandler().findGroups(this.selectedGroup);
        Collection sibblingGroup = service.getGroupHandler().findGroups(parentGroup);
        tree.setSibbling((List)sibblingGroup);
        tree.setChildren((List)childrenGroup);
        tree.setSelected((Object)this.selectedGroup);
        tree.setParentSelected((Object)parentGroup);
    }

    private List<UIBreadcumbs.LocalPath> getPath(List<UIBreadcumbs.LocalPath> list, String id) throws Exception {
        if (list == null) {
            list = new ArrayList<UIBreadcumbs.LocalPath>(5);
        }
        if (id == null) {
            return list;
        }
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        Group group = service.getGroupHandler().findGroupById(id);
        if (group == null) {
            return list;
        }
        list.add(0, new UIBreadcumbs.LocalPath(group.getId(), group.getGroupName()));
        this.getPath(list, group.getParentId());
        return list;
    }

    public String event(String name) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        if (uiForm != null) {
            return uiForm.event(name, this.getId(), "");
        }
        return super.event(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectGroupActionListener
    extends EventListener<UIGroupSelector> {
        public void execute(Event<UIGroupSelector> event) throws Exception {
            UIGroupSelector uiSelector = (UIGroupSelector)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiSelector.getParent();
            uiPopup.setShow(false);
            UIForm uiForm = (UIForm)((UIGroupSelector)((Object)event.getSource())).getAncestorOfType(UIForm.class);
            if (uiForm != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
                uiForm.broadcast(event, event.getExecutionPhase());
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
                UIComponent uiParent = uiPopup.getParent();
                uiParent.broadcast(event, event.getExecutionPhase());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIGroupSelector> {
        public void execute(Event<UIGroupSelector> event) throws Exception {
            UIGroupSelector uiSelector = (UIGroupSelector)((Object)event.getSource());
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)uiSelector.getChild(UIBreadcumbs.class);
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiSelector.changeGroup(selectGroupId);
            UIForm uiForm = (UIForm)((UIGroupSelector)((Object)event.getSource())).getAncestorOfType(UIForm.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSelector.getParent();
            uiPopup.setShow(true);
            if (uiForm != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            UIGroupSelector uiSelector = null;
            UITree uicom = (UITree)event.getSource();
            uiSelector = (UIGroupSelector)uicom.getParent();
            uiSelector.changeGroup(groupId);
            UIForm uiForm = (UIForm)uiSelector.getAncestorOfType(UIForm.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSelector.getParent();
            uiPopup.setShow(true);
            if (uiForm != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
            }
        }
    }
}

