/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class SegmentInfos
extends Vector {
    public static final int FORMAT = -1;
    public static final int FORMAT_LOCKLESS = -2;
    public static final int FORMAT_SINGLE_NORM_FILE = -3;
    public static final int FORMAT_SHARED_DOC_STORE = -4;
    public static final int FORMAT_CHECKSUM = -5;
    public static final int FORMAT_DEL_COUNT = -6;
    public static final int FORMAT_HAS_PROX = -7;
    static final int CURRENT_FORMAT = -7;
    public int counter = 0;
    private long version = System.currentTimeMillis();
    private long generation = 0L;
    private long lastGeneration = 0L;
    private static PrintStream infoStream;
    ChecksumIndexOutput pendingOutput;
    private static int defaultGenFileRetryCount;
    private static int defaultGenFileRetryPauseMsec;
    private static int defaultGenLookaheadCount;

    SegmentInfos() {
    }

    public final SegmentInfo info(int i) {
        return (SegmentInfo)this.get(i);
    }

    public static long getCurrentSegmentGeneration(String[] files) {
        if (files == null) {
            return -1L;
        }
        long max = -1L;
        for (int i = 0; i < files.length; ++i) {
            long gen;
            String file = files[i];
            if (!file.startsWith("segments") || file.equals("segments.gen") || (gen = SegmentInfos.generationFromSegmentsFileName(file)) <= max) continue;
            max = gen;
        }
        return max;
    }

    public static long getCurrentSegmentGeneration(Directory directory) throws IOException {
        String[] files = directory.list();
        if (files == null) {
            throw new IOException("cannot read directory " + directory + ": list() returned null");
        }
        return SegmentInfos.getCurrentSegmentGeneration(files);
    }

    public static String getCurrentSegmentFileName(String[] files) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getCurrentSegmentGeneration(files));
    }

    public static String getCurrentSegmentFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getCurrentSegmentGeneration(directory));
    }

    public String getCurrentSegmentFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    public String getNextSegmentFileName() {
        long nextGeneration = this.generation == -1L ? 1L : this.generation + 1L;
        return IndexFileNames.fileNameFromGeneration("segments", "", nextGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(Directory directory, String segmentFileName) throws CorruptIndexException, IOException {
        boolean success = false;
        this.clear();
        ChecksumIndexInput input = new ChecksumIndexInput(directory.openInput(segmentFileName));
        this.lastGeneration = this.generation = SegmentInfos.generationFromSegmentsFileName(segmentFileName);
        try {
            long checksumThen;
            long checksumNow;
            int format = input.readInt();
            if (format < 0) {
                if (format < -7) {
                    throw new CorruptIndexException("Unknown format version: " + format);
                }
                this.version = input.readLong();
                this.counter = input.readInt();
            } else {
                this.counter = format;
            }
            for (int i = input.readInt(); i > 0; --i) {
                this.add(new SegmentInfo(directory, format, input));
            }
            if (format >= 0) {
                this.version = input.getFilePointer() >= input.length() ? System.currentTimeMillis() : input.readLong();
            }
            if (format <= -5 && (checksumNow = input.getChecksum()) != (checksumThen = input.readLong())) {
                throw new CorruptIndexException("checksum mismatch in segments file");
            }
            success = true;
        }
        finally {
            input.close();
            if (!success) {
                this.clear();
            }
        }
    }

    public final void read(Directory directory) throws CorruptIndexException, IOException {
        this.lastGeneration = -1L;
        this.generation = -1L;
        new FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos.this.read(this.directory, segmentFileName);
                return null;
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(Directory directory) throws IOException {
        String segmentFileName = this.getNextSegmentFileName();
        this.generation = this.generation == -1L ? 1L : ++this.generation;
        ChecksumIndexOutput output = new ChecksumIndexOutput(directory.createOutput(segmentFileName));
        boolean success = false;
        try {
            output.writeInt(-7);
            output.writeLong(++this.version);
            output.writeInt(this.counter);
            output.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.info(i).write(output);
            }
            output.prepareCommit();
            success = true;
            this.pendingOutput = output;
        }
        finally {
            if (!success) {
                try {
                    output.close();
                }
                catch (Throwable t) {}
                try {
                    directory.deleteFile(segmentFileName);
                }
                catch (Throwable t) {}
            }
        }
    }

    public Object clone() {
        SegmentInfos sis = (SegmentInfos)super.clone();
        for (int i = 0; i < sis.size(); ++i) {
            sis.set(i, sis.info(i).clone());
        }
        return sis;
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    public static long readCurrentVersion(Directory directory) throws CorruptIndexException, IOException {
        return (Long)new FindSegmentsFile(directory){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                IndexInput input = this.directory.openInput(segmentFileName);
                int format = 0;
                long version = 0L;
                try {
                    format = input.readInt();
                    if (format < 0) {
                        if (format < -7) {
                            throw new CorruptIndexException("Unknown format version: " + format);
                        }
                        version = input.readLong();
                    }
                }
                finally {
                    input.close();
                }
                if (format < 0) {
                    return new Long(version);
                }
                SegmentInfos sis = new SegmentInfos();
                sis.read(this.directory, segmentFileName);
                return new Long(sis.getVersion());
            }
        }.run();
    }

    public static void setInfoStream(PrintStream infoStream) {
        SegmentInfos.infoStream = infoStream;
    }

    public static void setDefaultGenFileRetryCount(int count) {
        defaultGenFileRetryCount = count;
    }

    public static int getDefaultGenFileRetryCount() {
        return defaultGenFileRetryCount;
    }

    public static void setDefaultGenFileRetryPauseMsec(int msec) {
        defaultGenFileRetryPauseMsec = msec;
    }

    public static int getDefaultGenFileRetryPauseMsec() {
        return defaultGenFileRetryPauseMsec;
    }

    public static void setDefaultGenLookaheadCount(int count) {
        defaultGenLookaheadCount = count;
    }

    public static int getDefaultGenLookahedCount() {
        return defaultGenLookaheadCount;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String message) {
        if (infoStream != null) {
            infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + message);
        }
    }

    public SegmentInfos range(int first, int last) {
        SegmentInfos infos = new SegmentInfos();
        infos.addAll(super.subList(first, last));
        return infos;
    }

    void updateGeneration(SegmentInfos other) {
        this.lastGeneration = other.lastGeneration;
        this.generation = other.generation;
        this.version = other.version;
    }

    public final void rollbackCommit(Directory dir) throws IOException {
        if (this.pendingOutput != null) {
            try {
                this.pendingOutput.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
                dir.deleteFile(segmentFileName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pendingOutput = null;
        }
    }

    public final void prepareCommit(Directory dir) throws IOException {
        if (this.pendingOutput != null) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        this.write(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishCommit(Directory dir) throws IOException {
        if (this.pendingOutput == null) {
            throw new IllegalStateException("prepareCommit was not called");
        }
        boolean success = false;
        try {
            this.pendingOutput.finishCommit();
            this.pendingOutput.close();
            this.pendingOutput = null;
            success = true;
        }
        finally {
            if (!success) {
                this.rollbackCommit(dir);
            }
        }
        String fileName = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
        success = false;
        try {
            dir.sync(fileName);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    dir.deleteFile(fileName);
                }
                catch (Throwable t) {}
            }
        }
        this.lastGeneration = this.generation;
        try {
            IndexOutput genOutput = dir.createOutput("segments.gen");
            try {
                genOutput.writeInt(-2);
                genOutput.writeLong(this.generation);
                genOutput.writeLong(this.generation);
            }
            finally {
                genOutput.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public final void commit(Directory dir) throws IOException {
        this.prepareCommit(dir);
        this.finishCommit(dir);
    }

    synchronized String segString(Directory directory) {
        StringBuffer buffer = new StringBuffer();
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentInfo info = this.info(i);
            buffer.append(info.segString(directory));
            if (info.dir == directory) continue;
            buffer.append("**");
        }
        return buffer.toString();
    }

    static {
        defaultGenFileRetryCount = 10;
        defaultGenFileRetryPauseMsec = 50;
        defaultGenLookaheadCount = 10;
    }

    public static abstract class FindSegmentsFile {
        File fileDirectory;
        Directory directory;

        public FindSegmentsFile(File directory) {
            this.fileDirectory = directory;
        }

        public FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws CorruptIndexException, IOException {
            String segmentFileName = null;
            long lastGen = -1L;
            long gen = 0L;
            int genLookaheadCount = 0;
            IOException exc = null;
            boolean retry = false;
            boolean method = false;
            while (true) {
                if (!method) {
                    String[] files = null;
                    long genA = -1L;
                    files = this.directory != null ? this.directory.list() : this.fileDirectory.list();
                    if (files != null) {
                        genA = SegmentInfos.getCurrentSegmentGeneration(files);
                    }
                    SegmentInfos.message("directory listing genA=" + genA);
                    long genB = -1L;
                    if (this.directory != null) {
                        for (int i = 0; i < defaultGenFileRetryCount; ++i) {
                            IndexInput genInput = null;
                            try {
                                genInput = this.directory.openInput("segments.gen");
                            }
                            catch (FileNotFoundException e) {
                                SegmentInfos.message("segments.gen open: FileNotFoundException " + e);
                                break;
                            }
                            catch (IOException e) {
                                SegmentInfos.message("segments.gen open: IOException " + e);
                            }
                            if (genInput != null) {
                                try {
                                    int version = genInput.readInt();
                                    if (version == -2) {
                                        long gen0 = genInput.readLong();
                                        long gen1 = genInput.readLong();
                                        SegmentInfos.message("fallback check: " + gen0 + "; " + gen1);
                                        if (gen0 == gen1) {
                                            genB = gen0;
                                            break;
                                        }
                                    }
                                }
                                catch (IOException err2) {
                                }
                                finally {
                                    genInput.close();
                                }
                            }
                            try {
                                Thread.sleep(defaultGenFileRetryPauseMsec);
                                continue;
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    SegmentInfos.message("segments.gen check: genB=" + genB);
                    gen = genA > genB ? genA : genB;
                    if (gen == -1L) {
                        String s;
                        if (files != null) {
                            s = "";
                            for (int i = 0; i < files.length; ++i) {
                                s = s + " " + files[i];
                            }
                        } else {
                            s = " null";
                        }
                        throw new FileNotFoundException("no segments* file found in " + this.directory + ": files:" + s);
                    }
                }
                if (method || !method && lastGen == gen && retry) {
                    method = true;
                    if (genLookaheadCount < defaultGenLookaheadCount) {
                        ++genLookaheadCount;
                        SegmentInfos.message("look ahead increment gen to " + ++gen);
                    }
                }
                if (lastGen == gen) {
                    if (retry) {
                        throw exc;
                    }
                    retry = true;
                } else if (!method) {
                    retry = false;
                }
                lastGen = gen;
                segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen);
                try {
                    Object v = this.doBody(segmentFileName);
                    if (exc != null) {
                        SegmentInfos.message("success on " + segmentFileName);
                    }
                    return v;
                }
                catch (IOException err) {
                    if (exc == null) {
                        exc = err;
                    }
                    SegmentInfos.message("primary Exception on '" + segmentFileName + "': " + err + "'; will retry: retry=" + retry + "; gen = " + gen);
                    if (retry || gen <= 1L) continue;
                    String prevSegmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen - 1L);
                    boolean prevExists = this.directory != null ? this.directory.fileExists(prevSegmentFileName) : new File(this.fileDirectory, prevSegmentFileName).exists();
                    if (!prevExists) continue;
                    SegmentInfos.message("fallback to prior segment file '" + prevSegmentFileName + "'");
                    try {
                        Object v = this.doBody(prevSegmentFileName);
                        if (exc != null) {
                            SegmentInfos.message("success on fallback " + prevSegmentFileName);
                        }
                        return v;
                    }
                    catch (IOException err2) {
                        SegmentInfos.message("secondary Exception on '" + prevSegmentFileName + "': " + err2 + "'; will retry");
                        continue;
                    }
                }
                break;
            }
        }

        protected abstract Object doBody(String var1) throws CorruptIndexException, IOException;
    }
}

