/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authz.permission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jsecurity.authz.Permission;
import org.jsecurity.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardPermission
implements Permission,
Serializable {
    protected static final String WILDCARD_TOKEN = "*";
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    protected static final boolean DEFAULT_CASE_SENSITIVE = false;
    private List<Set<String>> parts;

    public WildcardPermission(String wildcardString) {
        this(wildcardString, false);
    }

    public WildcardPermission(String wildcardString, boolean caseSensitive) {
        if (wildcardString == null || wildcardString.trim().length() == 0) {
            throw new IllegalArgumentException("Wildcard string cannot be null or empty. Make sure permission strings are properly formatted.");
        }
        wildcardString = wildcardString.trim();
        List<String> parts = CollectionUtils.asList(wildcardString.split(PART_DIVIDER_TOKEN));
        this.parts = new ArrayList<Set<String>>();
        for (String part : parts) {
            Set<String> subparts = CollectionUtils.asSet(part.split(SUBPART_DIVIDER_TOKEN));
            if (!caseSensitive) {
                subparts = this.lowercase(subparts);
            }
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers. Make sure permission strings are properly formatted.");
            }
            this.parts.add(subparts);
        }
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.");
        }
    }

    private Set<String> lowercase(Set<String> subparts) {
        LinkedHashSet<String> lowerCasedSubparts = new LinkedHashSet<String>(subparts.size());
        for (String subpart : subparts) {
            lowerCasedSubparts.add(subpart.toLowerCase());
        }
        return lowerCasedSubparts;
    }

    protected List<Set<String>> getParts() {
        return this.parts;
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof WildcardPermission)) {
            return false;
        }
        WildcardPermission wp = (WildcardPermission)p;
        List<Set<String>> otherParts = wp.getParts();
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.getParts().size() - 1 < i) {
                return true;
            }
            Set<String> part = this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN) && !part.containsAll(otherPart)) {
                return false;
            }
            ++i;
        }
        while (i < this.getParts().size()) {
            Set<String> part = this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

