/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.config;

import java.io.Reader;
import java.io.StringReader;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.JSecurityException;
import org.jsecurity.config.ConfigurationException;
import org.jsecurity.config.ResourceConfiguration;
import org.jsecurity.io.ResourceException;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.util.Initializable;

public abstract class TextConfiguration
extends ResourceConfiguration
implements Initializable {
    private static final Log log = LogFactory.getLog(TextConfiguration.class);
    private String config;

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    protected abstract void load(Reader var1) throws ConfigurationException;

    protected abstract void load(Scanner var1) throws ConfigurationException;

    protected void loadTextConfig(String config) {
        StringReader sr = new StringReader(config);
        try {
            this.load(sr);
        }
        catch (Exception e2) {
            String msg = "Unable to load from text configuration.";
            throw new ResourceException(msg, e2);
        }
    }

    public void init() throws JSecurityException {
        String config;
        SecurityManager securityManager = this.getSecurityManager();
        if (securityManager == null && (config = this.getConfig()) != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Attempting to load Configuration based on 'config' property.");
            }
            this.loadTextConfig(config);
        }
    }
}

