/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SysViewWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.JCRItemExistsException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupWorkspaceInitializer
extends SysViewWorkspaceInitializer {
    private final String restoreDir;
    private final File tempDir;

    public BackupWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager, FileCleanerHolder cleanerHolder) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        super(config, repConfig, dataManager, namespaceRegistry, locationFactory, nodeTypeManager, valueFactory, accessManager, cleanerHolder);
        this.restoreDir = this.restorePath;
        String fullBackupPath = this.getFullBackupPath();
        if (fullBackupPath == null) {
            throw new RepositoryException("Can't find full backup file");
        }
        this.restorePath = fullBackupPath;
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
    }

    @Override
    public NodeData initWorkspace() throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        try {
            long start = System.currentTimeMillis();
            PlainChangesLog changes = this.read();
            TransactionChangesLog tLog = new TransactionChangesLog(changes);
            tLog.setSystemId("JCR_CORE_RESOTRE_WORKSPACE_INITIALIZER_SYSTEM_ID");
            this.dataManager.save(tLog);
            this.incrementalRead();
            NodeData root = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
            log.info((Object)("Workspace " + this.workspaceName + " restored from file " + this.restorePath + " in " + (double)(System.currentTimeMillis() - start) * 1.0 / 1000.0 + "sec"));
            return root;
        }
        catch (XMLStreamException e) {
            throw new RepositoryException("The XML file is corrupted : " + this.restorePath, (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void incrementalRead() throws RepositoryException {
        try {
            for (File incrBackupFile : this.getIncrementalFiles()) {
                this.incrementalRestore(incrBackupFile);
            }
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException("Restore of incremental backup file error " + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("Restore of incremental backup file I/O error " + e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException("Restore of incremental backup error " + e, (Throwable)e);
        }
    }

    private void incrementalRestore(File incrementalBackupFile) throws FileNotFoundException, IOException, ClassNotFoundException, RepositoryException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(incrementalBackupFile));
            while (true) {
                TransactionChangesLog changesLog = this.readExternal(ois);
                changesLog.setSystemId("JCR_CORE_RESOTRE_WORKSPACE_INITIALIZER_SYSTEM_ID");
                ChangesLogIterator cli = changesLog.getLogIterator();
                while (cli.hasNextLog()) {
                    if (cli.nextLog().getEventType() != 0x400000) continue;
                    cli.removeLog();
                }
                this.saveChangesLog(changesLog);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void saveChangesLog(TransactionChangesLog changesLog) throws RepositoryException {
        try {
            this.dataManager.save(changesLog);
        }
        catch (JCRInvalidItemStateException e) {
            TransactionChangesLog normalizeChangesLog = this.getNormalizedChangesLog(e.getIdentifier(), e.getState(), changesLog);
            if (normalizeChangesLog != null) {
                this.saveChangesLog(normalizeChangesLog);
            }
            throw new RepositoryException("Collisions found during save of restore changes log, but caused item is not found by ID " + e.getIdentifier() + ". " + (Object)((Object)e), (Throwable)((Object)e));
        }
        catch (JCRItemExistsException e) {
            TransactionChangesLog normalizeChangesLog = this.getNormalizedChangesLog(e.getIdentifier(), e.getState(), changesLog);
            if (normalizeChangesLog != null) {
                this.saveChangesLog(normalizeChangesLog);
            }
            throw new RepositoryException("Collisions found during save of restore changes log, but caused item is not found by ID " + e.getIdentifier() + ". " + (Object)((Object)e), (Throwable)((Object)e));
        }
    }

    private TransactionChangesLog getNormalizedChangesLog(String collisionID, int state, TransactionChangesLog changesLog) {
        ItemState citem = changesLog.getItemState(collisionID);
        if (citem != null) {
            TransactionChangesLog result = new TransactionChangesLog();
            result.setSystemId(changesLog.getSystemId());
            ChangesLogIterator cli = changesLog.getLogIterator();
            while (cli.hasNextLog()) {
                ArrayList<ItemState> normalized = new ArrayList<ItemState>();
                PlainChangesLog next = cli.nextLog();
                for (ItemState change : next.getAllStates()) {
                    if (state == change.getState()) {
                        ItemData item = change.getData();
                        if (citem.isNode()) {
                            if (item.getIdentifier().equals(collisionID) || item.getQPath().isDescendantOf(citem.getData().getQPath())) continue;
                            normalized.add(change);
                            continue;
                        }
                        if (item.getIdentifier().equals(collisionID)) continue;
                        normalized.add(change);
                        continue;
                    }
                    normalized.add(change);
                }
                PlainChangesLogImpl plog = new PlainChangesLogImpl(normalized, next.getSessionId(), next.getEventType());
                result.addLog(plog);
            }
            return result;
        }
        return null;
    }

    private List<File> getIncrementalFiles() {
        ArrayList<File> list = new ArrayList<File>();
        File rDir = new File(this.restoreDir);
        Pattern fullBackupPattern = Pattern.compile(".+\\.0");
        for (File f : rDir.listFiles(new BackupFilesFilter())) {
            if (fullBackupPattern.matcher(f.getName()).matches()) continue;
            list.add(f);
        }
        return list;
    }

    private String getFullBackupPath() {
        File rDir = new File(this.restoreDir);
        Pattern p = Pattern.compile(".+\\.0");
        for (File f : rDir.listFiles(new BackupFilesFilter())) {
            Matcher m = p.matcher(f.getName());
            if (!m.matches()) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    private TransactionChangesLog readExternal(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int changesLogType = in.readInt();
        TransactionChangesLog transactionChangesLog = null;
        if (changesLogType == 2) {
            transactionChangesLog = (TransactionChangesLog)in.readObject();
            int iFixupStream = in.readInt();
            ArrayList<FixupStream> listFixupStreams = new ArrayList<FixupStream>();
            for (int i = 0; i < iFixupStream; ++i) {
                FixupStream fs = new FixupStream();
                fs.readExternal(in);
                listFixupStreams.add(fs);
            }
            int iStreamCount = in.readInt();
            ArrayList<File> listFiles = new ArrayList<File>();
            for (int i = 0; i < iStreamCount; ++i) {
                long fileSize = in.readLong();
                File contentFile = this.getAsFile(in, fileSize);
                listFiles.add(contentFile);
            }
            RestoreChangesLog restoreChangesLog = new RestoreChangesLog(transactionChangesLog, listFixupStreams, listFiles, this.fileCleaner);
            restoreChangesLog.restore();
        } else if (changesLogType == 1) {
            transactionChangesLog = (TransactionChangesLog)in.readObject();
        }
        return transactionChangesLog;
    }

    private File getAsFile(ObjectInputStream ois, long fileSize) throws IOException {
        int bufferSize = 8192;
        byte[] buf = new byte[bufferSize];
        SpoolFile tempFile = SpoolFile.createTempFile("vdincb" + System.currentTimeMillis(), ".stmp", this.tempDir);
        FileOutputStream fos = new FileOutputStream(tempFile);
        for (long readBytes = fileSize; readBytes > 0L; readBytes -= (long)bufferSize) {
            if (readBytes >= (long)bufferSize) {
                ois.readFully(buf);
                fos.write(buf);
                continue;
            }
            if (readBytes >= (long)bufferSize) continue;
            ois.readFully(buf, 0, (int)readBytes);
            fos.write(buf, 0, (int)readBytes);
        }
        fos.flush();
        fos.close();
        return tempFile;
    }

    class FixupStream
    implements Externalizable {
        int iItemStateId = -1;
        int iValueDataId = -1;

        public FixupStream() {
        }

        public FixupStream(int itemState_, int valueData_) {
            this.iItemStateId = itemState_;
            this.iValueDataId = valueData_;
        }

        public int getItemSateId() {
            return this.iItemStateId;
        }

        public int getValueDataId() {
            return this.iValueDataId;
        }

        public boolean compare(FixupStream fs) {
            boolean b = true;
            if (fs.getItemSateId() != this.getItemSateId()) {
                b = false;
            }
            if (fs.getValueDataId() != this.getValueDataId()) {
                b = false;
            }
            return b;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.iItemStateId = in.readInt();
            this.iValueDataId = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.iItemStateId);
            out.writeInt(this.iValueDataId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RestoreChangesLog {
        private TransactionChangesLog itemDataChangesLog;
        private List<FixupStream> listFixupStream;
        private List<File> listFile;
        private FileCleaner fileCleaner;

        public RestoreChangesLog(TransactionChangesLog transactionChangesLog, List<FixupStream> listFixupStreams, List<File> listFiles, FileCleaner fileCleaner) {
            this.itemDataChangesLog = transactionChangesLog;
            this.listFixupStream = listFixupStreams;
            this.listFile = listFiles;
            this.fileCleaner = fileCleaner;
        }

        public TransactionChangesLog getItemDataChangesLog() {
            return this.itemDataChangesLog;
        }

        public void restore() throws IOException {
            int i;
            List<ItemState> listItemState = this.itemDataChangesLog.getAllStates();
            for (i = 0; i < this.listFixupStream.size(); ++i) {
                ItemState itemState = listItemState.get(this.listFixupStream.get(i).getItemSateId());
                ItemData itemData = itemState.getData();
                PersistedPropertyData propertyData = (PersistedPropertyData)itemData;
                ValueData tvd = propertyData.getValues().get(this.listFixupStream.get(i).getValueDataId());
                propertyData.getValues().set(this.listFixupStream.get(i).getValueDataId(), new StreamPersistedValueData(tvd.getOrderNumber(), this.listFile.get(i)));
            }
            for (i = 0; i < this.listFile.size(); ++i) {
                this.fileCleaner.addFile(this.listFile.get(i));
            }
        }

        public class Type {
            public static final int ItemDataChangesLog_without_Streams = 1;
            public static final int ItemDataChangesLog_with_Streams = 2;
        }
    }

    class BackupFilesFilter
    implements FileFilter {
        BackupFilesFilter() {
        }

        public boolean accept(File pathname) {
            Pattern p = Pattern.compile(".+\\.[0-9]+");
            Matcher m = p.matcher(pathname.getName());
            return m.matches();
        }
    }
}

