/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.AbstractPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWorkspaceStorageDataManagerProxy
implements WorkspaceStorageDataManagerProxy {
    protected final LocalWorkspaceDataManagerStub storageDataManager;
    protected final ValueFactoryImpl valueFactory;

    public LocalWorkspaceStorageDataManagerProxy(LocalWorkspaceDataManagerStub storageDataManager, ValueFactoryImpl valueFactory) {
        this.storageDataManager = storageDataManager;
        this.valueFactory = valueFactory;
    }

    @Override
    public void save(ItemStateChangesLog changesLog) throws InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        ChangesLogIterator logIterator = ((CompositeChangesLog)changesLog).getLogIterator();
        TransactionChangesLog newLog = new TransactionChangesLog();
        while (logIterator.hasNextLog()) {
            ArrayList<ItemState> states = new ArrayList<ItemState>(changesLog.getSize());
            PlainChangesLog changes = logIterator.nextLog();
            for (ItemState change : changes.getAllStates()) {
                states.add(new ItemState(this.copyItemData(change.getData()), change.getState(), change.isEventFire(), change.getAncestorToSave(), change.isInternallyCreated(), change.isPersisted()));
            }
            newLog.addLog(new PlainChangesLogImpl(states, changes.getSessionId(), changes.getEventType()));
        }
        this.storageDataManager.save(newLog);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        return this.getItemData(parentData, name, ItemType.UNKNOWN);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        return this.copyItemData(this.storageDataManager.getItemData(parentData, name, itemType));
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        return this.copyItemData(this.storageDataManager.getItemData(identifier));
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException {
        return this.copyNodes(this.storageDataManager.getChildNodesData(parent));
    }

    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        return this.storageDataManager.getChildNodesCount(parent);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        return this.copyProperties(this.storageDataManager.getChildPropertiesData(parent));
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException {
        return this.copyPropertiesWithoutValues(this.storageDataManager.listChildPropertiesData(parent));
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        return this.copyProperties(this.storageDataManager.getReferencesData(identifier, skipVersionStorage));
    }

    @Override
    public Calendar getCurrentTime() {
        return this.storageDataManager.getCurrentTime();
    }

    private TransientItemData copyItemData(ItemData item) throws RepositoryException {
        if (item == null) {
            return null;
        }
        if (item.isNode()) {
            NodeData node = (NodeData)item;
            AccessControlList acl = node.getACL();
            if (acl == null) {
                throw new RepositoryException("Node ACL is null. " + node.getQPath().getAsString() + " " + node.getIdentifier());
            }
            return new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), acl);
        }
        PropertyData prop = (PropertyData)item;
        ArrayList<ValueData> values = null;
        if (prop.getValues() != null) {
            values = new ArrayList<ValueData>();
            for (ValueData val : prop.getValues()) {
                values.add(((AbstractPersistedValueData)val).createTransientCopy());
            }
        }
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued(), values);
        return newData;
    }

    private TransientItemData copyPropertyDataWithoutValue(PropertyData property) throws RepositoryException {
        if (property == null) {
            return null;
        }
        TransientPropertyData newData = new TransientPropertyData(property.getQPath(), property.getIdentifier(), property.getPersistedVersion(), property.getType(), property.getParentIdentifier(), property.isMultiValued(), new ArrayList<ValueData>());
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeData> copyNodes(List<NodeData> childNodes) throws RepositoryException {
        LinkedList<NodeData> copyOfChildsNodes = new LinkedList<NodeData>();
        List<NodeData> list = childNodes;
        synchronized (list) {
            for (NodeData nodeData : childNodes) {
                copyOfChildsNodes.add((NodeData)((Object)this.copyItemData(nodeData)));
            }
        }
        return copyOfChildsNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyData> copyProperties(List<PropertyData> traverseProperties) throws RepositoryException {
        LinkedList<PropertyData> copyOfChildsProperties = new LinkedList<PropertyData>();
        List<PropertyData> list = traverseProperties;
        synchronized (list) {
            for (PropertyData nodeProperty : traverseProperties) {
                copyOfChildsProperties.add((PropertyData)((Object)this.copyItemData(nodeProperty)));
            }
        }
        return copyOfChildsProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyData> copyPropertiesWithoutValues(List<PropertyData> traverseProperties) throws RepositoryException {
        LinkedList<PropertyData> copyOfChildsProperties = new LinkedList<PropertyData>();
        List<PropertyData> list = traverseProperties;
        synchronized (list) {
            for (PropertyData nodeProperty : traverseProperties) {
                copyOfChildsProperties.add((PropertyData)((Object)this.copyPropertyDataWithoutValue(nodeProperty)));
            }
        }
        return copyOfChildsProperties;
    }
}

