/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.SLF4JLocationAwareLogger;
import org.gatein.common.logging.SimpleLogger;
import org.slf4j.spi.LocationAwareLogger;

public class LoggerFactory {
    private static final ConcurrentMap<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();

    public static Logger getLogger(String name) throws NullPointerException {
        Logger phantom;
        if (name == null) {
            throw new NullPointerException("No null logger name accepted");
        }
        Logger logger = (Logger)loggers.get(name);
        if (logger == null && (phantom = loggers.putIfAbsent(name, logger = LoggerFactory.createLogger(name))) != null) {
            logger = phantom;
        }
        return logger;
    }

    public static Logger getLogger(Class type) {
        if (type == null) {
            throw new NullPointerException("No null class type accepted");
        }
        return LoggerFactory.getLogger(type.getName());
    }

    private static Logger createLogger(String name) {
        org.slf4j.Logger slf4jlogger = org.slf4j.LoggerFactory.getLogger((String)name);
        if (slf4jlogger instanceof LocationAwareLogger) {
            return new SLF4JLocationAwareLogger((LocationAwareLogger)slf4jlogger);
        }
        return new SimpleLogger(slf4jlogger);
    }
}

