/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.exports.data;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.gatein.exports.data.ExportData;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.StateString;

public class PersistedExportData
extends ExportData {
    protected final String type;
    protected final String refID;
    protected static final String REFIDKEY = "rID";
    protected static final String TYPEKEY = "type";
    protected double version = 1.0;

    public PersistedExportData(String type, String refID) {
        this.type = type;
        this.refID = refID;
    }

    public String getType() {
        return this.type;
    }

    public double getVersion() {
        return this.version;
    }

    public String getRefId() {
        return this.refID;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    protected byte[] internalEncodeAsBytes() throws UnsupportedEncodingException {
        ParametersStateString parameterStateString = ParametersStateString.create();
        parameterStateString.setValue(REFIDKEY, this.refID);
        parameterStateString.setValue(TYPEKEY, this.type);
        String stateString = parameterStateString.getStringValue();
        return stateString.getBytes("UTF-8");
    }

    public static PersistedExportData create(byte[] bytes) throws UnsupportedEncodingException {
        Map map = StateString.decodeOpaqueValue((String)new String(bytes, "UTF-8"));
        String refId = null;
        String type = null;
        if (map.containsKey(REFIDKEY) && ((String[])map.get(REFIDKEY)).length > 0) {
            refId = ((String[])map.get(REFIDKEY))[0];
        }
        if (map.containsKey(TYPEKEY) && ((String[])map.get(TYPEKEY)).length > 0) {
            type = ((String[])map.get(TYPEKEY))[0];
        }
        return new PersistedExportData(type, refId);
    }
}

