/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration;

import org.gatein.common.util.ParameterValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationUtils {
    private static boolean strict = true;
    private static final Logger log = LoggerFactory.getLogger(RegistrationUtils.class);

    public static void setStrict(boolean strict) {
        RegistrationUtils.strict = strict;
        log.debug("Using " + (strict ? "strict" : "lenient") + " Consumer Agent validation mode.");
    }

    public static void validateConsumerAgent(String consumerAgent) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerAgent, (String)"consumer agent", null);
        int periodChar = 46;
        int period = consumerAgent.indexOf(periodChar);
        if (period != -1 && (period = (consumerAgent = consumerAgent.substring(period)).indexOf(periodChar)) != -1) {
            return;
        }
        String msg = "'" + consumerAgent + "' is not a valid Consumer Agent. Please notify your Consumer provider that it is not WSRP-compliant.";
        if (strict) {
            throw new IllegalArgumentException(msg);
        }
        log.debug(msg);
    }
}

