/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.MarkupInfo;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.portlet.impl.jsr168.PortletUtils;
import org.gatein.registration.Registration;
import org.gatein.wsrp.UserContextConverter;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.Utils;
import org.gatein.wsrp.producer.handlers.processors.MarkupRequest;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.WSRPInstanceContext;
import org.gatein.wsrp.producer.handlers.processors.WSRPPortletInvocationContext;
import org.gatein.wsrp.producer.handlers.processors.WSRPWindowContext;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MarkupType;
import org.oasis.wsrp.v2.MimeRequest;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.NavigationalContext;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionParams;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestProcessor<Response> {
    private static final String WINDOW_STATE = "window state";
    private static final String PORTLET_MODE = "portlet mode";
    private static final Logger log = LoggerFactory.getLogger(RequestProcessor.class);
    protected PortletInvocation invocation;
    protected MarkupRequest markupRequest;
    protected PortletDescription portletDescription;
    protected Portlet portlet;
    protected WSRPInstanceContext instanceContext;
    protected ProducerHelper producer;

    protected RequestProcessor(ProducerHelper producer) {
        this.producer = producer;
    }

    void prepareInvocation() throws InvalidRegistration, OperationFailed, InvalidHandle, UnsupportedMimeType, UnsupportedWindowState, UnsupportedMode, MissingParameters, ModifyRegistrationRequired {
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(this.getRegistrationContext());
        RuntimeContext runtimeContext = this.getRuntimeContext();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)runtimeContext, (String)"RuntimeContext", (String)this.getContextName());
        this.checkForSessionIDs(runtimeContext);
        MimeRequest params = this.getParams();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)params, (String)"MarkupParams", (String)this.getContextName());
        PortletContext wsrpPC = this.getPortletContext();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)wsrpPC, (String)"PortletContext", (String)this.getContextName());
        org.gatein.pc.api.PortletContext portletContext = WSRPUtils.convertToPortalPortletContext((PortletContext)wsrpPC);
        try {
            this.portlet = this.producer.getPortletWith(portletContext, registration);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Could not retrieve portlet '" + portletContext + "'"), (Throwable)e);
        }
        List desiredLocales = params.getLocales();
        this.portletDescription = this.producer.getPortletDescription(this.portlet, desiredLocales);
        if (Boolean.TRUE.equals(this.portletDescription.isUsesMethodGet())) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Portlets using GET method in forms are not currently supported.", null);
        }
        List markupTypes = this.portletDescription.getMarkupTypes();
        this.markupRequest = this.createMarkupRequestFrom(markupTypes, params, this.portlet);
        org.oasis.wsrp.v2.UserContext wsrpUserContext = this.getUserContext();
        this.checkUserContext(wsrpUserContext);
        SecurityContext securityContext = this.createSecurityContext(params, runtimeContext, wsrpUserContext);
        MarkupInfo streamInfo = this.createStreamInfo(this.markupRequest);
        PortalContext portalContext = this.createPortalContext(params, this.markupRequest);
        UserContext userContext = this.createUserContext(wsrpUserContext, this.markupRequest.getLocale(), desiredLocales);
        String portletInstanceKey = runtimeContext.getPortletInstanceKey();
        this.instanceContext = this.createInstanceContext(portletContext, this.getAccessMode(), portletInstanceKey);
        WindowContext windowContext = this.createWindowContext(portletContext.getId(), runtimeContext);
        WSRPPortletInvocationContext context = new WSRPPortletInvocationContext(streamInfo, securityContext, portalContext, userContext, this.instanceContext, windowContext);
        PortletInvocation invocation = this.initInvocation(context);
        invocation.setTarget(this.portlet.getContext());
        invocation.setWindowState(WSRPUtils.getJSR168WindowStateFromWSRPName((String)this.markupRequest.getWindowState()));
        invocation.setMode(WSRPUtils.getJSR168PortletModeFromWSRPName((String)this.markupRequest.getMode()));
        NavigationalContext navigationalContext = params.getNavigationalContext();
        if (navigationalContext != null) {
            StateString navigationalState = this.createNavigationalState(navigationalContext.getOpaqueValue());
            invocation.setNavigationalState(navigationalState);
            List publicParams = navigationalContext.getPublicValues();
            if (ParameterValidation.existsAndIsNotEmpty((Collection)publicParams)) {
                Map publicNS = WSRPUtils.createPublicNSFrom((List)publicParams);
                invocation.setPublicNavigationalState(publicNS);
            }
        }
        context.contextualize(invocation);
        this.setInvocation(invocation);
    }

    abstract RegistrationContext getRegistrationContext();

    abstract RuntimeContext getRuntimeContext();

    abstract MimeRequest getParams();

    public abstract PortletContext getPortletContext();

    abstract org.oasis.wsrp.v2.UserContext getUserContext();

    abstract String getContextName();

    abstract AccessMode getAccessMode() throws MissingParameters;

    abstract PortletInvocation initInvocation(WSRPPortletInvocationContext var1);

    public abstract Response processResponse(PortletInvocationResponse var1);

    private MarkupRequest createMarkupRequestFrom(List<MarkupType> markupTypes, MimeRequest params, Portlet portlet) throws UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        String windowState;
        String mode;
        List desiredMIMETypes = params.getMimeTypes();
        MarkupType markupType = null;
        for (String desiredMIMEType : desiredMIMETypes) {
            if ("*".equals(desiredMIMEType = desiredMIMEType.trim()) || "*/*".equals(desiredMIMEType)) {
                markupType = markupTypes.get(0);
                break;
            }
            MediaType mt = MediaType.create((String)desiredMIMEType);
            String superType = mt.getType().getName();
            String subType = mt.getSubtype().getName();
            boolean isWildcard = "*".equals(subType);
            for (MarkupType type : markupTypes) {
                if (isWildcard && type.getMimeType().startsWith(superType)) {
                    markupType = type;
                    break;
                }
                if (!desiredMIMEType.equals(type.getMimeType())) continue;
                markupType = type;
                break;
            }
            if (markupType == null) continue;
            break;
        }
        if (markupType == null) {
            throw (UnsupportedMimeType)WSRP2ExceptionFactory.throwWSException(UnsupportedMimeType.class, (String)("None of the specified MIME types are supported by portlet '" + portlet.getContext().getId() + "'"), null);
        }
        List locales = params.getLocales();
        ArrayList supportedLocales = new ArrayList(markupType.getLocales());
        if (supportedLocales != null) {
            markupType.getLocales().clear();
            boolean found = false;
            for (String locale : locales) {
                for (String supportedLocale : supportedLocales) {
                    if (!locale.equals(supportedLocale)) continue;
                    markupType.getLocales().add(locale);
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (!found) {
                markupType.getLocales().addAll(locales);
            }
        } else {
            markupType.getLocales().addAll(locales);
        }
        try {
            mode = this.getMatchingOrFailFrom(markupType.getModes(), params.getMode(), PORTLET_MODE);
        }
        catch (IllegalArgumentException e) {
            throw (UnsupportedMode)WSRP2ExceptionFactory.throwWSException(UnsupportedMode.class, (String)("Unsupported mode '" + params.getMode() + "'"), (Throwable)e);
        }
        try {
            windowState = this.getMatchingOrFailFrom(markupType.getWindowStates(), params.getWindowState(), WINDOW_STATE);
        }
        catch (IllegalArgumentException e) {
            throw (UnsupportedWindowState)WSRP2ExceptionFactory.throwWSException(UnsupportedWindowState.class, (String)("Unsupported window state '" + params.getWindowState() + "'"), (Throwable)e);
        }
        String characterSet = this.getMatchingOrDefaultFrom(Collections.<String>emptyList(), params.getMarkupCharacterSets(), "UTF-8");
        return new MarkupRequest(markupType, mode, windowState, characterSet, portlet);
    }

    private String getMatchingOrFailFrom(List<String> possibleValues, String desired, String valueType) throws IllegalArgumentException {
        if (possibleValues.contains(desired)) {
            return desired;
        }
        throw new IllegalArgumentException(desired + " is not a supported " + valueType);
    }

    private String getMatchingOrDefaultFrom(List<String> possibleValues, List<String> preferredValues, String defaultValue) {
        if (preferredValues != null && possibleValues != null) {
            for (String preferredValue : preferredValues) {
                if (!possibleValues.contains(preferredValue)) continue;
                return preferredValue;
            }
        }
        return defaultValue;
    }

    private void checkUserContext(org.oasis.wsrp.v2.UserContext wsrpUserContext) throws MissingParameters {
        if (wsrpUserContext != null) {
            WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)wsrpUserContext.getUserContextKey(), (String)"User Context Key", (String)"UserContext");
        }
    }

    private void checkForSessionIDs(RuntimeContext runtimeContext) throws OperationFailed {
        SessionParams sessionParams = runtimeContext.getSessionParams();
        if (sessionParams != null && sessionParams.getSessionID() != null) {
            Utils.throwOperationFaultOnSessionOperation();
        }
    }

    protected StateString createNavigationalState(String navigationalState) {
        if (navigationalState == null) {
            return null;
        }
        return StateString.create((String)navigationalState);
    }

    private WSRPInstanceContext createInstanceContext(org.gatein.pc.api.PortletContext portletContext, AccessMode accessMode, String instanceId) {
        return new WSRPInstanceContext(portletContext, accessMode, instanceId);
    }

    private WindowContext createWindowContext(String portletHandle, RuntimeContext runtimeContext) {
        String namespacePrefix;
        String id = runtimeContext.getPortletInstanceKey();
        if (ParameterValidation.isNullOrEmpty((String)id)) {
            id = portletHandle;
        }
        if (ParameterValidation.isNullOrEmpty((String)(namespacePrefix = runtimeContext.getNamespacePrefix()))) {
            namespacePrefix = PortletUtils.generateNamespaceFrom((String)portletHandle);
        }
        return new WSRPWindowContext(id, namespacePrefix);
    }

    private UserContext createUserContext(org.oasis.wsrp.v2.UserContext userContext, String preferredLocale, List<String> supportedLocales) {
        return UserContextConverter.createPortalUserContextFrom((org.oasis.wsrp.v2.UserContext)userContext, supportedLocales, (String)preferredLocale);
    }

    private PortalContext createPortalContext(final MimeRequest params, final MarkupRequest markupRequest) {
        return new PortalContext(){

            public String getInfo() {
                return PortalContext.VERSION.toString();
            }

            public Set<WindowState> getWindowStates() {
                List validNewWindowStates = params.getValidNewWindowStates();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)validNewWindowStates)) {
                    HashSet<WindowState> states = new HashSet<WindowState>(validNewWindowStates.size());
                    for (String state : validNewWindowStates) {
                        states.add(WSRPUtils.getJSR168WindowStateFromWSRPName((String)state));
                    }
                    return states;
                }
                return markupRequest.getSupportedWindowStates();
            }

            public Set<Mode> getModes() {
                List validNewModes = params.getValidNewModes();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)validNewModes)) {
                    HashSet<Mode> modes = new HashSet<Mode>(validNewModes.size());
                    for (String mode : validNewModes) {
                        modes.add(WSRPUtils.getJSR168PortletModeFromWSRPName((String)mode));
                    }
                    return modes;
                }
                return markupRequest.getSupportedModes();
            }

            public Map<String, String> getProperties() {
                return Collections.emptyMap();
            }
        };
    }

    private MarkupInfo createStreamInfo(MarkupRequest markupRequest) throws UnsupportedMimeType {
        MarkupInfo markupInfo;
        try {
            markupInfo = new MarkupInfo(MediaType.create((String)markupRequest.getMediaType()), markupRequest.getCharacterSet());
        }
        catch (IllegalArgumentException e) {
            throw (UnsupportedMimeType)WSRP2ExceptionFactory.throwWSException(UnsupportedMimeType.class, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return markupInfo;
    }

    private SecurityContext createSecurityContext(final MimeRequest params, final RuntimeContext runtimeContext, final org.oasis.wsrp.v2.UserContext wsrpUserContext) {
        return new SecurityContext(){

            public boolean isSecure() {
                return params.isSecureClientCommunication();
            }

            public String getAuthType() {
                return runtimeContext.getUserAuthentication();
            }

            public String getRemoteUser() {
                if (wsrpUserContext != null) {
                    return wsrpUserContext.getUserContextKey();
                }
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }

            public boolean isUserInRole(String roleName) {
                return wsrpUserContext != null && wsrpUserContext.getUserCategories().contains(roleName);
            }

            public boolean isAuthenticated() {
                return wsrpUserContext != null;
            }
        };
    }

    public PortletInvocation getInvocation() {
        return this.invocation;
    }

    public void setInvocation(PortletInvocation invocation) {
        this.invocation = invocation;
    }
}

