/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.caja.lexer.ParseException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.caja.CajaCssLexerParser;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.ContentRewriterUris;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.apache.shindig.gadgets.rewrite.RequestRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssRequestRewriter
implements RequestRewriter {
    private static final Logger logger = Logger.getLogger(CssRequestRewriter.class.getName());
    private final ContentRewriterFeatureFactory rewriterFeatureFactory;
    private final CajaCssLexerParser cssParser;
    private final ContentRewriterUris rewriterUris;
    private final ContainerConfig config;
    static final String CONTENT_REWRITE_KEY = "gadgets.content-rewrite";
    static final String PROXY_URL_KEY = "proxy-url";

    @Inject
    public CssRequestRewriter(ContentRewriterFeatureFactory rewriterFeatureFactory, ContentRewriterUris rewriterUris, CajaCssLexerParser cssParser, ContainerConfig config) {
        this.rewriterFeatureFactory = rewriterFeatureFactory;
        this.rewriterUris = rewriterUris;
        this.cssParser = cssParser;
        this.config = config;
    }

    @Override
    public boolean rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        if (!RewriterUtils.isCss(request, original)) {
            return false;
        }
        ContentRewriterFeature feature = this.rewriterFeatureFactory.get(request);
        String css = content.getContent();
        StringWriter sw = new StringWriter(css.length() * 110 / 100);
        this.rewrite(new StringReader(css), request.getUri(), this.createLinkRewriter(request.getGadget(), feature, request.getContainer()), sw, false);
        content.setContent(sw.toString());
        return true;
    }

    public List<String> rewrite(Reader content, Uri source, LinkRewriter rewriter, Writer writer, boolean extractImports) {
        try {
            String original = IOUtils.toString((Reader)content);
            try {
                List<Object> stylesheet = this.cssParser.parse(original);
                List<String> stringList = CssRequestRewriter.rewrite(stylesheet, source, rewriter, extractImports);
                this.cssParser.serialize(stylesheet, writer);
                return stringList;
            }
            catch (GadgetException ge) {
                if (ge.getCause() instanceof ParseException) {
                    logger.log(Level.WARNING, "Caja CSS parse failure: " + ge.getCause().getMessage() + " for " + source);
                    writer.write(original);
                    return Collections.emptyList();
                }
                throw new RuntimeException(ge);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public List<String> rewrite(Element styleNode, Uri source, LinkRewriter rewriter, boolean extractImports) {
        try {
            List<Object> stylesheet = this.cssParser.parse(styleNode.getTextContent());
            List<String> imports = CssRequestRewriter.rewrite(stylesheet, source, rewriter, extractImports);
            String content = this.cssParser.serialize(stylesheet);
            if (StringUtils.isEmpty((String)content) || StringUtils.isWhitespace((String)content)) {
                styleNode.getParentNode().removeChild(styleNode);
            } else {
                styleNode.setTextContent(content);
            }
            return imports;
        }
        catch (GadgetException ge) {
            if (ge.getCause() instanceof ParseException) {
                logger.log(Level.WARNING, "Caja CSS parse failure: " + ge.getCause().getMessage() + " for " + source);
                return Collections.emptyList();
            }
            throw new RuntimeException(ge);
        }
    }

    public static List<String> rewrite(List<Object> styleSheet, Uri source, LinkRewriter rewriter, boolean extractImports) {
        LinkedList imports = Lists.newLinkedList();
        for (int i = styleSheet.size() - 1; i >= 0; --i) {
            if (styleSheet.get(i) instanceof CajaCssLexerParser.ImportDecl) {
                if (extractImports) {
                    imports.add(0, ((CajaCssLexerParser.ImportDecl)styleSheet.get(i)).getUri());
                    styleSheet.remove(i);
                    continue;
                }
                CajaCssLexerParser.ImportDecl importDecl = (CajaCssLexerParser.ImportDecl)styleSheet.get(i);
                importDecl.setUri(rewriter.rewrite(importDecl.getUri(), source));
                continue;
            }
            if (!(styleSheet.get(i) instanceof CajaCssLexerParser.UriDecl)) continue;
            CajaCssLexerParser.UriDecl uriDecl = (CajaCssLexerParser.UriDecl)styleSheet.get(i);
            uriDecl.setUri(rewriter.rewrite(uriDecl.getUri(), source));
        }
        return imports;
    }

    protected LinkRewriter createLinkRewriter(Uri gadgetUri, ContentRewriterFeature feature, String container) {
        Object contentRewrite = this.config.getProperty(container, CONTENT_REWRITE_KEY);
        String proxy = null;
        if (contentRewrite instanceof JSONObject) {
            try {
                proxy = ((JSONObject)contentRewrite).getString(PROXY_URL_KEY);
            }
            catch (JSONException e) {
                return null;
            }
        } else {
            proxy = ((ImmutableMap)contentRewrite).get((Object)PROXY_URL_KEY).toString();
        }
        return new ProxyingLinkRewriter(gadgetUri, feature, proxy);
    }
}

