/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.IngresSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.OracleDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.PgSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DefaultOracleConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.HSQLDBConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MySQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.OracleConnectionFactory;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

public class CQJDBCWorkspaceDataContainer
extends JDBCWorkspaceDataContainer
implements Startable {
    public CQJDBCWorkspaceDataContainer(WorkspaceEntry wsConfig, RepositoryEntry repConfig, InitialContextInitializer contextInit, ValueStoragePluginProvider valueStorageProvider, FileCleanerHolder fileCleanerHolder) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        super(wsConfig, repConfig, contextInit, valueStorageProvider, fileCleanerHolder);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initDatabase() throws NamingException, RepositoryException, IOException {
        DataSource ds;
        Object var1_1 = null;
        String sqlPath = null;
        if (this.dbDialect == DBConstants.DB_DIALECT_ORACLEOCI) {
            LOG.warn((Object)(DBConstants.DB_DIALECT_ORACLEOCI + " dialect is experimental!"));
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new DefaultOracleConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner, this.useQueryHints);
            } else {
                this.connFactory = new OracleConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner, this.useQueryHints);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ora.sql";
            OracleDBInitializer oracleDBInitializer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_ORACLE) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new DefaultOracleConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner, this.useQueryHints);
            } else {
                this.connFactory = new DefaultOracleConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner, this.useQueryHints);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ora.sql";
            OracleDBInitializer oracleDBInitializer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_PGSQL) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.pgsql.sql";
            PgSQLDBInitializer pgSQLDBInitializer = new PgSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new MySQLConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            } else {
                this.connFactory = new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mysql.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL_UTF8) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new MySQLConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            } else {
                this.connFactory = new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mysql-utf8.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MSSQL) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.mssql.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DERBY) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.derby.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.db2.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2V8) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.db2v8.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_SYBASE) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.sybase.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_INGRES) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.ingres.sql";
            IngresSQLDBInitializer ingresSQLDBInitializer = new IngresSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_HSQLDB) {
            if (this.dbSourceName != null) {
                ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                this.connFactory = new HSQLDBConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            } else {
                this.connFactory = new HSQLDBConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        } else {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = "/conf/storage/jcr-" + (this.multiDb ? "m" : "s") + "jdbc.sql";
            StorageDBInitializer storageDBInitializer = this.defaultDBInitializer(sqlPath);
        }
        try {
            void var1_15;
            var1_15.init();
            return;
        }
        catch (DBInitializerException e) {
            LOG.error((Object)("Error of init db " + e), (Throwable)e);
        }
    }

    protected GenericConnectionFactory defaultConnectionFactory() throws NamingException, RepositoryException {
        if (this.dbSourceName != null) {
            DataSource ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
            if (ds != null) {
                return new GenericCQConnectionFactory(ds, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
        }
        return new GenericCQConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
    }
}

