/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.fckeditor;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FCKMessage {
    public static final String ERROR = "Error".intern();
    public static final String INFO = "Info".intern();
    public static final int FOLDER_CREATED = 100;
    public static final int FOLDER_EXISTED = 101;
    public static final int FOLDER_INVALID_NAME = 102;
    public static final int FOLDER_PERMISSION_CREATING = 103;
    public static final int FOLDER_NOT_CREATED = 104;
    public static final int UNKNOWN_ERROR = 110;
    public static final int FILE_EXISTED = 201;
    public static final int FILE_NOT_FOUND = 202;
    public static final int FILE_UPLOAD_RESTRICTION = 203;
    public static final int FILE_NOT_UPLOADED = 204;
    public static final String FCK_RESOURCE_BUNDLE_FILE = "locale.services.fckeditor.FCKConnector".intern();

    public Document createMessage(int messageCode, String messageType, String language, Object[] args) throws Exception {
        String message = this.getMessage(messageCode, args, language);
        return this.createMessage(messageCode, message, messageType);
    }

    public Document createMessage(int messageCode, String message, String messageType) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("Message");
        element.setAttribute("number", Integer.toString(messageCode));
        element.setAttribute("text", message);
        element.setAttribute("type", messageType);
        document.appendChild(element);
        return document;
    }

    public String getMessage(int messageNum, Object[] args, String language) throws Exception {
        String messageKey = this.getMessageKey(messageNum);
        return this.getMessage(messageKey, args, language);
    }

    public String getMessage(String messageKey, Object[] args, String language) throws Exception {
        Locale locale = null;
        locale = language == null ? Locale.ENGLISH : new Locale(language);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(FCK_RESOURCE_BUNDLE_FILE, locale);
        String message = resourceBundle.getString(messageKey);
        if (args == null) {
            return message;
        }
        return MessageFormat.format(message, args);
    }

    protected String getMessageKey(int number) {
        String messageKey = null;
        switch (number) {
            case 100: {
                messageKey = "fckeditor.folder-created";
                break;
            }
            case 104: {
                messageKey = "fckeditor.folder-not-created";
                break;
            }
            case 102: {
                messageKey = "fckeditor.folder-invalid-name";
                break;
            }
            case 101: {
                messageKey = "fckeditor.folder-existed";
                break;
            }
            case 103: {
                messageKey = "fckeditor.folder-permission-denied";
                break;
            }
            case 201: {
                messageKey = "fckeditor.file-existed";
                break;
            }
            case 202: {
                messageKey = "fckeditor.file-not-found";
                break;
            }
            case 204: {
                messageKey = "fckeditor.file-not-uploaded";
                break;
            }
            case 203: {
                messageKey = "fckeditor.file-uploaded-restriction";
                break;
            }
            default: {
                messageKey = "connector.fckeditor.unknowm-message";
            }
        }
        return messageKey;
    }
}

