/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.tag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.tag.TaggedImage;

public class TaggedDocument
implements Serializable {
    private String origin;
    private int currentPageIndex;
    private List allImages;
    private transient List currentImages;

    TaggedDocument(String origin) {
        this.origin = origin;
        this.allImages = new ArrayList(32);
        this.currentImages = new ArrayList(4);
    }

    public String getOrigin() {
        return this.origin;
    }

    public List getImages() {
        return this.allImages;
    }

    void setCurrentPageIndex(int currentPageIndex) {
        this.currentPageIndex = currentPageIndex;
    }

    void beginImage(Reference ref, boolean inlineImage) {
        TaggedImage ti = this.findImage(ref);
        if (ti == null) {
            ti = new TaggedImage(ref, inlineImage);
            this.allImages.add(ti);
        }
        this.currentImages.add(ti);
        ti.addPage(this.currentPageIndex);
    }

    private TaggedImage findImage(Reference ref) {
        if (ref == null) {
            return null;
        }
        for (int i = this.allImages.size() - 1; i >= 0; --i) {
            TaggedImage ti = (TaggedImage)this.allImages.get(i);
            if (ti.getReference() == null || !ti.getReference().equals(ref)) continue;
            return ti;
        }
        return null;
    }

    void endImage(Reference ref) {
        this.currentImages.remove(this.currentImages.size() - 1);
    }

    void tagImage(String tag) {
        TaggedImage ti = (TaggedImage)this.currentImages.get(this.currentImages.size() - 1);
        ti.tag(tag);
    }

    String describe() {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("ORIGIN: ");
        sb.append(this.origin);
        sb.append("\n");
        for (TaggedImage ti : this.allImages) {
            sb.append(ti.describe());
            sb.append("---------------------------------\n");
        }
        return sb.toString();
    }
}

