/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.xcmis.search.lucene.index.ConcurrentDirectoryFactory;
import org.xcmis.search.lucene.index.TransactionLogException;

public class ReentrantDirectoryFactory
implements ConcurrentDirectoryFactory {
    private final ConcurrentHashMap<String, Lock> locks = new ConcurrentHashMap();

    public File createFile(File dir, String fileName, int dirCount) throws IOException, TransactionLogException {
        File file = new File(dir, fileName);
        if (file.exists()) {
            throw new TransactionLogException("File already exist " + file.getAbsolutePath());
        }
        File[] dirs = new File[dirCount];
        File d = dir;
        for (int i = 0; i < dirCount; ++i) {
            if (d == null) {
                throw new NullPointerException("Parent directory is null.");
            }
            dirs[dirCount - 1 - i] = d;
            d = d.getParentFile();
        }
        if (!d.exists()) {
            throw new TransactionLogException("Storage " + d.getAbsolutePath() + " not exist. ");
        }
        return this.createFile(dirs, fileName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(File[] dirs, String fileName, int currentIndex) throws IOException, TransactionLogException {
        if (currentIndex < dirs.length) {
            File dir = dirs[currentIndex];
            this.lock(dir.getAbsolutePath());
            try {
                if (!dir.exists() && !dir.mkdir()) {
                    throw new TransactionLogException(" Directory " + dir.getAbsolutePath() + " was not created. ");
                }
                File file = this.createFile(dirs, fileName, currentIndex + 1);
                return file;
            }
            finally {
                this.unlock(dir.getAbsolutePath());
            }
        }
        File file = new File(dirs[dirs.length - 1], fileName);
        file.createNewFile();
        return file;
    }

    private Lock getLockByPath(String dir) {
        ReentrantLock lock;
        Lock l = this.locks.get(dir);
        if (l == null && (l = this.locks.putIfAbsent(dir, lock = new ReentrantLock())) == null) {
            l = lock;
        }
        return l;
    }

    public void lock(String dir) {
        Lock l = this.getLockByPath(dir);
        l.lock();
    }

    public void lockRead(String dir) {
        throw new UnsupportedOperationException("Reentrant lock implementation do   not supports read locks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectory(File dir, int dirCount) throws TransactionLogException {
        String dirPath;
        if (dirCount > 0 && this.tryLock(dirPath = dir.getAbsolutePath())) {
            try {
                if (dir.exists() && dir.list().length == 0) {
                    File parent = dir.getParentFile();
                    if (!dir.delete()) {
                        throw new TransactionLogException("Directory was not removed " + dir.getAbsolutePath());
                    }
                    this.removeDirectory(parent, dirCount - 1);
                }
            }
            finally {
                this.unlock(dirPath);
            }
        }
    }

    public boolean tryLock(String dir) {
        Lock l = this.getLockByPath(dir);
        return l.tryLock();
    }

    public void unlock(String dir) {
        Lock l = this.getLockByPath(dir);
        l.unlock();
    }

    public void unlockRead(String dir) {
        throw new UnsupportedOperationException("Reentrant lock implementation do not supports read locks");
    }
}

