/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecms.xcmis.sp.JcrNodeEntry;
import org.exoplatform.ecms.xcmis.sp.NotSupportedNodeTypeException;
import org.exoplatform.ecms.xcmis.sp.PropertyDefinitions;
import org.exoplatform.ecms.xcmis.sp.StorageConfiguration;
import org.exoplatform.ecms.xcmis.sp.SymLinkNodeEntry;
import org.exoplatform.ecms.xcmis.sp.TypeMapping;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.BaseItemsIterator;
import org.xcmis.spi.CmisConstants;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeManager;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.Choice;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.DateResolution;
import org.xcmis.spi.model.Precision;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.VersioningState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseJcrStorage
implements TypeManager {
    private static final Log LOG = ExoLogger.getExoLogger(BaseJcrStorage.class);
    public static final String XCMIS_PROPERTY_TYPE = "_xcmis_property_type";
    public static final Pattern XCMIS_PROPERTY_TYPE_PATTERN = Pattern.compile(".*_xcmis_property_type");
    public static final String XCMIS_SYSTEM_PATH = "/xcmis:system";
    public static final String XCMIS_WORKING_COPIES = "xcmis:workingCopyStore";
    public static final String XCMIS_RELATIONSHIPS = "xcmis:relationshipStore";
    public static final String XCMIS_POLICIES = "xcmis:policiesStore";
    public static final String LATEST_LABEL = "latest";
    public static final String PWC_LABEL = "pwc";
    public static final String VENDOR_NAME = "eXo";
    public static final String PRODUCT_NAME = "xCMIS (eXo SP)";
    public static final String PRODUCT_VERSION = "1.1";
    public static final String REPOSITORY_DESCRIPTION = "xCMIS (eXo SP)";
    static final Set<Pattern> IGNORED_PROPERTIES = new HashSet<Pattern>();
    protected Session session;
    protected StorageConfiguration storageConfiguration;
    protected Map<String, TypeMapping> nodeTypeMapping;
    protected final String rootPath;

    public BaseJcrStorage(Session session, StorageConfiguration storageConfiguration, Map<String, TypeMapping> nodeTypeMapping) {
        this.session = session;
        this.storageConfiguration = storageConfiguration;
        this.nodeTypeMapping = nodeTypeMapping;
        String rootPath = storageConfiguration.getRootNodePath();
        if (rootPath.contains("${userId}")) {
            String userId = session.getUserID();
            rootPath = rootPath.replace("${userId}", userId);
        }
        this.rootPath = rootPath;
    }

    public StorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public String addType(TypeDefinition type) throws ConstraintException, StorageException {
        try {
            NodeTypeValue nodeTypeValue = new NodeTypeValue();
            String parentId = type.getParentId();
            if (parentId == null) {
                String msg = "Unable add root type. Parent Type Id must be specified.";
                throw new InvalidArgumentException(msg);
            }
            TypeDefinition parentType = null;
            try {
                parentType = this.getTypeDefinition(parentId, false);
            }
            catch (TypeNotFoundException tnfe) {
                throw new ConstraintException("Parent type " + parentId + " does not exist");
            }
            ArrayList<String> declaredSupertypeNames = new ArrayList<String>();
            declaredSupertypeNames.add(parentType.getLocalName());
            if (parentType.getBaseId() == BaseType.DOCUMENT) {
                declaredSupertypeNames.add("cmis:document");
            } else if (parentType.getBaseId() == BaseType.FOLDER) {
                declaredSupertypeNames.add("cmis:folder");
            }
            nodeTypeValue.setDeclaredSupertypeNames(declaredSupertypeNames);
            nodeTypeValue.setMixin(false);
            nodeTypeValue.setName(type.getId());
            nodeTypeValue.setOrderableChild(false);
            nodeTypeValue.setPrimaryItemName("");
            ArrayList<PropertyDefinitionValue> jcrPropDefintions = null;
            if (type.getPropertyDefinitions() != null && type.getPropertyDefinitions().size() > 0) {
                jcrPropDefintions = new ArrayList<PropertyDefinitionValue>();
                for (org.xcmis.spi.model.PropertyDefinition propDef : type.getPropertyDefinitions()) {
                    if (propDef.getPropertyType() == null) {
                        String msg = "Property Type required.";
                        throw new InvalidArgumentException(msg);
                    }
                    if (parentType.getPropertyDefinition(propDef.getId()) != null) {
                        throw new InvalidArgumentException("Property " + propDef.getId() + " already defined");
                    }
                    if (XCMIS_PROPERTY_TYPE_PATTERN.matcher(propDef.getId()).matches()) {
                        throw new InvalidArgumentException("Unacceptable property definition name " + propDef.getId() + " type " + type.getId());
                    }
                    PropertyDefinitionValue jcrPropDef = new PropertyDefinitionValue();
                    ArrayList<String> defaultValues = null;
                    switch (propDef.getPropertyType()) {
                        case BOOLEAN: {
                            jcrPropDef.setRequiredType(6);
                            Boolean[] booleans = (Boolean[])propDef.getDefaultValue();
                            if (booleans == null || booleans.length <= 0) break;
                            defaultValues = new ArrayList<String>(booleans.length);
                            for (Boolean v : booleans) {
                                defaultValues.add(v.toString());
                            }
                            break;
                        }
                        case DATETIME: {
                            jcrPropDef.setRequiredType(5);
                            Calendar[] dates = (Calendar[])propDef.getDefaultValue();
                            if (dates == null || dates.length <= 0) break;
                            defaultValues = new ArrayList(dates.length);
                            for (Calendar v : dates) {
                                defaultValues.add(this.createJcrDate(v));
                            }
                            break;
                        }
                        case DECIMAL: {
                            jcrPropDef.setRequiredType(4);
                            BigDecimal[] decimals = (BigDecimal[])propDef.getDefaultValue();
                            if (decimals == null || decimals.length <= 0) break;
                            defaultValues = new ArrayList(decimals.length);
                            for (BigDecimal v : decimals) {
                                defaultValues.add(Double.toString(v.doubleValue()));
                            }
                            break;
                        }
                        case INTEGER: {
                            jcrPropDef.setRequiredType(3);
                            BigInteger[] ints = (BigInteger[])propDef.getDefaultValue();
                            if (ints == null || ints.length <= 0) break;
                            defaultValues = new ArrayList(ints.length);
                            for (BigInteger v : ints) {
                                defaultValues.add(Long.toString(v.longValue()));
                            }
                            break;
                        }
                        case ID: 
                        case HTML: 
                        case URI: 
                        case STRING: {
                            jcrPropDef.setRequiredType(1);
                            String[] str = (String[])propDef.getDefaultValue();
                            if (str == null || str.length <= 0) break;
                            defaultValues = new ArrayList(str.length);
                            for (String v : str) {
                                defaultValues.add(v);
                            }
                            break;
                        }
                    }
                    if (defaultValues != null) {
                        jcrPropDef.setDefaultValueStrings(defaultValues);
                        jcrPropDef.setAutoCreate(true);
                    } else {
                        jcrPropDef.setAutoCreate(false);
                    }
                    jcrPropDef.setMandatory(propDef.isRequired());
                    jcrPropDef.setMultiple(propDef.isMultivalued());
                    jcrPropDef.setName(propDef.getId());
                    jcrPropDef.setOnVersion(1);
                    jcrPropDef.setReadOnly(false);
                    jcrPropDefintions.add(jcrPropDef);
                    if (propDef.getPropertyType() != PropertyType.ID && propDef.getPropertyType() != PropertyType.HTML && propDef.getPropertyType() != PropertyType.URI) continue;
                    ArrayList<String> actualTypeStorage = new ArrayList<String>();
                    actualTypeStorage.add(propDef.getPropertyType().toString());
                    jcrPropDefintions.add(new PropertyDefinitionValue(propDef.getId() + XCMIS_PROPERTY_TYPE, false, false, 1, false, actualTypeStorage, false, 0, new ArrayList()));
                }
                nodeTypeValue.setDeclaredPropertyDefinitionValues(jcrPropDefintions);
            }
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
            NodeType nodeType = nodeTypeManager.registerNodeType(nodeTypeValue, 2);
            return nodeType.getName();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable add new CMIS type. " + re.getMessage(), (Throwable)re);
        }
    }

    private String createJcrDate(Calendar c) {
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
    }

    public ItemsIterator<TypeDefinition> getTypeChildren(String typeId, boolean includePropertyDefinitions) throws TypeNotFoundException {
        try {
            ArrayList<TypeDefinition> types = new ArrayList<TypeDefinition>();
            if (typeId == null) {
                for (String t : new String[]{"cmis:document", "cmis:folder", "cmis:policy", "cmis:relationship"}) {
                    types.add(this.getTypeDefinition(t, includePropertyDefinitions));
                }
            } else {
                TypeDefinition typeDefinition = this.getTypeDefinition(typeId, includePropertyDefinitions);
                String nodeTypeName = typeDefinition.getLocalName();
                NodeTypeManager nodeTypeManager = this.session.getWorkspace().getNodeTypeManager();
                NodeTypeIterator iter = nodeTypeManager.getPrimaryNodeTypes();
                while (iter.hasNext()) {
                    NodeType nt = iter.nextNodeType();
                    TypeMapping mapping = this.getTypeMapping(nt);
                    if (mapping == null && nt.isNodeType(nodeTypeName) && this.getTypeLevelHierarchy(nt, nodeTypeName) == 1) {
                        types.add(this.getTypeDefinition(nt, includePropertyDefinitions));
                        continue;
                    }
                    if (mapping == null || !mapping.getParentType().equals(typeId)) continue;
                    types.add(this.getTypeDefinition(mapping, nt, includePropertyDefinitions));
                }
            }
            return new BaseItemsIterator(types);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get type children. " + re.getMessage(), (Throwable)re);
        }
    }

    private int getTypeLevelHierarchy(NodeType discovered, String match) {
        int level = 0;
        for (NodeType sup : discovered.getSupertypes()) {
            if (!sup.isNodeType(match)) continue;
            ++level;
        }
        return level;
    }

    public TypeDefinition getTypeDefinition(String typeId, boolean includePropertyDefinition) throws TypeNotFoundException {
        typeId = this.getNodeType(typeId);
        try {
            NodeType nodeType = this.session.getWorkspace().getNodeTypeManager().getNodeType(typeId);
            return this.getTypeDefinition(nodeType, includePropertyDefinition);
        }
        catch (NoSuchNodeTypeException e) {
            throw new TypeNotFoundException("Type with id " + typeId + " not found in repository.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get object type " + typeId, (Throwable)re);
        }
    }

    private String getNodeType(String cmisTypeId) {
        if (cmisTypeId.equals("cmis:document")) {
            return "nt:file";
        }
        if (cmisTypeId.equals("cmis:folder")) {
            return "nt:folder";
        }
        return cmisTypeId;
    }

    public void removeType(String typeId) throws ConstraintException, TypeNotFoundException, StorageException {
        TypeDefinition typeDefinition = this.getTypeDefinition(typeId, false);
        if (typeDefinition.getParentId() == null) {
            throw new ConstraintException("Unable remove root type " + typeId);
        }
        try {
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
            nodeTypeManager.unregisterNodeType(typeDefinition.getLocalName());
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable remove CMIS type " + typeId + ". " + re.getMessage(), (Throwable)re);
        }
    }

    public Collection<TypeDefinition> getSubTypes(String typeId, boolean includePropertyDefinitions) throws TypeNotFoundException {
        ArrayList<TypeDefinition> subTypes = new ArrayList<TypeDefinition>();
        ItemsIterator<TypeDefinition> children = this.getTypeChildren(typeId, includePropertyDefinitions);
        while (children.hasNext()) {
            TypeDefinition type = (TypeDefinition)children.next();
            subTypes.add(type);
            Collection<TypeDefinition> cchildren = this.getSubTypes(type.getId(), includePropertyDefinitions);
            if (cchildren.size() <= 0) continue;
            subTypes.addAll(cchildren);
        }
        return subTypes;
    }

    public TypeDefinition getTypeDefinition(NodeType nodeType, boolean includePropertyDefinition) {
        TypeMapping mapping = this.getTypeMapping(nodeType);
        return this.getTypeDefinition(mapping, nodeType, includePropertyDefinition);
    }

    private TypeDefinition getTypeDefinition(TypeMapping mapping, NodeType nodeType, boolean includePropertyDefinition) {
        if (nodeType.isNodeType("nt:file")) {
            return this.getDocumentDefinition(nodeType, includePropertyDefinition);
        }
        if (nodeType.isNodeType("nt:folder") || mapping != null && mapping.getBaseType() == BaseType.FOLDER) {
            return this.getFolderDefinition(nodeType, includePropertyDefinition, mapping);
        }
        if (nodeType.isNodeType("cmis:relationship")) {
            return this.getRelationshipDefinition(nodeType, includePropertyDefinition);
        }
        if (nodeType.isNodeType("cmis:policy")) {
            return this.getPolicyDefinition(nodeType, includePropertyDefinition);
        }
        throw new NotSupportedNodeTypeException("Type " + nodeType.getName() + " is unsupported for xCMIS.");
    }

    private TypeDefinition getDocumentDefinition(NodeType nt, boolean includePropertyDefinition) {
        TypeDefinition def = new TypeDefinition();
        String localTypeName = nt.getName();
        String typeId = this.getCmisTypeId(localTypeName);
        def.setBaseId(BaseType.DOCUMENT);
        def.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        def.setControllableACL(true);
        def.setControllablePolicy(true);
        def.setCreatable(true);
        def.setDescription("Cmis Document Type");
        def.setDisplayName(typeId);
        def.setFileable(true);
        def.setFulltextIndexed(true);
        def.setId(typeId);
        def.setIncludedInSupertypeQuery(true);
        def.setLocalName(localTypeName);
        def.setLocalNamespace("");
        if (typeId.equals("cmis:document")) {
            def.setParentId(null);
        } else if (nt.isNodeType("nt:file")) {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = nt.getDeclaredSupertypes()) {
                if (!superType.isNodeType("nt:file")) continue;
                def.setParentId(this.getCmisTypeId(superType.getName()));
                break;
            }
        }
        def.setQueryable(true);
        def.setQueryName(typeId);
        def.setVersionable(true);
        if (includePropertyDefinition) {
            this.addPropertyDefinitions(def, nt);
        }
        return def;
    }

    private TypeDefinition getFolderDefinition(NodeType nt, boolean includePropertyDefinition, TypeMapping typeMapping) {
        TypeDefinition def = new TypeDefinition();
        String localTypeName = nt.getName();
        String typeId = this.getCmisTypeId(localTypeName);
        def.setBaseId(BaseType.FOLDER);
        def.setControllableACL(true);
        def.setControllablePolicy(true);
        def.setCreatable(true);
        def.setDescription("Cmis Folder Type");
        def.setDisplayName(typeId);
        def.setFileable(true);
        def.setFulltextIndexed(false);
        def.setId(typeId);
        def.setIncludedInSupertypeQuery(true);
        def.setLocalName(localTypeName);
        def.setLocalNamespace("");
        if (typeId.equals("cmis:folder")) {
            def.setParentId(null);
        } else if (nt.isNodeType("nt:folder")) {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = nt.getDeclaredSupertypes()) {
                if (!superType.isNodeType("nt:folder")) continue;
                def.setParentId(this.getCmisTypeId(superType.getName()));
                break;
            }
        } else {
            def.setParentId(typeMapping.getParentType());
        }
        def.setQueryable(true);
        def.setQueryName(typeId);
        if (includePropertyDefinition) {
            this.addPropertyDefinitions(def, nt);
        }
        return def;
    }

    TypeMapping getTypeMapping(NodeType nodeType) {
        if (this.nodeTypeMapping == null) {
            return null;
        }
        String nodeTypeName = nodeType.getName();
        TypeMapping tm = this.nodeTypeMapping.get(nodeTypeName);
        if (tm == null) {
            NodeType[] supertypes = nodeType.getSupertypes();
            for (int i = 0; i < supertypes.length && tm == null; ++i) {
                tm = this.nodeTypeMapping.get(supertypes[i].getName());
            }
        }
        return tm;
    }

    private TypeDefinition getPolicyDefinition(NodeType nt, boolean includePropertyDefinition) {
        TypeDefinition def = new TypeDefinition();
        String localTypeName = nt.getName();
        String typeId = this.getCmisTypeId(localTypeName);
        def.setBaseId(BaseType.POLICY);
        def.setControllableACL(true);
        def.setControllablePolicy(true);
        def.setCreatable(true);
        def.setDescription("Cmis Policy Type");
        def.setDisplayName(typeId);
        def.setFileable(false);
        def.setFulltextIndexed(false);
        def.setId(typeId);
        def.setIncludedInSupertypeQuery(false);
        def.setLocalName(localTypeName);
        def.setLocalNamespace("");
        if (typeId.equals(BaseType.POLICY.value())) {
            def.setParentId(null);
        } else {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = nt.getDeclaredSupertypes()) {
                if (!superType.isNodeType("cmis:policy")) continue;
                def.setParentId(this.getCmisTypeId(superType.getName()));
                break;
            }
        }
        def.setQueryable(false);
        def.setQueryName(typeId);
        if (includePropertyDefinition) {
            this.addPropertyDefinitions(def, nt);
        }
        return def;
    }

    private TypeDefinition getRelationshipDefinition(NodeType nt, boolean includePropertyDefinition) {
        TypeDefinition def = new TypeDefinition();
        String localTypeName = nt.getName();
        String typeId = this.getCmisTypeId(localTypeName);
        def.setBaseId(BaseType.RELATIONSHIP);
        def.setControllableACL(false);
        def.setControllablePolicy(false);
        def.setCreatable(true);
        def.setDescription("Cmis Relationship Type");
        def.setDisplayName(typeId);
        def.setFileable(false);
        def.setFulltextIndexed(false);
        def.setId(typeId);
        def.setIncludedInSupertypeQuery(false);
        def.setLocalName(localTypeName);
        def.setLocalNamespace("");
        if (typeId.equals(BaseType.RELATIONSHIP.value())) {
            def.setParentId(null);
        } else {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = nt.getDeclaredSupertypes()) {
                if (!superType.isNodeType("cmis:relationship")) continue;
                def.setParentId(this.getCmisTypeId(superType.getName()));
                break;
            }
        }
        def.setQueryable(false);
        def.setQueryName(typeId);
        if (includePropertyDefinition) {
            this.addPropertyDefinitions(def, nt);
        }
        return def;
    }

    private String getCmisTypeId(String ntName) {
        if (ntName.equals("nt:file")) {
            return "cmis:document";
        }
        if (ntName.equals("nt:folder")) {
            return "cmis:folder";
        }
        return ntName;
    }

    private void addPropertyDefinitions(TypeDefinition typeDefinition, NodeType nt) {
        HashMap pd = new HashMap(PropertyDefinitions.getAll(typeDefinition.getBaseId().value()));
        Set<String> knownIds = PropertyDefinitions.getPropertyIds(typeDefinition.getBaseId().value());
        PropertyDefinition[] propertyDefinitions = nt.getPropertyDefinitions();
        HashMap<String, PropertyDefinition> propertyDefinitionsMap = new HashMap<String, PropertyDefinition>(propertyDefinitions.length);
        for (PropertyDefinition propertyDefinition : propertyDefinitions) {
            propertyDefinitionsMap.put(propertyDefinition.getName(), propertyDefinition);
        }
        block11: for (PropertyDefinition jcrPropertyDef : propertyDefinitions) {
            String pdName = jcrPropertyDef.getName();
            boolean shouldBeIgnored = false;
            for (Pattern ignoredPattern : IGNORED_PROPERTIES) {
                if (!ignoredPattern.matcher(pdName).matches()) continue;
                shouldBeIgnored = true;
                break;
            }
            if (shouldBeIgnored || knownIds.contains(pdName)) continue;
            org.xcmis.spi.model.PropertyDefinition cmisPropDef = null;
            switch (jcrPropertyDef.getRequiredType()) {
                case 6: {
                    org.xcmis.spi.model.PropertyDefinition boolDef;
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    cmisPropDef = boolDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, PropertyType.BOOLEAN, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, null, jcrPropertyDef.isMultiple(), null, jcrDefaultValues != null ? this.createDefaultValues(jcrDefaultValues, new Boolean[jcrDefaultValues.length]) : null);
                    break;
                }
                case 5: {
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    org.xcmis.spi.model.PropertyDefinition dateDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, PropertyType.DATETIME, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, null, jcrPropertyDef.isMultiple(), null, jcrDefaultValues != null ? this.createDefaultValues(jcrDefaultValues, new Calendar[jcrDefaultValues.length]) : null);
                    dateDef.setDateResolution(DateResolution.TIME);
                    cmisPropDef = dateDef;
                    break;
                }
                case 4: {
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    org.xcmis.spi.model.PropertyDefinition decimalDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, PropertyType.DECIMAL, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, null, jcrPropertyDef.isMultiple(), null, jcrDefaultValues != null ? this.createDefaultValues(jcrDefaultValues, new BigDecimal[jcrDefaultValues.length]) : null);
                    decimalDef.setDecimalPrecision(Precision.Bit32);
                    decimalDef.setMaxDecimal(CmisConstants.MAX_DECIMAL_VALUE);
                    decimalDef.setMinDecimal(CmisConstants.MIN_DECIMAL_VALUE);
                    cmisPropDef = decimalDef;
                    break;
                }
                case 3: {
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    org.xcmis.spi.model.PropertyDefinition integerDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, PropertyType.INTEGER, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, null, jcrPropertyDef.isMultiple(), null, jcrDefaultValues != null ? this.createDefaultValues(jcrDefaultValues, new BigInteger[jcrDefaultValues.length]) : null);
                    integerDef.setMaxInteger(CmisConstants.MAX_INTEGER_VALUE);
                    integerDef.setMinInteger(CmisConstants.MIN_INTEGER_VALUE);
                    cmisPropDef = integerDef;
                    break;
                }
                case 1: 
                case 7: 
                case 8: 
                case 9: {
                    String[] vc;
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    ArrayList<Choice> choices = null;
                    Boolean openChoice = null;
                    if (1 == jcrPropertyDef.getRequiredType() && (vc = jcrPropertyDef.getValueConstraints()) != null && vc.length > 0) {
                        openChoice = false;
                        choices = new ArrayList<Choice>();
                        if (jcrPropertyDef.isMultiple()) {
                            ArrayList<String> vals = new ArrayList<String>();
                            for (String chVal : vc) {
                                if (".*".equals(chVal)) {
                                    openChoice = true;
                                    continue;
                                }
                                vals.add(chVal);
                            }
                            choices.add(new Choice((Object[])vals.toArray(new String[vals.size()]), ""));
                        } else {
                            for (String chVal : vc) {
                                if (".*".equals(chVal)) {
                                    openChoice = true;
                                    continue;
                                }
                                choices.add(new Choice((Object[])new String[]{chVal}, ""));
                            }
                        }
                    }
                    PropertyType propertyType = PropertyType.STRING;
                    if (propertyDefinitionsMap.containsKey(pdName + XCMIS_PROPERTY_TYPE)) {
                        try {
                            Value[] defaultValues = ((PropertyDefinition)propertyDefinitionsMap.get(pdName + XCMIS_PROPERTY_TYPE)).getDefaultValues();
                            if (defaultValues.length > 0) {
                                propertyType = PropertyType.fromValue((String)defaultValues[0].getString());
                            }
                        }
                        catch (IllegalStateException e) {
                            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (RepositoryException e) {
                            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    org.xcmis.spi.model.PropertyDefinition stringDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, propertyType, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, openChoice, jcrPropertyDef.isMultiple(), choices, jcrDefaultValues != null ? this.createDefaultValues(jcrDefaultValues, new String[jcrDefaultValues.length]) : null);
                    stringDef.setMaxLength(65536);
                    cmisPropDef = stringDef;
                    break;
                }
                default: {
                    continue block11;
                }
            }
            pd.put(cmisPropDef.getId(), cmisPropDef);
        }
        typeDefinition.setPropertyDefinitions(pd);
    }

    private <T> T[] createDefaultValues(Value[] jcrValues, T[] a) {
        try {
            Object[] tmp = new Object[jcrValues.length];
            block9: for (int i = 0; i < jcrValues.length; ++i) {
                Value v = jcrValues[i];
                switch (v.getType()) {
                    case 6: {
                        tmp[i] = v.getBoolean();
                        continue block9;
                    }
                    case 5: {
                        tmp[i] = v.getDate();
                        continue block9;
                    }
                    case 4: {
                        tmp[i] = BigDecimal.valueOf(v.getDouble());
                        continue block9;
                    }
                    case 3: {
                        tmp[i] = BigInteger.valueOf(v.getLong());
                        continue block9;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: 
                    case 9: {
                        tmp[i] = v.getString();
                    }
                }
            }
            System.arraycopy(tmp, 0, a, 0, tmp.length);
            return a;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property definition. " + re.getMessage(), (Throwable)re);
        }
    }

    public JcrNodeEntry createDocumentEntry(JcrNodeEntry parent, String name, TypeDefinition typeDefinition, VersioningState versioningState) throws NameConstraintViolationException, StorageException {
        try {
            Node parentNode = parent.getNode();
            if (parentNode.hasNode(name)) {
                throw new NameConstraintViolationException("Object with name " + name + " already exists in specified folder.");
            }
            Node document = parentNode.addNode(name, typeDefinition.getLocalName());
            if (!document.isNodeType("cmis:document")) {
                document.addMixin("cmis:document");
            }
            if (document.canAddMixin("mix:versionable")) {
                document.addMixin("mix:versionable");
            }
            return this.fromNode(document);
        }
        catch (ObjectNotFoundException onfe) {
            throw new StorageException(onfe.getMessage(), (Throwable)onfe);
        }
        catch (RepositoryException re) {
            throw new StorageException(re.getMessage(), (Throwable)re);
        }
    }

    public JcrNodeEntry createFolderEntry(JcrNodeEntry parent, String name, TypeDefinition typeDefinition) throws NameConstraintViolationException, StorageException {
        try {
            Node parentNode = parent.getNode();
            if (parentNode.hasNode(name)) {
                throw new NameConstraintViolationException("Object with name " + name + " already exists in specified folder.");
            }
            Node folderNode = parentNode.addNode(name, typeDefinition.getLocalName());
            if (!folderNode.isNodeType("cmis:folder")) {
                folderNode.addMixin("cmis:folder");
            }
            return this.fromNode(folderNode);
        }
        catch (ObjectNotFoundException onfe) {
            throw new StorageException(onfe.getMessage(), (Throwable)onfe);
        }
        catch (RepositoryException re) {
            throw new StorageException(re.getMessage(), (Throwable)re);
        }
    }

    public JcrNodeEntry createPolicyEntry(String name, TypeDefinition typeDefinition) throws NameConstraintViolationException, StorageException {
        try {
            Node policiesStore = (Node)this.session.getItem("/xcmis:system/xcmis:policiesStore");
            if (policiesStore.hasNode(name)) {
                throw new NameConstraintViolationException("Policy with name " + name + " already exists.");
            }
            Node policyNode = policiesStore.addNode(name, typeDefinition.getLocalName());
            return this.fromNode(policyNode);
        }
        catch (ObjectNotFoundException onfe) {
            throw new StorageException(onfe.getMessage(), (Throwable)onfe);
        }
        catch (RepositoryException re) {
            throw new StorageException(re.getMessage(), (Throwable)re);
        }
    }

    public JcrNodeEntry createRelationshipEntry(String name, TypeDefinition typeDefinition, JcrNodeEntry source, JcrNodeEntry target) throws NameConstraintViolationException, StorageException {
        try {
            Node relationships = (Node)this.session.getItem("/xcmis:system/xcmis:relationshipStore");
            if (relationships.hasNode(name)) {
                throw new NameConstraintViolationException("Relationship with name " + name + " already exists.");
            }
            Node relationshipNode = relationships.addNode(name, typeDefinition.getLocalName());
            relationshipNode.setProperty("cmis:sourceId", source.getNode());
            relationshipNode.setProperty("cmis:targetId", target.getNode());
            return this.fromNode(relationshipNode);
        }
        catch (ObjectNotFoundException onfe) {
            throw new StorageException(onfe.getMessage(), (Throwable)onfe);
        }
        catch (RepositoryException re) {
            throw new StorageException(re.getMessage(), (Throwable)re);
        }
    }

    public JcrNodeEntry getEntry(String id) throws ObjectNotFoundException {
        if (id == null) {
            throw new CmisRuntimeException("Id may not be null.");
        }
        try {
            Node node = ((ExtendedSession)this.session).getNodeByIdentifier(id);
            return this.fromNode(node);
        }
        catch (ItemNotFoundException nfe) {
            throw new ObjectNotFoundException("Object '" + id + "' does not exist.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    public JcrNodeEntry fromNode(Node node) throws ObjectNotFoundException {
        try {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            if (node.isNodeType("exo:symlink")) {
                Node link = node;
                try {
                    node = ((ExtendedSession)this.session).getNodeByIdentifier(node.getProperty("exo:uuid").getString());
                }
                catch (ItemNotFoundException e) {
                    throw new ObjectNotFoundException("Target of exo:symlink " + link.getPath() + " is not exist any more. ");
                }
                return new SymLinkNodeEntry(link, node, this);
            }
            return new JcrNodeEntry(node, this);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    public String getJcrRootPath() {
        return this.rootPath;
    }

    public boolean isSupportedNodeType(String nodeTypeName) {
        try {
            NodeType nodeType = this.session.getWorkspace().getNodeTypeManager().getNodeType(nodeTypeName);
            return nodeType.isNodeType("nt:file") || nodeType.isNodeType("nt:folder") || nodeType.isNodeType("cmis:policy") || nodeType.isNodeType("cmis:relationship") || this.getTypeMapping(nodeType) != null;
        }
        catch (NoSuchNodeTypeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public Map<String, TypeMapping> getNodeTypeMapping() {
        return this.nodeTypeMapping;
    }

    static {
        IGNORED_PROPERTIES.add(Pattern.compile("jcr:created"));
        IGNORED_PROPERTIES.add(Pattern.compile("jcr:mixinTypes"));
        IGNORED_PROPERTIES.add(Pattern.compile("jcr:uuid"));
        IGNORED_PROPERTIES.add(Pattern.compile("jcr:primaryType"));
        IGNORED_PROPERTIES.add(Pattern.compile("exo:owner"));
        IGNORED_PROPERTIES.add(Pattern.compile("\\*"));
        IGNORED_PROPERTIES.add(XCMIS_PROPERTY_TYPE_PATTERN);
    }
}

