/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.jcr;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LockManager {
    private static final Log LOG = ExoLogger.getExoLogger(LockManager.class);
    public static final String INIT_PARAM_CONCURRENCY_LEVEL = "concurrency-level";
    private static final int DEFAULT_CONCURRENCY_LEVEL = 64;
    private final ConcurrentMap<String, Lock> locks;

    private LockManager(int concurrencyLevel) {
        this.locks = new ConcurrentHashMap<String, Lock>(concurrencyLevel, 0.75f, concurrencyLevel);
    }

    public LockManager() {
        this(64);
    }

    public LockManager(InitParams params) {
        this(LockManager.getConcurrencyLevel(params));
    }

    private static int getConcurrencyLevel(InitParams ip) {
        try {
            return Integer.valueOf(ip.getValueParam(INIT_PARAM_CONCURRENCY_LEVEL).getValue());
        }
        catch (NullPointerException e) {
            LOG.debug((Object)"Parameter concurrency-level was not found in configuration, default 64 will be used.");
            return 64;
        }
        catch (Exception e) {
            LOG.error((Object)"Can't parse parameter concurrency-level", (Throwable)e);
            return 64;
        }
    }

    public Lock getLock(String type, String id) {
        String fullId = new StringBuilder(type.length() + id.length() + 1).append(type).append('-').append(id).toString();
        Lock lock = (Lock)this.locks.get(fullId);
        if (lock != null) {
            return lock;
        }
        lock = new InternalLock(fullId);
        Lock prevLock = this.locks.putIfAbsent(fullId, lock);
        if (prevLock != null) {
            lock = prevLock;
        }
        return lock;
    }

    private class InternalLock
    extends ReentrantLock {
        private static final long serialVersionUID = -3362387346368015145L;
        private final String fullId;

        public InternalLock(String fullId) {
            this.fullId = fullId;
        }

        public void unlock() {
            if (!this.hasQueuedThreads()) {
                LockManager.this.locks.remove(this.fullId, this);
            }
            super.unlock();
        }
    }
}

