/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.auditing;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditRecord;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/auditing/UIAuditingInfo.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIAuditingInfo
extends UIContainer
implements UIPopupComponent {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "AuditingInfoIterator");
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIAuditingInfo");

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getListRecords() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getRecords(), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public String getVersionName(AuditRecord ar) {
        String versionName;
        try {
            versionName = ar.getVersionName();
        }
        catch (Exception e) {
            versionName = null;
        }
        return versionName;
    }

    public List<AuditRecord> getRecords() throws Exception {
        List<Object> listRec = new ArrayList<AuditRecord>();
        Node currentNode = this.getCurrentNode();
        try {
            AuditService auditService = (AuditService)this.getApplicationComponent(AuditService.class);
            if (Utils.isAuditable((Node)currentNode) && auditService.hasHistory(currentNode)) {
                AuditHistory auHistory = auditService.getHistory(currentNode);
                listRec = auHistory.getAuditRecords();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        return listRec;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIAuditingInfo> {
        public void execute(Event<UIAuditingInfo> event) throws Exception {
            UIAuditingInfo uiAuditingInfo = (UIAuditingInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAuditingInfo.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }
}

