/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecms.xcmis.sp.BaseJcrStorage;
import org.exoplatform.ecms.xcmis.sp.NotSupportedNodeTypeException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.value.BooleanValue;
import org.exoplatform.services.jcr.impl.core.value.DateValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.LongValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.LazyIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.Permission;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.impl.BooleanProperty;
import org.xcmis.spi.model.impl.DateTimeProperty;
import org.xcmis.spi.model.impl.DecimalProperty;
import org.xcmis.spi.model.impl.HtmlProperty;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.model.impl.IntegerProperty;
import org.xcmis.spi.model.impl.StringProperty;
import org.xcmis.spi.model.impl.UriProperty;
import org.xcmis.spi.utils.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JcrNodeEntry {
    static final Set<String> SKIP_CHILD_ITEMS = new HashSet<String>();
    private static final Log LOG;
    protected Node node;
    protected final TypeDefinition type;
    protected BaseJcrStorage storage;

    JcrNodeEntry(Node node, BaseJcrStorage storage) throws RepositoryException {
        Session session = node.getSession();
        NodeType nodeType = null;
        nodeType = node.isNodeType("nt:frozenNode") ? session.getWorkspace().getNodeTypeManager().getNodeType(node.getProperty("jcr:frozenPrimaryType").getString()) : node.getPrimaryNodeType();
        this.node = node;
        this.type = storage.getTypeDefinition(nodeType, true);
        this.storage = storage;
    }

    String getId() {
        try {
            return ((ExtendedNode)this.node).getIdentifier();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get objects's id ." + re.getMessage(), (Throwable)re);
        }
    }

    String getName() {
        try {
            return this.node.getName();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable object's name. " + re.getMessage(), (Throwable)re);
        }
    }

    void setName(String name) throws NameConstraintViolationException {
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name can't be null or empty string.");
        }
        if (name.equals(this.getName())) {
            return;
        }
        try {
            if (this.node.getParent().hasNode(name)) {
                throw new NameConstraintViolationException("Object with name " + name + " already exists.");
            }
            if (name != null) {
                Session session = this.node.getSession();
                String srcPath = this.path();
                String destPath = srcPath.substring(0, srcPath.lastIndexOf(47) + 1) + name;
                session.move(srcPath, destPath);
                this.node = (Node)session.getItem(destPath);
            }
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set object name. " + re.getMessage(), (Throwable)re);
        }
    }

    TypeDefinition getType() {
        return this.type;
    }

    BaseType getBaseType() {
        return this.type.getBaseId();
    }

    String getPath() {
        String rootPath = this.storage.getJcrRootPath();
        String nodePath = this.path();
        if (rootPath.length() > 1 && rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        if (rootPath.equals(nodePath)) {
            return "/";
        }
        if (rootPath.length() > 1) {
            nodePath = nodePath.substring(rootPath.length());
        }
        return nodePath;
    }

    String path() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get JCR node path. " + re.getMessage(), (Throwable)re);
        }
    }

    boolean isRoot() {
        return "/".equals(this.getPath());
    }

    boolean isNew() {
        return this.node.isNew();
    }

    Collection<JcrNodeEntry> getPolicies() {
        HashSet<JcrNodeEntry> policies = new HashSet<JcrNodeEntry>();
        try {
            PropertyIterator iter = this.getNode().getProperties();
            while (iter.hasNext()) {
                javax.jcr.Property jcrProperty = iter.nextProperty();
                if (jcrProperty.getType() != 9) continue;
                try {
                    Node n = jcrProperty.getNode();
                    if (!n.getPrimaryNodeType().isNodeType("cmis:policy")) continue;
                    try {
                        policies.add(this.storage.fromNode(n));
                    }
                    catch (ObjectNotFoundException onfe) {
                    }
                }
                catch (ValueFormatException ignored) {}
            }
            return policies;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get object's policies. " + re.getMessage(), (Throwable)re);
        }
    }

    void applyPolicy(JcrNodeEntry policy) {
        try {
            String policyId = policy.getId();
            if (!this.node.hasProperty(policyId)) {
                this.node.setProperty(policyId, policy.getNode());
            }
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable apply policy. " + re.getMessage(), (Throwable)re);
        }
    }

    void removePolicy(JcrNodeEntry policy) {
        try {
            String policyId = policy.getId();
            this.node.setProperty(policyId, (Node)null);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable remove policy. " + re.getMessage(), (Throwable)re);
        }
    }

    List<org.xcmis.spi.model.AccessControlEntry> getACL() {
        try {
            if (this.getNode().isNodeType("exo:privilegeable")) {
                AccessControlList jcrACL = ((ExtendedNode)this.getNode()).getACL();
                HashMap<String, HashSet<String>> cache = new HashMap<String, HashSet<String>>();
                List jcrACEs = jcrACL.getPermissionEntries();
                for (AccessControlEntry ace : jcrACEs) {
                    String identity = ace.getIdentity();
                    HashSet<String> permissions = (HashSet<String>)cache.get(identity);
                    if (permissions == null) {
                        permissions = new HashSet<String>();
                        cache.put(identity, permissions);
                    }
                    permissions.add(ace.getPermission());
                }
                ArrayList<org.xcmis.spi.model.AccessControlEntry> cmisACL = new ArrayList<org.xcmis.spi.model.AccessControlEntry>(cache.size());
                for (String principal : cache.keySet()) {
                    org.xcmis.spi.model.AccessControlEntry cmisACE = new org.xcmis.spi.model.AccessControlEntry();
                    cmisACE.setPrincipal(principal);
                    Set values = (Set)cache.get(principal);
                    if (values.size() == PermissionType.ALL.length) {
                        cmisACE.getPermissions().add(Permission.BasicPermissions.CMIS_ALL.value());
                    } else if (values.contains("read") && values.contains("add_node")) {
                        cmisACE.getPermissions().add(Permission.BasicPermissions.CMIS_READ.value());
                    } else if (values.contains("set_property") && values.contains("remove")) {
                        cmisACE.getPermissions().add(Permission.BasicPermissions.CMIS_WRITE.value());
                    }
                    cmisACE.setDirect(Boolean.valueOf(true));
                    cmisACL.add(cmisACE);
                }
                return Collections.unmodifiableList(cmisACL);
            }
            return Collections.emptyList();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get objects's ACL. " + re.getMessage(), (Throwable)re);
        }
    }

    void setACL(List<org.xcmis.spi.model.AccessControlEntry> aces) {
        try {
            if (!this.node.isNodeType("exo:privilegeable")) {
                this.node.addMixin("exo:privilegeable");
            }
            ExtendedNode extNode = (ExtendedNode)this.node;
            extNode.clearACL();
            if (aces != null && aces.size() > 0) {
                extNode.setPermissions(this.createPermissionMap(aces));
            }
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable apply ACL. " + re.getMessage(), (Throwable)re);
        }
    }

    private Map<String, String[]> createPermissionMap(List<org.xcmis.spi.model.AccessControlEntry> source) {
        HashMap cache = new HashMap();
        for (org.xcmis.spi.model.AccessControlEntry ace : source) {
            String principal = ace.getPrincipal();
            HashSet<String> permissions = (HashSet<String>)cache.get(principal);
            if (permissions == null) {
                permissions = new HashSet<String>();
                cache.put(principal, permissions);
            }
            for (String perm : ace.getPermissions()) {
                if (Permission.BasicPermissions.CMIS_READ.value().equals(perm)) {
                    permissions.add("read");
                    permissions.add("add_node");
                    continue;
                }
                if (Permission.BasicPermissions.CMIS_WRITE.value().equals(perm)) {
                    permissions.add("set_property");
                    permissions.add("remove");
                    continue;
                }
                if (!Permission.BasicPermissions.CMIS_ALL.value().equals(perm)) continue;
                permissions.add("read");
                permissions.add("add_node");
                permissions.add("set_property");
                permissions.add("remove");
            }
        }
        HashMap<String, String[]> aces = new HashMap<String, String[]>();
        for (Map.Entry e : cache.entrySet()) {
            aces.put((String)e.getKey(), ((Set)e.getValue()).toArray(new String[((Set)e.getValue()).size()]));
        }
        return aces;
    }

    Collection<JcrNodeEntry> getRelationships(RelationshipDirection direction, TypeDefinition type, boolean includeSubRelationshipTypes) {
        HashSet<JcrNodeEntry> relationships = new HashSet<JcrNodeEntry>();
        HashSet<String> typeFilter = new HashSet<String>();
        typeFilter.add(type.getId());
        if (includeSubRelationshipTypes) {
            Collection<TypeDefinition> subTypes = null;
            try {
                subTypes = this.storage.getSubTypes(type.getId(), false);
            }
            catch (TypeNotFoundException e) {
                throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
            }
            for (TypeDefinition t : subTypes) {
                typeFilter.add(t.getId());
            }
        }
        try {
            PropertyIterator references = this.node.getReferences();
            while (references.hasNext()) {
                javax.jcr.Property prop = references.nextProperty();
                String propName = prop.getName();
                if ((direction != RelationshipDirection.EITHER || !propName.equals("cmis:sourceId") && !propName.equals("cmis:targetId")) && (direction != RelationshipDirection.SOURCE || !propName.equals("cmis:sourceId")) && (direction != RelationshipDirection.TARGET || !propName.equals("cmis:targetId"))) continue;
                JcrNodeEntry relationshipEntry = null;
                try {
                    relationshipEntry = this.storage.fromNode(prop.getParent());
                }
                catch (ObjectNotFoundException onfe) {
                }
                catch (NotSupportedNodeTypeException ignored) {
                    // empty catch block
                }
                if (relationshipEntry == null || !typeFilter.contains(relationshipEntry.getType().getId())) continue;
                relationships.add(relationshipEntry);
            }
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get relationships. " + re.getMessage(), (Throwable)re);
        }
        return relationships;
    }

    String getContentStreamId() {
        if (this.getBaseType() == BaseType.DOCUMENT) {
            String id = this.getString("cmis:contentStreamId");
            if (id == null) {
                try {
                    Node contentNode = this.node.getNode("jcr:content");
                    long contentLength = contentNode.getProperty("jcr:data").getLength();
                    if (contentLength > 0L) {
                        id = ((ExtendedNode)contentNode).getIdentifier();
                    }
                }
                catch (RepositoryException re) {
                    throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
                }
            }
            return id;
        }
        return null;
    }

    ContentStream getContentStream(String streamId) {
        try {
            if (streamId == null || streamId.equals(this.getContentStreamId())) {
                if (this.getBaseType() != BaseType.DOCUMENT) {
                    return null;
                }
                Node contentNode = this.node.getNode("jcr:content");
                long contentLength = contentNode.getProperty("jcr:data").getLength();
                if (contentLength == 0L) {
                    return null;
                }
                MimeType mimeType = MimeType.fromString((String)contentNode.getProperty("jcr:mimeType").getString());
                if (contentNode.hasProperty("jcr:encoding")) {
                    mimeType.getParameters().put("charset", contentNode.getProperty("jcr:encoding").getString());
                }
                return new BaseContentStream(contentNode.getProperty("jcr:data").getStream(), contentLength, this.getName(), mimeType);
            }
            try {
                Node rendition = this.node.getNode(streamId);
                javax.jcr.Property renditionContent = rendition.getProperty("xcmis:renditionStream");
                MimeType mimeType = MimeType.fromString((String)rendition.getProperty("xcmis:renditionMimeType").getString());
                if (rendition.hasProperty("xcmis:renditionEncoding")) {
                    mimeType.getParameters().put("charset", rendition.getProperty("xcmis:renditionEncoding").getString());
                }
                return new BaseContentStream(renditionContent.getStream(), renditionContent.getLength(), null, mimeType);
            }
            catch (PathNotFoundException pnfe) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)pnfe.getMessage(), (Throwable)pnfe);
                }
                return null;
            }
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unbale get content stream. " + re.getMessage(), (Throwable)re);
        }
    }

    void setContentStream(ContentStream content) throws IOException {
        if (this.getBaseType() != BaseType.DOCUMENT) {
            throw new UnsupportedOperationException();
        }
        try {
            Node contentNode;
            Node node = contentNode = this.node.hasNode("jcr:content") ? this.node.getNode("jcr:content") : this.node.addNode("jcr:content", "nt:resource");
            if (content != null) {
                MimeType mediaType = content.getMediaType();
                contentNode.setProperty("jcr:mimeType", mediaType.getBaseType());
                if (mediaType.getParameter("charset") != null) {
                    contentNode.setProperty("jcr:encoding", mediaType.getParameter("charset"));
                }
                long contentLength = contentNode.setProperty("jcr:data", content.getStream()).getLength();
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                if (this.node.isNodeType("cmis:document")) {
                    if (!this.node.hasProperty("cmis:contentStreamId")) {
                        this.node.setProperty("cmis:contentStreamId", ((ExtendedNode)contentNode).getIdentifier());
                    }
                    this.node.setProperty("cmis:contentStreamLength", contentLength);
                    this.node.setProperty("cmis:contentStreamMimeType", mediaType.getBaseType());
                }
            } else {
                contentNode.setProperty("jcr:mimeType", "");
                contentNode.setProperty("jcr:encoding", (Value)null);
                contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(new byte[0]));
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                if (this.node.isNodeType("cmis:document")) {
                    this.node.setProperty("cmis:contentStreamId", (Value)null);
                    this.node.setProperty("cmis:contentStreamLength", 0L);
                    this.node.setProperty("cmis:contentStreamMimeType", (Value)null);
                }
            }
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set content stream. " + re.getMessage(), (Throwable)re);
        }
    }

    boolean hasContent() {
        if (this.getBaseType() != BaseType.DOCUMENT) {
            return false;
        }
        try {
            Node contentNode = this.node.getNode("jcr:content");
            long contentLength = contentNode.getProperty("jcr:data").getLength();
            return contentLength > 0L;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    Property<?> getProperty(PropertyDefinition<?> definition) {
        try {
            Value[] valueArray;
            javax.jcr.Property jcrProperty = this.node.getProperty(definition.getId());
            if (definition.isMultivalued()) {
                valueArray = jcrProperty.getValues();
            } else {
                Value[] valueArray2 = new Value[1];
                valueArray = valueArray2;
                valueArray2[0] = jcrProperty.getValue();
            }
            return this.createProperty(definition, valueArray);
        }
        catch (PathNotFoundException pnf) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property " + definition.getId() + " is not set."));
            }
            return this.createProperty(definition, new Value[0]);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + definition.getId() + ". " + re.getMessage(), (Throwable)re);
        }
    }

    private Property<?> createProperty(PropertyDefinition<?> def, Value[] values) {
        try {
            if (def.getPropertyType() == PropertyType.BOOLEAN) {
                ArrayList<Boolean> v = new ArrayList<Boolean>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    v.add(values[i].getBoolean());
                }
                return new BooleanProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), v);
            }
            if (def.getPropertyType() == PropertyType.DATETIME) {
                ArrayList<Calendar> v = new ArrayList<Calendar>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    v.add(values[i].getDate());
                }
                return new DateTimeProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), v);
            }
            if (def.getPropertyType() == PropertyType.DECIMAL) {
                ArrayList<BigDecimal> v = new ArrayList<BigDecimal>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    v.add(BigDecimal.valueOf(values[i].getDouble()));
                }
                return new DecimalProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), v);
            }
            if (def.getPropertyType() == PropertyType.HTML) {
                ArrayList<String> v = new ArrayList<String>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    v.add(values[i].getString());
                }
                return new HtmlProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), v);
            }
            if (def.getPropertyType() == PropertyType.ID) {
                ArrayList<String> v = new ArrayList<String>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    v.add(values[i].getString());
                }
                return new IdProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), v);
            }
            if (def.getPropertyType() == PropertyType.INTEGER) {
                ArrayList<BigInteger> v = new ArrayList<BigInteger>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    v.add(BigInteger.valueOf(values[i].getLong()));
                }
                return new IntegerProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), v);
            }
            if (def.getPropertyType() == PropertyType.STRING) {
                ArrayList<String> v = new ArrayList<String>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    v.add(values[i].getString());
                }
                return new StringProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), v);
            }
            if (def.getPropertyType() == PropertyType.URI) {
                ArrayList<URI> v = new ArrayList<URI>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    try {
                        v.add(new URI(values[i].getString()));
                        continue;
                    }
                    catch (URISyntaxException ue) {
                        LOG.error((Object)ue.getMessage(), (Throwable)ue);
                    }
                }
                return new UriProperty(def.getId(), def.getQueryName(), def.getLocalName(), def.getDisplayName(), v);
            }
            throw new CmisRuntimeException("Unknown property type.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    void setProperty(Property<?> property) throws NameConstraintViolationException {
        try {
            if (!this.node.isNew() && property.getId().equals("cmis:name") && property.getValues().size() > 0) {
                String name = (String)property.getValues().get(0);
                this.setName(name);
            } else {
                boolean multivalued = this.type.getPropertyDefinition(property.getId()).isMultivalued();
                if (property.getType() == PropertyType.BOOLEAN) {
                    List booleans = property.getValues();
                    if (booleans.size() == 0) {
                        this.node.setProperty(property.getId(), (Value)null);
                    } else if (!multivalued) {
                        this.node.setProperty(property.getId(), ((Boolean)booleans.get(0)).booleanValue());
                    } else {
                        Value[] jcrValue = new Value[property.getValues().size()];
                        for (int i = 0; i < jcrValue.length; ++i) {
                            jcrValue[i] = new BooleanValue(((Boolean)booleans.get(i)).booleanValue());
                        }
                        this.node.setProperty(property.getId(), jcrValue);
                    }
                } else if (property.getType() == PropertyType.DATETIME) {
                    List datetime = property.getValues();
                    if (datetime.size() == 0) {
                        this.node.setProperty(property.getId(), (Value)null);
                    } else if (!multivalued) {
                        this.node.setProperty(property.getId(), (Calendar)datetime.get(0));
                    } else {
                        Value[] jcrValue = new Value[property.getValues().size()];
                        for (int i = 0; i < jcrValue.length; ++i) {
                            jcrValue[i] = new DateValue((Calendar)datetime.get(i));
                        }
                        this.node.setProperty(property.getId(), jcrValue);
                    }
                } else if (property.getType() == PropertyType.DECIMAL) {
                    List doubles = property.getValues();
                    if (doubles.size() == 0) {
                        this.node.setProperty(property.getId(), (Value)null);
                    } else if (!multivalued) {
                        this.node.setProperty(property.getId(), ((BigDecimal)doubles.get(0)).doubleValue());
                    } else {
                        Value[] jcrValue = new Value[property.getValues().size()];
                        for (int i = 0; i < jcrValue.length; ++i) {
                            jcrValue[i] = new DoubleValue(((BigDecimal)doubles.get(i)).doubleValue());
                        }
                        this.node.setProperty(property.getId(), jcrValue);
                    }
                } else if (property.getType() == PropertyType.INTEGER) {
                    List integers = property.getValues();
                    if (integers.size() == 0) {
                        this.node.setProperty(property.getId(), (Value)null);
                    } else if (!multivalued) {
                        this.node.setProperty(property.getId(), ((BigInteger)integers.get(0)).longValue());
                    } else {
                        Value[] jcrValue = new Value[property.getValues().size()];
                        for (int i = 0; i < jcrValue.length; ++i) {
                            jcrValue[i] = new LongValue(((BigInteger)integers.get(i)).longValue());
                        }
                        this.node.setProperty(property.getId(), jcrValue);
                    }
                } else if (property.getType() == PropertyType.HTML || property.getType() == PropertyType.ID || property.getType() == PropertyType.STRING) {
                    List text = property.getValues();
                    if (text.size() == 0) {
                        this.node.setProperty(property.getId(), (Value)null);
                    } else if (!multivalued) {
                        this.node.setProperty(property.getId(), (String)text.get(0));
                    } else {
                        Value[] jcrValue = new Value[property.getValues().size()];
                        for (int i = 0; i < jcrValue.length; ++i) {
                            jcrValue[i] = new StringValue((String)text.get(i));
                        }
                        this.node.setProperty(property.getId(), jcrValue);
                    }
                } else if (property.getType() == PropertyType.URI) {
                    List uris = property.getValues();
                    if (uris.size() == 0) {
                        this.node.setProperty(property.getId(), (Value)null);
                    } else if (!multivalued) {
                        this.node.setProperty(property.getId(), ((URI)uris.get(0)).toString());
                    } else {
                        Value[] jcrValue = new Value[property.getValues().size()];
                        for (int i = 0; i < jcrValue.length; ++i) {
                            jcrValue[i] = new StringValue(((URI)uris.get(i)).toString());
                        }
                        this.node.setProperty(property.getId(), jcrValue);
                    }
                }
            }
        }
        catch (IOException io) {
            throw new CmisRuntimeException("Unable set property " + property.getId() + ". " + io.getMessage(), (Throwable)io);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + property.getId() + ". " + re.getMessage(), (Throwable)re);
        }
    }

    ItemsIterator<JcrNodeEntry> getChildren() {
        if (this.getBaseType() != BaseType.FOLDER) {
            throw new UnsupportedOperationException();
        }
        try {
            return new ChildrenIterator(this.node.getNodes());
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get children for folder " + this.getId() + ". " + re.getMessage(), (Throwable)re);
        }
    }

    boolean hasChildren() {
        return this.getBaseType() == BaseType.FOLDER && this.getChildren().hasNext();
    }

    void addObject(JcrNodeEntry entry) {
        try {
            Session session = this.node.getSession();
            Node entryNode = entry.getNode();
            Node link = this.node.addNode(entry.getName(), "nt:linkedFile");
            link.setProperty("jcr:content", entryNode);
            session.save();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable add object to current folder. " + re.getMessage(), (Throwable)re);
        }
    }

    void removeObject(JcrNodeEntry entry) {
        try {
            Session session = this.node.getSession();
            Node entryNode = entry.getNode();
            if (((ExtendedNode)entryNode.getParent()).getIdentifier().equals(((ExtendedNode)this.node).getIdentifier())) {
                Node link = null;
                PropertyIterator references = entryNode.getReferences();
                while (references.hasNext()) {
                    Node next = references.nextProperty().getParent();
                    if (!next.isNodeType("nt:linkedFile")) continue;
                    link = next;
                    break;
                }
                String destPath = null;
                if (link == null) {
                    throw new CmisRuntimeException("Unable remove object from last folder in which it is filed.");
                }
                destPath = link.getPath();
                link.remove();
                session.move(entryNode.getPath(), destPath);
            } else {
                PropertyIterator references = entryNode.getReferences();
                while (references.hasNext()) {
                    Node next = references.nextProperty().getParent();
                    if (!next.isNodeType("nt:linkedFile") || !((ExtendedNode)next.getParent()).getIdentifier().equals(((ExtendedNode)this.node).getIdentifier())) continue;
                    next.remove();
                    break;
                }
            }
            session.save();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable remove object from current folder. " + re.getMessage(), (Throwable)re);
        }
    }

    void moveTo(JcrNodeEntry target) throws NameConstraintViolationException, StorageException {
        try {
            Session session = this.node.getSession();
            String objectPath = this.path();
            String destinationPath = target.getNode().getPath();
            destinationPath = destinationPath + (destinationPath.equals("/") ? this.getName() : "/" + this.getName());
            session.getWorkspace().move(objectPath, destinationPath);
        }
        catch (ItemExistsException ie) {
            throw new NameConstraintViolationException("Object with the same name already exists in target folder.");
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable to move object. " + re.getMessage(), (Throwable)re);
        }
    }

    Collection<JcrNodeEntry> getParents() {
        try {
            HashSet<JcrNodeEntry> parents = new HashSet<JcrNodeEntry>();
            if (this.getBaseType() == BaseType.DOCUMENT) {
                PropertyIterator iterator = this.node.getReferences();
                while (iterator.hasNext()) {
                    Node refer = iterator.nextProperty().getParent();
                    if (!refer.isNodeType("nt:linkedFile")) continue;
                    Node parent = refer.getParent();
                    try {
                        parents.add(this.storage.fromNode(parent));
                    }
                    catch (ObjectNotFoundException onfe) {}
                }
            }
            if (this.getBaseType() == BaseType.DOCUMENT || !this.isRoot()) {
                try {
                    JcrNodeEntry parent = this.storage.fromNode(this.node.getParent());
                    parents.add(parent);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
            }
            return parents;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get object parent. " + re.getMessage(), (Throwable)re);
        }
    }

    Boolean getBoolean(String id) {
        try {
            return this.node.getProperty(id).getBoolean();
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    Boolean[] getBooleans(String id) {
        try {
            Value[] values = this.node.getProperty(id).getValues();
            Boolean[] res = new Boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                res[i] = values[i].getBoolean();
            }
            return res;
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    Calendar getDate(String id) {
        try {
            return this.node.getProperty(id).getDate();
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    Calendar[] getDates(String id) {
        try {
            Value[] values = this.node.getProperty(id).getValues();
            Calendar[] res = new Calendar[values.length];
            for (int i = 0; i < values.length; ++i) {
                res[i] = values[i].getDate();
            }
            return res;
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    Double getDouble(String id) {
        try {
            return this.node.getProperty(id).getDouble();
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    Double[] getDoubles(String id) {
        try {
            Value[] values = this.node.getProperty(id).getValues();
            Double[] res = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                res[i] = values[i].getDouble();
            }
            return res;
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    Long getLong(String id) {
        try {
            return this.node.getProperty(id).getLong();
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    Long[] getLongs(String id) {
        try {
            Value[] values = this.node.getProperty(id).getValues();
            Long[] res = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                res[i] = values[i].getLong();
            }
            return res;
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    String getString(String id) {
        try {
            return this.node.getProperty(id).getString();
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    String[] getStrings(String id) {
        try {
            Value[] values = this.node.getProperty(id).getValues();
            String[] res = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                res[i] = values[i].getString();
            }
            return res;
        }
        catch (PathNotFoundException pe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValue(String id, Value value) {
        try {
            this.node.setProperty(id, value);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValues(String id, Value[] values) {
        try {
            this.node.setProperty(id, values);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValue(String id, boolean value) {
        try {
            this.node.setProperty(id, value);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValues(String id, boolean[] values) {
        try {
            Value[] jcrValue = new Value[values.length];
            for (int i = 0; i < jcrValue.length; ++i) {
                jcrValue[i] = new BooleanValue(values[i]);
            }
            this.node.setProperty(id, jcrValue);
        }
        catch (IOException ioe) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValue(String id, Calendar value) {
        try {
            this.node.setProperty(id, value);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValues(String id, Calendar[] values) {
        try {
            Value[] jcrValue = new Value[values.length];
            for (int i = 0; i < jcrValue.length; ++i) {
                jcrValue[i] = new DateValue(values[i]);
            }
            this.node.setProperty(id, jcrValue);
        }
        catch (IOException io) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + io.getMessage(), (Throwable)io);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValue(String id, double value) {
        try {
            this.node.setProperty(id, value);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValues(String id, double[] values) {
        try {
            Value[] jcrValue = new Value[values.length];
            for (int i = 0; i < jcrValue.length; ++i) {
                jcrValue[i] = new DoubleValue(values[i]);
            }
            this.node.setProperty(id, jcrValue);
        }
        catch (IOException io) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + io.getMessage(), (Throwable)io);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValue(String id, long value) {
        try {
            this.node.setProperty(id, value);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValues(String id, long[] values) {
        try {
            Value[] jcrValue = new Value[values.length];
            for (int i = 0; i < jcrValue.length; ++i) {
                jcrValue[i] = new LongValue(values[i]);
            }
            this.node.setProperty(id, jcrValue);
        }
        catch (IOException io) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + io.getMessage(), (Throwable)io);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValue(String id, String value) {
        try {
            this.node.setProperty(id, value);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void setValues(String id, String[] strings) {
        try {
            Value[] jcrValue = new Value[strings.length];
            for (int i = 0; i < jcrValue.length; ++i) {
                jcrValue[i] = new StringValue(strings[i]);
            }
            this.node.setProperty(id, jcrValue);
        }
        catch (IOException io) {
            throw new CmisRuntimeException("Failed set or update property " + id + ". " + io.getMessage(), (Throwable)io);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable set property " + id + ". " + re.getMessage(), (Throwable)re);
        }
    }

    void save() throws StorageException {
        this.save(true);
    }

    void save(boolean updateLastModifiedAttributes) throws StorageException {
        try {
            Session session = this.node.getSession();
            if (updateLastModifiedAttributes) {
                this.node.setProperty("cmis:lastModificationDate", Calendar.getInstance());
                this.node.setProperty("cmis:lastModifiedBy", this.node.getSession().getUserID());
                this.node.setProperty("cmis:changeToken", IdGenerator.generate());
            }
            session.save();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable save object. " + re.getMessage(), (Throwable)re);
        }
    }

    void delete() throws StorageException {
        Collection<JcrNodeEntry> relationships = null;
        if (this.getType().getBaseId() != BaseType.RELATIONSHIP) {
            try {
                relationships = this.getRelationships(RelationshipDirection.EITHER, this.storage.getTypeDefinition("cmis:relationship", true), true);
            }
            catch (TypeNotFoundException ignore) {
                // empty catch block
            }
            if (relationships != null && relationships.size() > 0) {
                throw new StorageException("Object can't be deleted cause to storage referential integrity. Probably this object is source or target at least one Relationship. Those Relationship should be deleted before.");
            }
        }
        try {
            String path = this.path();
            Session session = this.node.getSession();
            switch (this.getBaseType()) {
                case DOCUMENT: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("remove document " + path));
                    }
                    PropertyIterator references = this.node.getReferences();
                    while (references.hasNext()) {
                        Node next = references.nextProperty().getParent();
                        if (!next.isNodeType("nt:linkedFile")) continue;
                        next.remove();
                    }
                    String pwcId = this.getString("cmis:versionSeriesCheckedOutId");
                    if (pwcId != null) {
                        Node pwcNode = ((ExtendedSession)session).getNodeByIdentifier(pwcId);
                        pwcNode.getParent().remove();
                    }
                    this.node.remove();
                    break;
                }
                case FOLDER: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("remove folder " + path));
                    }
                    this.node.remove();
                    break;
                }
                case POLICY: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("remove policy " + path));
                    }
                    PropertyIterator iter = this.node.getReferences();
                    while (iter.hasNext()) {
                        Node controllable = iter.nextProperty().getParent();
                        if (!controllable.isNodeType("nt:file") && !controllable.isNodeType("nt:folder") && !controllable.isNodeType("cmis:policy")) continue;
                        throw new StorageException("Unable to delete applied policy.");
                    }
                    this.node.remove();
                    break;
                }
                case RELATIONSHIP: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("remove relationship " + path));
                    }
                    this.node.remove();
                }
            }
            session.save();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("removed " + path));
            }
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable delete object. " + re.getMessage(), (Throwable)re);
        }
    }

    Node getNode() {
        return this.node;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return ((JcrNodeEntry)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        int hash = 8;
        hash = hash * 31 + this.getId().hashCode();
        return hash;
    }

    static {
        SKIP_CHILD_ITEMS.add("jcr:system");
        SKIP_CHILD_ITEMS.add("xcmis:system");
        LOG = ExoLogger.getLogger(JcrNodeEntry.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChildrenIterator
    extends LazyIterator<JcrNodeEntry> {
        private final NodeIterator iter;

        public ChildrenIterator(NodeIterator iter) {
            this.iter = iter;
            this.fetchNext();
        }

        protected void fetchNext() {
            this.next = null;
            while (this.next == null && this.iter.hasNext()) {
                Node node = this.iter.nextNode();
                try {
                    if (SKIP_CHILD_ITEMS.contains(node.getName()) || !((NodeImpl)node).isValid()) continue;
                    if (node.isNodeType("nt:linkedFile")) {
                        node = node.getProperty("jcr:content").getNode();
                        try {
                            this.next = JcrNodeEntry.this.storage.fromNode(node);
                        }
                        catch (ObjectNotFoundException e) {}
                        continue;
                    }
                    if (node.isNodeType("exo:symlink")) {
                        try {
                            this.next = JcrNodeEntry.this.storage.fromNode(node);
                        }
                        catch (ObjectNotFoundException e) {}
                        continue;
                    }
                    try {
                        this.next = JcrNodeEntry.this.storage.fromNode(node);
                    }
                    catch (ObjectNotFoundException e) {
                    }
                }
                catch (NotSupportedNodeTypeException iae) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.warn((Object)("Unable get next object . " + iae.getMessage()));
                }
                catch (RepositoryException re) {
                    LOG.warn((Object)("Unexpected error. Failed get next CMIS object. " + re.getMessage()));
                }
            }
        }

        public int size() {
            return -1;
        }
    }
}

