/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.RenditionContentStream;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.utils.MimeType;

public class RenditionsUpdateListener
implements EventListener {
    private static final Log LOG = ExoLogger.getLogger((String)RenditionsUpdateListener.class.getName());
    private final String workspace;
    private final Repository repository;

    public RenditionsUpdateListener(Repository repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator eventIterator) {
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(this.workspace, (ManageableRepository)this.repository);
            while (eventIterator.hasNext()) {
                Property jcrData;
                Node jcrContent;
                Node fileNode;
                Event event = eventIterator.nextEvent();
                String path = event.getPath();
                if (path.startsWith("/xcmis:system") || !path.endsWith("/jcr:data") || !(fileNode = (jcrContent = (jcrData = (Property)session.getItem(path)).getParent()).getParent()).isNodeType("cmis:document")) continue;
                NodeIterator iter = fileNode.getNodes();
                while (iter.hasNext()) {
                    Node next = iter.nextNode();
                    if (!next.isNodeType("xcmis:rendition")) continue;
                    next.remove();
                }
                long length = jcrData.getLength();
                if (length > 0L) {
                    RenditionContentStream renditionContentStream;
                    MimeType mimeType = MimeType.fromString((String)jcrContent.getProperty("jcr:mimeType").getString());
                    if (jcrContent.hasProperty("jcr:encoding")) {
                        mimeType.getParameters().put("charset", jcrContent.getProperty("jcr:encoding").getString());
                    }
                    if ((renditionContentStream = RenditionManager.getInstance().getStream((ContentStream)new BaseContentStream(jcrData.getStream(), length, null, mimeType), mimeType)) != null) {
                        String id = IdGenerator.generate();
                        Node rendition = fileNode.addNode(id, "xcmis:rendition");
                        rendition.setProperty("xcmis:renditionStream", renditionContentStream.getStream());
                        rendition.setProperty("xcmis:renditionMimeType", renditionContentStream.getMediaType().getBaseType());
                        rendition.setProperty("xcmis:renditionEncoding", renditionContentStream.getMediaType().getParameter("charset"));
                        rendition.setProperty("xcmis:renditionKind", renditionContentStream.getKind());
                        rendition.setProperty("xcmis:renditionHeight", (long)renditionContentStream.getHeight());
                        rendition.setProperty("xcmis:renditionWidth", (long)renditionContentStream.getWidth());
                    }
                }
                session.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Creating rendition on event failed. " + e.getMessage()));
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }
}

