/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import javax.jcr.RepositoryException;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.TxIsolatedOperation;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.JBossCacheWorkspaceStorageCache;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableWorkspaceDataManager
extends WorkspacePersistentDataManager {
    protected final WorkspaceStorageCache cache;
    protected final ConcurrentMap<Integer, DataRequest> requestCache;
    private TransactionManager transactionManager;

    public CacheableWorkspaceDataManager(WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder, TransactionService transactionService) {
        super(dataContainer, systemDataContainerHolder);
        this.cache = cache;
        this.requestCache = new ConcurrentHashMap<Integer, DataRequest>();
        this.addItemPersistenceListener(cache);
        this.transactionManager = transactionService.getTransactionManager();
    }

    public CacheableWorkspaceDataManager(WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder) {
        super(dataContainer, systemDataContainerHolder);
        this.cache = cache;
        this.requestCache = new ConcurrentHashMap<Integer, DataRequest>();
        this.addItemPersistenceListener(cache);
        this.transactionManager = cache instanceof JBossCacheWorkspaceStorageCache ? ((JBossCacheWorkspaceStorageCache)cache).getTransactionManager() : null;
    }

    public WorkspaceStorageCache getCache() {
        return this.cache;
    }

    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        int childCount;
        if (this.cache.isEnabled() && (childCount = this.cache.getChildNodesCount(parent)) >= 0) {
            return childCount;
        }
        return super.getChildNodesCount(parent);
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        return this.getChildNodesData(nodeData, false);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> childs = this.getChildPropertiesData(nodeData, false);
        for (PropertyData prop : childs) {
            this.fixPropertyValues(prop);
        }
        return childs;
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        return this.getItemData(parentData, name, ItemType.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        ItemData data = this.getCachedItemData(parentData, name, itemType);
        if (data == null) {
            DataRequest request = new DataRequest(parentData.getIdentifier(), name);
            try {
                request.start();
                data = this.getCachedItemData(parentData, name, itemType);
                if (data == null) {
                    data = this.getPersistedItemData(parentData, name, itemType);
                } else if (!data.isNode()) {
                    this.fixPropertyValues((PropertyData)data);
                }
                Object var7_6 = null;
                request.done();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                request.done();
                throw throwable;
            }
        } else if (!data.isNode()) {
            this.fixPropertyValues((PropertyData)data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData data = this.getCachedItemData(identifier);
        if (data == null) {
            DataRequest request = new DataRequest(identifier);
            try {
                request.start();
                data = this.getCachedItemData(identifier);
                if (data == null) {
                    data = this.getPersistedItemData(identifier);
                } else if (!data.isNode()) {
                    this.fixPropertyValues((PropertyData)data);
                }
                Object var5_4 = null;
                request.done();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                request.done();
                throw throwable;
            }
        } else if (!data.isNode()) {
            this.fixPropertyValues((PropertyData)data);
        }
        return data;
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        List<PropertyData> props = this.getReferencedPropertiesData(identifier);
        if (skipVersionStorage) {
            ArrayList<PropertyData> result = new ArrayList<PropertyData>();
            int length = props.size();
            for (int i = 0; i < length; ++i) {
                PropertyData prop = props.get(i);
                if (prop.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) continue;
                result.add(prop);
            }
            return result;
        }
        return props;
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        return this.listChildPropertiesData(nodeData, false);
    }

    @Override
    public void save(ItemStateChangesLog changesLog) throws RepositoryException {
        if (this.isTxAware()) {
            new SaveInTransaction(changesLog).perform();
        } else {
            super.save(changesLog);
            this.notifySaveItems(changesLog, false);
        }
    }

    protected ItemData getCachedItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        return this.cache.get(parentData.getIdentifier(), name, itemType);
    }

    protected ItemData getCachedItemData(String identifier) throws RepositoryException {
        return this.cache.get(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NodeData> getChildNodesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        NodeData parentData;
        DataRequest request;
        List<NodeData> childNodes;
        block5: {
            childNodes = null;
            if (!forcePersistentRead && this.cache.isEnabled() && (childNodes = this.cache.getChildNodes(nodeData)) != null) {
                return childNodes;
            }
            request = new DataRequest(nodeData.getIdentifier(), 1);
            try {
                request.start();
                if (forcePersistentRead || !this.cache.isEnabled() || (childNodes = this.cache.getChildNodes(nodeData)) == null) break block5;
                List<NodeData> list = childNodes;
                Object var7_7 = null;
                request.done();
                return list;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                request.done();
                throw throwable;
            }
        }
        childNodes = super.getChildNodesData(nodeData);
        if (this.cache.isEnabled() && (parentData = (NodeData)this.getItemData(nodeData.getIdentifier())) != null) {
            this.cache.addChildNodes(parentData, childNodes);
        }
        List<NodeData> list = childNodes;
        Object var7_8 = null;
        request.done();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> getChildPropertiesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        NodeData parentData;
        DataRequest request;
        List<PropertyData> childProperties;
        block5: {
            childProperties = null;
            if (!forcePersistentRead && this.cache.isEnabled() && (childProperties = this.cache.getChildProperties(nodeData)) != null) {
                return childProperties;
            }
            request = new DataRequest(nodeData.getIdentifier(), 2);
            try {
                request.start();
                if (forcePersistentRead || !this.cache.isEnabled() || (childProperties = this.cache.getChildProperties(nodeData)) == null) break block5;
                List<PropertyData> list = childProperties;
                Object var7_7 = null;
                request.done();
                return list;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                request.done();
                throw throwable;
            }
        }
        childProperties = super.getChildPropertiesData(nodeData);
        if (childProperties.size() > 0 && this.cache.isEnabled() && (parentData = (NodeData)this.getItemData(nodeData.getIdentifier())) != null) {
            this.cache.addChildProperties(parentData, childProperties);
        }
        List<PropertyData> list = childProperties;
        Object var7_8 = null;
        request.done();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> getReferencedPropertiesData(String identifier) throws RepositoryException {
        DataRequest request;
        List<PropertyData> refProps;
        block5: {
            refProps = null;
            if (this.cache.isEnabled() && (refProps = this.cache.getReferencedProperties(identifier)) != null) {
                return refProps;
            }
            request = new DataRequest(identifier, 6);
            try {
                request.start();
                if (!this.cache.isEnabled() || (refProps = this.cache.getReferencedProperties(identifier)) == null) break block5;
                List<PropertyData> list = refProps;
                Object var6_6 = null;
                request.done();
                return list;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                request.done();
                throw throwable;
            }
        }
        refProps = super.getReferencesData(identifier, false);
        if (this.cache.isEnabled()) {
            this.cache.addReferencedProperties(identifier, refProps);
        }
        List<PropertyData> list = refProps;
        Object var6_7 = null;
        request.done();
        return list;
    }

    protected ItemData getPersistedItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        ItemData data = super.getItemData(parentData, name, itemType);
        if (data != null && this.cache.isEnabled()) {
            this.cache.put(data);
        }
        return data;
    }

    protected ItemData getPersistedItemData(String identifier) throws RepositoryException {
        ItemData data = super.getItemData(identifier);
        if (data != null && this.cache.isEnabled()) {
            this.cache.put(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> listChildPropertiesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        NodeData parentData;
        DataRequest request;
        List<PropertyData> propertiesList;
        block5: {
            if (!forcePersistentRead && this.cache.isEnabled() && (propertiesList = this.cache.listChildProperties(nodeData)) != null) {
                return propertiesList;
            }
            request = new DataRequest(nodeData.getIdentifier(), 5);
            try {
                request.start();
                if (forcePersistentRead || !this.cache.isEnabled() || (propertiesList = this.cache.listChildProperties(nodeData)) == null) break block5;
                List<PropertyData> list = propertiesList;
                Object var7_7 = null;
                request.done();
                return list;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                request.done();
                throw throwable;
            }
        }
        propertiesList = super.listChildPropertiesData(nodeData);
        if (propertiesList.size() > 0 && this.cache.isEnabled() && (parentData = (NodeData)this.getItemData(nodeData.getIdentifier())) != null) {
            this.cache.addChildPropertiesList(parentData, propertiesList);
        }
        List<PropertyData> list = propertiesList;
        Object var7_8 = null;
        request.done();
        return list;
    }

    protected boolean isTxAware() {
        return this.transactionManager != null;
    }

    protected void fixPropertyValues(PropertyData prop) throws RepositoryException {
        List<ValueData> vals = prop.getValues();
        for (int i = 0; i < vals.size(); ++i) {
            FilePersistedValueData fpvd;
            ValueData vd = vals.get(i);
            if (vd.isByteArray() || (fpvd = (FilePersistedValueData)vd).getFile() != null) continue;
            ValueData svd = this.getPropertyValue(prop.getIdentifier(), vd.getOrderNumber(), prop.getPersistedVersion());
            if (svd == null) {
                throw new RepositoryException("Value cannot be found in storage for cached Property " + prop.getQPath().getAsString() + ", orderNumb:" + vd.getOrderNumber() + ", pversion:" + prop.getPersistedVersion());
            }
            vals.set(i, svd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData getPropertyValue(String propertyId, int orderNumb, int persistedVersion) throws IllegalStateException, RepositoryException {
        ValueData valueData;
        JDBCStorageConnection conn = (JDBCStorageConnection)this.dataContainer.openConnection();
        try {
            valueData = conn.getValue(propertyId, orderNumb, persistedVersion);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return valueData;
    }

    protected class SaveInTransaction
    extends TxIsolatedOperation {
        final ItemStateChangesLog changes;

        SaveInTransaction(ItemStateChangesLog changes) {
            super(CacheableWorkspaceDataManager.this.transactionManager);
            this.changes = changes;
        }

        protected void action() throws RepositoryException {
            CacheableWorkspaceDataManager.super.save(this.changes);
        }

        protected void txAction() throws RepositoryException {
            super.txAction();
            try {
                CacheableWorkspaceDataManager.this.notifySaveItems(this.changes, false);
            }
            catch (Throwable th) {
                throw new RepositoryException(th);
            }
        }
    }

    protected class DataRequest {
        public static final int GET_NODES = 1;
        public static final int GET_PROPERTIES = 2;
        private static final int GET_ITEM_ID = 3;
        private static final int GET_ITEM_NAME = 4;
        private static final int GET_LIST_PROPERTIES = 5;
        public static final int GET_REFERENCES = 6;
        protected final int type;
        protected final String parentId;
        protected final String id;
        protected final QPathEntry name;
        protected final int hcode;
        protected CountDownLatch ready = new CountDownLatch(1);

        DataRequest(String parentId, int type) {
            this.parentId = parentId;
            this.name = null;
            this.id = null;
            this.type = type;
            this.hcode = 31 * (31 + this.type) + this.parentId.hashCode();
        }

        DataRequest(String parentId, QPathEntry name) {
            this.parentId = parentId;
            this.name = name;
            this.id = null;
            this.type = 4;
            int hc = 31 * (31 + this.type) + this.parentId.hashCode();
            this.hcode = 31 * hc + this.name.hashCode();
        }

        DataRequest(String id) {
            this.parentId = null;
            this.name = null;
            this.id = id;
            this.type = 3;
            this.hcode = 31 * (31 + this.type) + (this.id == null ? 0 : this.id.hashCode());
        }

        void start() {
            DataRequest request = CacheableWorkspaceDataManager.this.requestCache.putIfAbsent(this.hashCode(), this);
            if (request != null) {
                request.await();
            }
        }

        void done() {
            this.ready.countDown();
            CacheableWorkspaceDataManager.this.requestCache.remove(this.hashCode(), this);
        }

        void await() {
            try {
                this.ready.await();
            }
            catch (InterruptedException e) {
                WorkspacePersistentDataManager.LOG.warn((Object)("Can't wait for same request process. " + e), (Throwable)e);
            }
        }

        public boolean equals(Object obj) {
            return this.hcode == obj.hashCode();
        }

        public int hashCode() {
            return this.hcode;
        }
    }
}

