/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.templates.TemplateResource;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateContext {
    private final Map<String, ? extends Object> top;
    private final Gadget gadget;
    private Object cur = null;
    private Map<String, ? extends Object> context = ImmutableMap.of();
    private Map<String, Object> myMap = null;
    private Node templateRoot;
    private Map<Object, TemplateResource> resources = Maps.newLinkedHashMap();

    public TemplateContext(Gadget gadget, Map<String, ? extends Object> top) {
        this.gadget = gadget;
        this.top = top;
        this.cur = top;
    }

    public Map<String, ? extends Object> getTop() {
        return this.top;
    }

    public Object getCur() {
        return this.cur;
    }

    public Object setCur(Object data) {
        Object oldCur = this.cur;
        this.cur = data;
        return oldCur;
    }

    public Map<String, ? extends Object> getContext() {
        return this.context;
    }

    public Map<String, ? extends Object> setContext(Map<String, ? extends Object> newContext) {
        Map<String, ? extends Object> oldContext = this.context;
        this.context = newContext;
        return oldContext;
    }

    public Map<String, Object> setMy(Map<String, Object> myMap) {
        Map<String, Object> oldMy = this.myMap;
        this.myMap = myMap;
        return oldMy;
    }

    public Map<String, Object> getMy() {
        return this.myMap;
    }

    public Gadget getGadget() {
        return this.gadget;
    }

    public Node setTemplateRoot(Node root) {
        Node oldRoot = this.templateRoot;
        this.templateRoot = root;
        return oldRoot;
    }

    public Node getTemplateRoot() {
        return this.templateRoot;
    }

    public void addResource(Object key, TemplateResource resource) {
        if (!this.resources.containsKey(key)) {
            this.resources.put(key, resource);
        }
    }

    public Collection<TemplateResource> getResources() {
        return this.resources.values();
    }
}

