/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration;

import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.DuplicateRegistrationException;
import org.gatein.registration.NoSuchRegistrationException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.spi.ConsumerGroupSPI;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegistrationPersistenceManager
implements RegistrationPersistenceManager {
    @Override
    public Consumer createConsumer(String consumerId, String consumerName) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        ConsumerSPI consumer = this.internalCreateConsumer(consumerId, consumerName);
        this.internalAddConsumer(consumer);
        return consumer;
    }

    @Override
    public void saveChangesTo(Consumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        if (consumer.getPersistentKey() == null) {
            throw new IllegalArgumentException("Consumer " + consumer + " hasn't yet been persisted and thus cannot be updated.");
        }
        this.internalSaveChangesTo(consumer);
    }

    @Override
    public void saveChangesTo(Registration registration) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registration, (String)"Registration");
        if (registration.getPersistentKey() == null) {
            throw new IllegalArgumentException("Registration " + registration + " hasn't yet been persisted and thus cannot be updated");
        }
        this.internalSaveChangesTo(registration);
    }

    @Override
    public ConsumerGroup createConsumerGroup(String name) throws RegistrationException {
        ConsumerGroup group = this.getConsumerGroup(name);
        if (group != null) {
            throw new DuplicateRegistrationException("A ConsumerGroup named '" + name + "' has already been registered.");
        }
        group = this.internalCreateConsumerGroup(name);
        this.internalAddConsumerGroup((ConsumerGroupSPI)group);
        return group;
    }

    @Override
    public void removeConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"ConsumerGroup name", null);
        if (this.internalRemoveConsumerGroup(name) == null) {
            throw new NoSuchRegistrationException("There is no ConsumerGroup named '" + name + "'.");
        }
    }

    @Override
    public void removeConsumer(String consumerId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        if (this.internalRemoveConsumer(consumerId) == null) {
            throw new RegistrationException("There is no Consumer with identity '" + consumerId + "'.");
        }
    }

    @Override
    public void removeRegistration(String registrationId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration identity", null);
        RegistrationSPI registration = this.internalRemoveRegistration(registrationId);
        if (registration == null) {
            throw new NoSuchRegistrationException("There is no Registration with id '" + registrationId + "'");
        }
        ConsumerSPI consumer = registration.getConsumer();
        consumer.removeRegistration(registration);
    }

    @Override
    public Registration addRegistrationFor(String consumerId, Map<QName, Object> registrationProperties) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNull(registrationProperties, (String)"Registration properties");
        ConsumerSPI consumer = this.getConsumerSPIById(consumerId);
        if (consumer == null) {
            throw new NoSuchRegistrationException("There is no Consumer with identity '" + consumerId + "' to add a Registration to...");
        }
        RegistrationSPI registration = this.internalCreateRegistration(consumer, registrationProperties);
        consumer.addRegistration(registration);
        this.internalAddRegistration(registration);
        return registration;
    }

    @Override
    public Consumer addConsumerToGroupNamed(String consumerId, String groupName) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer identity", null);
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)groupName, (String)"ConsumerGroup name", null);
        ConsumerGroup group = this.getConsumerGroup(groupName);
        if (group == null) {
            throw new NoSuchRegistrationException("There is no ConsumerGroup named '" + groupName + "' to add a Consumer to...");
        }
        ConsumerSPI consumer = this.getConsumerSPIById(consumerId);
        if (consumer == null) {
            throw new NoSuchRegistrationException("There is no Consumer with identity '" + consumerId + "' to add to ConsumerGroup named '" + groupName + "'. Did you create it?");
        }
        group.addConsumer(consumer);
        return consumer;
    }

    protected abstract void internalAddRegistration(RegistrationSPI var1);

    protected abstract RegistrationSPI internalRemoveRegistration(String var1);

    protected abstract RegistrationSPI internalCreateRegistration(ConsumerSPI var1, Map<QName, Object> var2);

    protected abstract void internalAddConsumer(ConsumerSPI var1);

    protected abstract ConsumerSPI internalRemoveConsumer(String var1);

    protected abstract ConsumerSPI internalCreateConsumer(String var1, String var2);

    protected abstract ConsumerSPI internalSaveChangesTo(Consumer var1);

    protected abstract RegistrationSPI internalSaveChangesTo(Registration var1);

    protected abstract void internalAddConsumerGroup(ConsumerGroupSPI var1);

    protected abstract ConsumerGroupSPI internalRemoveConsumerGroup(String var1);

    protected abstract ConsumerGroupSPI internalCreateConsumerGroup(String var1);

    protected abstract ConsumerSPI getConsumerSPIById(String var1) throws RegistrationException;
}

