/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.util.Map;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.UpdateNavigationalStateResponseProcessor;
import org.gatein.wsrp.producer.handlers.processors.WSRPPortletInvocationContext;
import org.gatein.wsrp.producer.handlers.processors.WSRPRequestContext;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MimeRequest;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionRequestProcessor
extends UpdateNavigationalStateResponseProcessor<BlockingInteractionResponse> {
    private final PerformBlockingInteraction performBlockingInteraction;

    ActionRequestProcessor(ProducerHelper producer, PerformBlockingInteraction performBlockingInteraction) throws UnsupportedMimeType, UnsupportedWindowState, InvalidHandle, UnsupportedMode, MissingParameters, InvalidRegistration, OperationFailed, ModifyRegistrationRequired {
        super(producer);
        this.performBlockingInteraction = performBlockingInteraction;
        this.prepareInvocation();
    }

    @Override
    RegistrationContext getRegistrationContext() {
        return this.performBlockingInteraction.getRegistrationContext();
    }

    @Override
    RuntimeContext getRuntimeContext() {
        return this.performBlockingInteraction.getRuntimeContext();
    }

    @Override
    MimeRequest getParams() {
        return this.performBlockingInteraction.getMarkupParams();
    }

    @Override
    public PortletContext getPortletContext() {
        return this.performBlockingInteraction.getPortletContext();
    }

    @Override
    UserContext getUserContext() {
        return this.performBlockingInteraction.getUserContext();
    }

    @Override
    String getContextName() {
        return "PerformBlockingInteraction";
    }

    @Override
    AccessMode getAccessMode() throws MissingParameters {
        StateChange stateChange = this.performBlockingInteraction.getInteractionParams().getPortletStateChange();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)stateChange, (String)"portletStateChange", (String)"InteractionParams");
        return WSRPUtils.getAccessModeFromStateChange((StateChange)stateChange);
    }

    @Override
    PortletInvocation initInvocation(WSRPPortletInvocationContext context) {
        ActionInvocation invocation = new ActionInvocation((PortletInvocationContext)context);
        InteractionParams interactionParams = this.performBlockingInteraction.getInteractionParams();
        WSRPRequestContext requestContext = WSRPRequestContext.createRequestContext(this.markupRequest, interactionParams);
        invocation.setRequestContext((RequestContext)requestContext);
        StateString interactionState = this.createNavigationalState(interactionParams.getInteractionState());
        invocation.setInteractionState(interactionState);
        invocation.setForm((Map)requestContext.getForm());
        return invocation;
    }

    @Override
    public BlockingInteractionResponse processResponse(PortletInvocationResponse response) {
        if (response instanceof UpdateNavigationalStateResponse) {
            UpdateNavigationalStateResponse stateResponse = (UpdateNavigationalStateResponse)response;
            UpdateResponse updateResponse = this.createUpdateResponse(stateResponse);
            return WSRPTypeFactory.createBlockingInteractionResponse((UpdateResponse)updateResponse);
        }
        HTTPRedirectionResponse redirectionResult = (HTTPRedirectionResponse)response;
        return WSRPTypeFactory.createBlockingInteractionResponse((String)redirectionResult.getLocation());
    }
}

