/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.auth.MD5Token;
import org.jgroups.auth.SimpleToken;
import org.jgroups.protocols.AuthHeader;

public class AUTHTest
extends TestCase {
    Properties properties = new Properties();

    public void testSimpleToken() {
        try {
            this.properties.clear();
            this.properties.put("auth_value", "chris");
            SimpleToken token1 = new SimpleToken();
            token1.setValue(this.properties);
            this.properties.put("auth_value", "chris");
            SimpleToken token2 = new SimpleToken();
            token2.setValue(this.properties);
            AUTHTest.assertTrue((boolean)token1.authenticate(token2, null));
        }
        catch (Exception failException) {
            AUTHTest.fail((String)failException.getMessage());
        }
    }

    public void testSimpleTokenMismatch() {
        try {
            this.properties.clear();
            this.properties.put("auth_value", "chris");
            SimpleToken token1 = new SimpleToken();
            token1.setValue(this.properties);
            this.properties.put("auth_value", "chrismills");
            SimpleToken token2 = new SimpleToken();
            token2.setValue(this.properties);
            AUTHTest.assertTrue((!token1.authenticate(token2, null) ? 1 : 0) != 0);
        }
        catch (Exception failException) {
            AUTHTest.fail((String)failException.getMessage());
        }
    }

    public void testMD5Token() {
        try {
            this.properties.clear();
            this.properties.put("auth_value", "chris");
            this.properties.put("token_hash", "MD5");
            MD5Token token1 = new MD5Token();
            token1.setValue(this.properties);
            this.properties.put("auth_value", "chris");
            this.properties.put("token_hash", "MD5");
            MD5Token token2 = new MD5Token();
            token2.setValue(this.properties);
            AUTHTest.assertTrue((boolean)token1.authenticate(token2, null));
        }
        catch (Exception failException) {
            AUTHTest.fail((String)failException.getMessage());
        }
    }

    public void testMD5TokenMismatch() {
        try {
            this.properties.clear();
            this.properties.put("auth_value", "chris");
            this.properties.put("token_hash", "MD5");
            MD5Token token1 = new MD5Token();
            token1.setValue(this.properties);
            this.properties.put("auth_value", "chrismills");
            this.properties.put("token_hash", "MD5");
            MD5Token token2 = new MD5Token();
            token2.setValue(this.properties);
            AUTHTest.assertTrue((!token1.authenticate(token2, null) ? 1 : 0) != 0);
        }
        catch (Exception failException) {
            AUTHTest.fail((String)failException.getMessage());
        }
    }

    public void testSHAToken() {
        try {
            this.properties.clear();
            this.properties.put("auth_value", "chris");
            this.properties.put("token_hash", "SHA");
            MD5Token token1 = new MD5Token();
            token1.setValue(this.properties);
            this.properties.put("auth_value", "chris");
            this.properties.put("token_hash", "SHA");
            MD5Token token2 = new MD5Token();
            token2.setValue(this.properties);
            AUTHTest.assertTrue((boolean)token1.authenticate(token2, null));
        }
        catch (Exception failException) {
            AUTHTest.fail((String)failException.getMessage());
        }
    }

    public void testSHATokenMismatch() {
        try {
            this.properties.clear();
            this.properties.put("auth_value", "chris");
            this.properties.put("token_hash", "SHA");
            MD5Token token1 = new MD5Token();
            token1.setValue(this.properties);
            this.properties.put("auth_value", "chrismills");
            this.properties.put("token_hash", "SHA");
            MD5Token token2 = new MD5Token();
            token2.setValue(this.properties);
            AUTHTest.assertTrue((!token1.authenticate(token2, null) ? 1 : 0) != 0);
        }
        catch (Exception failException) {
            AUTHTest.fail((String)failException.getMessage());
        }
    }

    public void testAuthHeader() {
        try {
            this.properties.clear();
            this.properties.put("auth_value", "chris");
            SimpleToken token1 = new SimpleToken();
            token1.setValue(this.properties);
            AuthHeader header = new AuthHeader();
            header.setToken(token1);
            AUTHTest.assertTrue((token1 == header.getToken() ? 1 : 0) != 0);
        }
        catch (Exception failException) {
            AUTHTest.fail((String)failException.getMessage());
        }
    }

    public void testAuthHeaderDifferent() {
        try {
            this.properties.clear();
            this.properties.put("auth_value", "chris");
            SimpleToken token1 = new SimpleToken();
            token1.setValue(this.properties);
            this.properties.put("auth_value", "chris");
            SimpleToken token2 = new SimpleToken();
            token2.setValue(this.properties);
            AuthHeader header = new AuthHeader();
            header.setToken(token1);
            AUTHTest.assertTrue((token2 != header.getToken() ? 1 : 0) != 0);
        }
        catch (Exception failException) {
            AUTHTest.fail((String)failException.getMessage());
        }
    }

    public static Test suite() {
        TestSuite s = new TestSuite(AUTHTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AUTHTest.suite());
    }
}

