/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import junit.framework.TestCase;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.ENCRYPT;
import org.jgroups.stack.Protocol;

public class ENCRYPT14KeystoreTest
extends TestCase {
    public void testInitWrongKeystoreProperties() {
        Properties props = new Properties();
        String defaultKeystore = "unkownKeystore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            System.out.println("didn't find incorrect keystore (as expected): " + e.getMessage());
            ENCRYPT14KeystoreTest.assertEquals((String)("Unable to load keystore " + defaultKeystore + " ensure file is on classpath"), (String)e.getMessage());
        }
    }

    public void testInitKeystoreProperties() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        encrypt.init();
        ENCRYPT14KeystoreTest.assertNotNull((Object)encrypt.getSymDecodingCipher());
        ENCRYPT14KeystoreTest.assertNotNull((Object)encrypt.getSymEncodingCipher());
    }

    public void testMessageDownEncode() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        encrypt.init();
        Properties props2 = new Properties();
        props2.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt2 = new ENCRYPT();
        encrypt2.setProperties(props2);
        encrypt2.init();
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        String messageText = "hello this is a test message";
        Message msg = new Message(null, null, messageText.getBytes());
        Event event = new Event(1, msg);
        encrypt.down(event);
        Message sentMsg = (Message)((Event)observer.getDownMessages().get("message0")).getArg();
        String encText = new String(sentMsg.getBuffer());
        ENCRYPT14KeystoreTest.assertNotSame((Object)encText, (Object)messageText);
        Cipher cipher = encrypt2.getSymDecodingCipher();
        byte[] decodedBytes = cipher.doFinal(sentMsg.getBuffer());
        String temp = new String(decodedBytes);
        System.out.println("decoded text:" + temp);
        ENCRYPT14KeystoreTest.assertEquals((String)temp, (String)messageText);
    }

    public void testMessageUpDecode() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        encrypt.init();
        Properties props2 = new Properties();
        props2.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt2 = new ENCRYPT();
        encrypt2.setProperties(props2);
        encrypt2.init();
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        String messageText = "hello this is a test message";
        Cipher cipher = encrypt2.getSymEncodingCipher();
        byte[] encodedBytes = cipher.doFinal(messageText.getBytes());
        ENCRYPT14KeystoreTest.assertNotSame((Object)new String(encodedBytes), (Object)messageText);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(encrypt.getDesKey().getEncoded());
        String symVersion = new String(digest.digest(), "UTF-8");
        Message msg = new Message(null, null, encodedBytes);
        msg.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event event = new Event(1, msg);
        encrypt.up(event);
        Message rcvdMsg = (Message)((Event)observer.getUpMessages().get("message0")).getArg();
        String decText = new String(rcvdMsg.getBuffer());
        ENCRYPT14KeystoreTest.assertEquals((String)decText, (String)messageText);
    }

    public void testMessageUpWrongKey() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        String defaultKeystore2 = "defaultStore2.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        encrypt.init();
        Properties props2 = new Properties();
        ENCRYPT encrypt2 = new ENCRYPT();
        props2.setProperty("key_store_name", defaultKeystore2);
        encrypt2.setProperties(props2);
        encrypt2.init();
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        String messageText = "hello this is a test message";
        Cipher cipher = encrypt2.getSymEncodingCipher();
        byte[] encodedBytes = cipher.doFinal(messageText.getBytes());
        ENCRYPT14KeystoreTest.assertNotSame((Object)new String(encodedBytes), (Object)messageText);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(encrypt2.getDesKey().getEncoded());
        String symVersion = new String(digest.digest());
        Message msg = new Message(null, null, encodedBytes);
        msg.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event event = new Event(1, msg);
        encrypt.up(event);
        ENCRYPT14KeystoreTest.assertEquals((int)0, (int)observer.getUpMessages().size());
    }

    public void testMessageUpNoEncryptHeader() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        encrypt.init();
        Properties props2 = new Properties();
        props2.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt2 = new ENCRYPT();
        encrypt2.setProperties(props2);
        encrypt2.init();
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        String messageText = "hello this is a test message";
        Cipher cipher = encrypt2.getSymEncodingCipher();
        byte[] encodedBytes = cipher.doFinal(messageText.getBytes());
        ENCRYPT14KeystoreTest.assertNotSame((Object)new String(encodedBytes), (Object)messageText);
        Message msg = new Message(null, null, encodedBytes);
        Event event = new Event(1, msg);
        encrypt.up(event);
        ENCRYPT14KeystoreTest.assertEquals((int)0, (int)observer.getUpMessages().size());
    }

    public void testEventUpNoMessage() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        encrypt.init();
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        Event event = new Event(1, null);
        encrypt.up(event);
        ENCRYPT14KeystoreTest.assertEquals((int)1, (int)observer.getUpMessages().size());
    }

    public void testMessageUpNoBuffer() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        encrypt.init();
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        Message msg = new Message(null, null, null);
        Event event = new Event(1, msg);
        encrypt.up(event);
        ENCRYPT14KeystoreTest.assertEquals((int)1, (int)observer.getUpMessages().size());
    }

    static class MockAddress
    implements Address {
        private static final long serialVersionUID = -2044466632514705356L;

        MockAddress() {
        }

        public boolean isMulticastAddress() {
            return false;
        }

        public int size() {
            return 0;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void writeTo(DataOutputStream out) throws IOException {
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        }

        public int compareTo(Object o) {
            return -1;
        }
    }

    static class MockObserver
    implements ENCRYPT.Observer {
        private Map upMessages = new HashMap();
        private Map downMessages = new HashMap();
        private int counter = 0;

        MockObserver() {
        }

        private void storeUp(Event evt) {
            this.upMessages.put("message" + this.counter++, evt);
        }

        private void storeDown(Event evt) {
            this.downMessages.put("message" + this.counter++, evt);
        }

        public void up(Event evt) {
            this.storeUp(evt);
            System.out.println("Up:" + evt.toString());
        }

        public void setProtocol(Protocol prot) {
        }

        public void passUp(Event evt) {
            this.storeUp(evt);
            System.out.println("PassUp:" + evt.toString());
        }

        public void down(Event evt) {
            System.out.println("down:" + evt.toString());
        }

        public void passDown(Event evt) {
            this.storeDown(evt);
            System.out.println("passdown:" + evt.toString());
        }

        protected Map getUpMessages() {
            return this.upMessages;
        }

        protected void setUpMessages(Map upMessages) {
            this.upMessages = upMessages;
        }

        protected Map getDownMessages() {
            return this.downMessages;
        }

        protected void setDownMessages(Map downMessages) {
            this.downMessages = downMessages;
        }
    }
}

