/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.TimeoutException;
import org.jgroups.protocols.TP;
import org.jgroups.util.Promise;

public class UnicastLoopbackTest
extends TestCase {
    JChannel channel = null;

    public UnicastLoopbackTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.channel = new JChannel();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void testUnicastMsgsWithLoopback() throws Exception {
        long TIMEOUT = 2000L;
        int NUM = 1000;
        long num_msgs_sent_before = 0L;
        long num_msgs_sent_after = 0L;
        Promise p = new Promise();
        MyReceiver receiver = new MyReceiver(1000, p);
        this.channel.setReceiver(receiver);
        this.channel.connect("demo-group");
        Address local_addr = this.channel.getLocalAddress();
        UnicastLoopbackTest.setLoopbackProperty(this.channel, true);
        num_msgs_sent_before = UnicastLoopbackTest.getNumMessagesSentViaNetwork(this.channel);
        for (int i = 1; i <= 1000; ++i) {
            this.channel.send(new Message(local_addr, null, new Integer(i)));
            if (i % 100 != 0) continue;
            System.out.println("-- sent " + i);
        }
        num_msgs_sent_after = UnicastLoopbackTest.getNumMessagesSentViaNetwork(this.channel);
        UnicastLoopbackTest.assertTrue((String)"Messages are (incorrectly) being sent via network", (num_msgs_sent_after < 1000L ? 1 : 0) != 0);
        try {
            p.getResultWithTimeout(2000L);
        }
        catch (TimeoutException te) {
            UnicastLoopbackTest.fail((String)"Test timed out before all messages were received");
        }
    }

    private static long getNumMessagesSentViaNetwork(JChannel ch) throws Exception {
        TP transport = ch.getProtocolStack().getTransport();
        if (transport == null) {
            throw new Exception("transport layer is not present - check default stack configuration");
        }
        return transport.getNumMessagesSent();
    }

    private static void setLoopbackProperty(JChannel ch, boolean loopback) throws Exception {
        TP transport = ch.getProtocolStack().getTransport();
        if (transport == null) {
            throw new Exception("transport layer is not present - check default stack configuration");
        }
        if (loopback && transport.isLoopback() || !loopback && !transport.isLoopback()) {
            return;
        }
        transport.setLoopback(loopback);
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private final int numExpected;
        private int numReceived;
        private final Promise p;

        public MyReceiver(int numExpected, Promise p) {
            this.numExpected = numExpected;
            this.numReceived = 0;
            this.p = p;
        }

        public void receive(Message msg) {
            Integer num = (Integer)msg.getObject();
            ++this.numReceived;
            if (num != null && num % 100 == 0) {
                System.out.println("-- received " + num);
            }
            if (this.numReceived >= this.numExpected) {
                this.p.setResult(Boolean.TRUE);
            }
        }

        public int getNumMsgsReceived() {
            return this.numReceived;
        }
    }
}

