/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authc.pam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AbstractAuthenticator;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.LogoutAware;
import org.jsecurity.authc.UnknownAccountException;
import org.jsecurity.authc.pam.AllSuccessfulModularAuthenticationStrategy;
import org.jsecurity.authc.pam.ModularAuthenticationStrategy;
import org.jsecurity.authc.pam.UnsupportedTokenException;
import org.jsecurity.realm.Realm;
import org.jsecurity.subject.PrincipalCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModularRealmAuthenticator
extends AbstractAuthenticator {
    private static final Log log = LogFactory.getLog(ModularRealmAuthenticator.class);
    private Collection<Realm> realms;
    private ModularAuthenticationStrategy modularAuthenticationStrategy;

    public ModularRealmAuthenticator() {
        AllSuccessfulModularAuthenticationStrategy strategy = new AllSuccessfulModularAuthenticationStrategy();
        this.setModularAuthenticationStrategy(strategy);
    }

    public ModularRealmAuthenticator(Realm realm) {
        this.setRealm(realm);
    }

    public ModularRealmAuthenticator(List<Realm> realms) {
        this.setRealms(realms);
    }

    public void setRealm(Realm realm) {
        ArrayList<Realm> realms = new ArrayList<Realm>(1);
        realms.add(realm);
        this.setRealms(realms);
    }

    public void setRealms(Collection<Realm> realms) {
        this.realms = realms;
    }

    protected Collection<Realm> getRealms() {
        return this.realms;
    }

    public ModularAuthenticationStrategy getModularAuthenticationStrategy() {
        return this.modularAuthenticationStrategy;
    }

    public void setModularAuthenticationStrategy(ModularAuthenticationStrategy modularAuthenticationStrategy) {
        this.modularAuthenticationStrategy = modularAuthenticationStrategy;
    }

    protected void assertRealmsConfigured() throws IllegalStateException {
        Collection<Realm> realms = this.getRealms();
        if (realms == null || realms.isEmpty()) {
            String msg = "Configuration error:  No realms have been configured!  One or more realms must be present to execute an authentication attempt.";
            throw new IllegalStateException(msg);
        }
    }

    protected AuthenticationInfo doSingleRealmAuthentication(Realm realm, AuthenticationToken token) {
        if (!realm.supports(token)) {
            String msg = "Realm [" + realm + "] does not support authentication token [" + token + "].  Please ensure that the appropriate Realm implementation is " + "configured correctly or that the realm accepts AuthenticationTokens of this type.";
            throw new UnsupportedTokenException(msg);
        }
        AuthenticationInfo info = realm.getAuthenticationInfo(token);
        if (info == null) {
            String msg = "Realm [" + realm + "] was unable to find account data for the " + "submitted AuthenticationToken [" + token + "].";
            throw new UnknownAccountException(msg);
        }
        return info;
    }

    protected AuthenticationInfo doMultiRealmAuthentication(Collection<Realm> realms, AuthenticationToken token) {
        ModularAuthenticationStrategy strategy = this.getModularAuthenticationStrategy();
        AuthenticationInfo aggregate = strategy.beforeAllAttempts(realms, token);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Iterating through [" + realms.size() + "] realms for PAM authentication"));
        }
        for (Realm realm : realms) {
            if (realm.supports(token)) {
                Throwable t;
                AuthenticationInfo info;
                block6: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Attempting to authenticate token [" + token + "] " + "using realm of type [" + realm + "]"));
                    }
                    info = null;
                    t = null;
                    try {
                        info = realm.getAuthenticationInfo(token);
                    }
                    catch (Throwable throwable) {
                        t = throwable;
                        if (!log.isTraceEnabled()) break block6;
                        String msg = "Realm [" + realm + "] threw an exception during a multi-realm authentication attempt:";
                        log.trace((Object)msg, t);
                    }
                }
                aggregate = strategy.afterAttempt(realm, token, info, aggregate, t);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Realm of type [" + realm + "] does not support token " + "[" + token + "].  Skipping realm."));
        }
        aggregate = strategy.afterAllAttempts(token, aggregate);
        return aggregate;
    }

    @Override
    protected AuthenticationInfo doAuthenticate(AuthenticationToken authenticationToken) throws AuthenticationException {
        this.assertRealmsConfigured();
        Collection<Realm> realms = this.getRealms();
        if (realms.size() == 1) {
            return this.doSingleRealmAuthentication(realms.iterator().next(), authenticationToken);
        }
        return this.doMultiRealmAuthentication(realms, authenticationToken);
    }

    @Override
    public void onLogout(PrincipalCollection principals) {
        super.onLogout(principals);
        Collection<Realm> realms = this.getRealms();
        if (realms != null && !realms.isEmpty()) {
            for (Realm realm : realms) {
                if (!(realm instanceof LogoutAware)) continue;
                ((LogoutAware)((Object)realm)).onLogout(principals);
            }
        }
    }
}

