/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authz.HostUnauthorizedException;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.session.SessionListener;
import org.jsecurity.session.SessionListenerRegistrar;
import org.jsecurity.session.UnknownSessionException;
import org.jsecurity.session.mgt.ImmutableProxiedSession;
import org.jsecurity.session.mgt.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionManager
implements SessionManager,
SessionListenerRegistrar {
    private static final Log log = LogFactory.getLog(AbstractSessionManager.class);
    protected Collection<SessionListener> listeners = new ArrayList<SessionListener>();

    @Override
    public void setSessionListeners(Collection<SessionListener> listeners) {
        this.listeners = listeners == null ? new ArrayList<SessionListener>() : listeners;
    }

    @Override
    public void add(SessionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean remove(SessionListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public Serializable start(InetAddress originatingHost) throws HostUnauthorizedException, IllegalArgumentException {
        Session session = this.createSession(originatingHost);
        this.notifyStart(session);
        return session.getId();
    }

    protected Session beforeInvalidNotification(Session session) {
        return new ImmutableProxiedSession(session);
    }

    protected void notifyStart(Session session) {
        for (SessionListener listener : this.listeners) {
            listener.onStart(session);
        }
    }

    protected void notifyStop(Session session) {
        Session forNotification = this.beforeInvalidNotification(session);
        for (SessionListener listener : this.listeners) {
            listener.onStop(forNotification);
        }
    }

    protected void notifyExpiration(Session session) {
        Session forNotification = this.beforeInvalidNotification(session);
        for (SessionListener listener : this.listeners) {
            listener.onExpiration(forNotification);
        }
    }

    @Override
    public Date getStartTimestamp(Serializable sessionId) {
        return this.getSession(sessionId).getStartTimestamp();
    }

    @Override
    public Date getLastAccessTime(Serializable sessionId) {
        return this.getSession(sessionId).getStartTimestamp();
    }

    @Override
    public long getTimeout(Serializable sessionId) throws InvalidSessionException {
        return this.getSession(sessionId).getTimeout();
    }

    @Override
    public void setTimeout(Serializable sessionId, long maxIdleTimeInMillis) throws InvalidSessionException {
        Session s = this.getSession(sessionId);
        s.setTimeout(maxIdleTimeInMillis);
        this.onChange(s);
    }

    @Override
    public void touch(Serializable sessionId) throws InvalidSessionException {
        Session s = this.getSession(sessionId);
        s.touch();
        this.onChange(s);
    }

    @Override
    public InetAddress getHostAddress(Serializable sessionId) {
        return this.getSession(sessionId).getHostAddress();
    }

    @Override
    public void stop(Serializable sessionId) throws InvalidSessionException {
        Session session = this.getSession(sessionId);
        this.stop(session);
    }

    protected void stop(Session session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping session with id [" + session.getId() + "]"));
        }
        this.notifyStop(session);
        session.stop();
        this.onStop(session);
    }

    protected void onStop(Session session) {
        this.onChange(session);
    }

    protected void onExpiration(Session session) {
        this.onChange(session);
    }

    @Override
    public Collection<Object> getAttributeKeys(Serializable sessionId) {
        return this.getSession(sessionId).getAttributeKeys();
    }

    @Override
    public Object getAttribute(Serializable sessionId, Object key) throws InvalidSessionException {
        return this.getSession(sessionId).getAttribute(key);
    }

    @Override
    public void setAttribute(Serializable sessionId, Object key, Object value) throws InvalidSessionException {
        if (value == null) {
            this.removeAttribute(sessionId, key);
        } else {
            Session s = this.getSession(sessionId);
            s.setAttribute(key, value);
            this.onChange(s);
        }
    }

    @Override
    public Object removeAttribute(Serializable sessionId, Object key) throws InvalidSessionException {
        Session s = this.getSession(sessionId);
        Object removed = s.removeAttribute(key);
        if (removed != null) {
            this.onChange(s);
        }
        return removed;
    }

    protected Session getSession(Serializable sessionId) throws InvalidSessionException {
        Session session = this.doGetSession(sessionId);
        if (session == null) {
            String msg = "There is no session with id [" + sessionId + "]";
            throw new UnknownSessionException(msg);
        }
        return session;
    }

    @Override
    public boolean isValid(Serializable sessionId) {
        try {
            this.getSession(sessionId);
        }
        catch (InvalidSessionException e) {
            return false;
        }
        return true;
    }

    protected void onChange(Session s) {
    }

    protected abstract Session doGetSession(Serializable var1) throws InvalidSessionException;

    protected abstract Session createSession(InetAddress var1) throws HostUnauthorizedException, IllegalArgumentException;
}

