/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.navigation.UINavigationNodeSelector;
import org.exoplatform.portal.webui.page.UIPageNodeForm;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/navigation/UINavigationManagement.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddRootNodeActionListener.class})})
public class UINavigationManagement
extends UIContainer {
    private String owner;
    private String ownerType;

    public UINavigationManagement() throws Exception {
        this.addChild(UINavigationNodeSelector.class, null, null);
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public <T extends UIComponent> T setRendered(boolean b) {
        return (T)super.setRendered(b);
    }

    public void loadView(Event<? extends UIComponent> event) throws Exception {
        UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)this.getChild(UINavigationNodeSelector.class);
        UITree uiTree = (UITree)uiNodeSelector.getChild(UITree.class);
        uiTree.createEvent("ChangeNode", event.getExecutionPhase(), event.getRequestContext()).broadcast();
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRootNodeActionListener
    extends EventListener<UINavigationManagement> {
        public void execute(Event<UINavigationManagement> event) throws Exception {
            UINavigationManagement uiManagement = (UINavigationManagement)((Object)event.getSource());
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiManagement.getChild(UINavigationNodeSelector.class);
            UIPopupWindow uiManagementPopup = (UIPopupWindow)uiNodeSelector.getAncestorOfType(UIPopupWindow.class);
            UIPageNodeForm uiNodeForm = (UIPageNodeForm)uiManagementPopup.createUIComponent(UIPageNodeForm.class, null, null);
            uiNodeForm.setValues(null);
            uiManagementPopup.setUIComponent((UIComponent)uiNodeForm);
            PageNavigation nav = uiNodeSelector.getEdittedNavigation();
            uiNodeForm.setSelectedParent(nav);
            uiNodeForm.setContextPageNavigation(nav);
            uiManagementPopup.setWindowSize(800, 500);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiManagementPopup.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UINavigationManagement> {
        /*
         * Enabled aggressive block sorting
         */
        public void execute(Event<UINavigationManagement> event) throws Exception {
            String editedOwnerId;
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UINavigationManagement uiManagement = (UINavigationManagement)((Object)event.getSource());
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiManagement.getChild(UINavigationNodeSelector.class);
            DataStorage dataService = (DataStorage)uiManagement.getApplicationComponent(DataStorage.class);
            UserPortalConfigService portalConfigService = (UserPortalConfigService)uiManagement.getApplicationComponent(UserPortalConfigService.class);
            PageNavigation navigation = uiNodeSelector.getEdittedNavigation();
            String editedOwnerType = navigation.getOwnerType();
            PageNavigation persistNavigation = dataService.getPageNavigation(editedOwnerType, editedOwnerId = navigation.getOwnerId());
            if (persistNavigation == null) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UINavigationManagement.msg.NavigationNotExistAnymore", null));
                UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getParent();
                uiPopup.setShow(false);
                UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                prContext.setFullRender(true);
                return;
            }
            if ("portal".equals(navigation.getOwnerType())) {
                UserPortalConfig portalConfig = portalConfigService.getUserPortalConfig(navigation.getOwnerId(), prContext.getRemoteUser());
                if (portalConfig == null) {
                    UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                    uiApp.addMessage(new ApplicationMessage("UIPortalForm.msg.notExistAnymore", null));
                    UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getParent();
                    uiPopup.setShow(false);
                    UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
                    UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                    prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                    prContext.setFullRender(true);
                    return;
                }
                dataService.save(navigation);
            } else {
                dataService.save(navigation);
            }
            navigation = dataService.getPageNavigation(navigation.getOwnerType(), navigation.getOwnerId());
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            this.setNavigation(uiPortalApp.getNavigations(), navigation);
            uiPortalApp.localizeNavigations();
            UIPortal targetedUIPortal = uiPortalApp.getCachedUIPortal(editedOwnerType, editedOwnerId);
            if (targetedUIPortal != null) {
                targetedUIPortal.setNavigation(navigation);
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getParent();
            uiPopup.setShow(false);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            prContext.setFullRender(true);
        }

        private void setNavigation(List<PageNavigation> navs, PageNavigation nav) {
            for (int i = 0; i < navs.size(); ++i) {
                if (navs.get(i).getId() != nav.getId()) continue;
                navs.set(i, nav);
                return;
            }
        }
    }
}

