/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIConfirmation;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={ConfirmCloseActionListener.class}), @EventConfig(listeners={AbortCloseActionListener.class})})
public class UIEditInlineWorkspace
extends UIContainer {
    public UIEditInlineWorkspace() throws Exception {
        this.addChild(UIPortalComposer.class, null, null);
        this.addChild(UIPortalToolPanel.class, null, null);
        ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
        String yes = resourceBundle.getString("UIEditInlineWorkspace.confirm.yes");
        String no = resourceBundle.getString("UIEditInlineWorkspace.confirm.no");
        ArrayList<UIConfirmation.ActionConfirm> actionConfirms = new ArrayList<UIConfirmation.ActionConfirm>();
        actionConfirms.add(new UIConfirmation.ActionConfirm("ConfirmClose", yes));
        actionConfirms.add(new UIConfirmation.ActionConfirm("AbortClose", no));
        UIConfirmation uiConfirmation = (UIConfirmation)this.addChild(UIConfirmation.class, null, null);
        uiConfirmation.setCaller((Object)this);
        uiConfirmation.setActions(actionConfirms);
    }

    public void setUIComponent(UIComponent uiComp) {
        ((UIPortalToolPanel)this.getChild(UIPortalToolPanel.class)).setUIComponent(uiComp);
    }

    public UIComponent getUIComponent() {
        return ((UIPortalToolPanel)this.getChild(UIPortalToolPanel.class)).getUIComponent();
    }

    public UIPortalComposer getComposer() {
        return (UIPortalComposer)this.getChild(UIPortalComposer.class);
    }

    public void showConfirmWindow(String message) {
        UIConfirmation uiConfirmation = (UIConfirmation)this.getChild(UIConfirmation.class);
        uiConfirmation.setMessage(message);
        ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)uiConfirmation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbortCloseActionListener
    extends EventListener<UIEditInlineWorkspace> {
        public void execute(Event<UIEditInlineWorkspace> event) throws Exception {
            UIEditInlineWorkspace uiEditInlineWorkspace = (UIEditInlineWorkspace)((Object)event.getSource());
            UIConfirmation uiConfirmation = (UIConfirmation)uiEditInlineWorkspace.getChild(UIConfirmation.class);
            uiConfirmation.createEvent("Close", event.getExecutionPhase(), event.getRequestContext()).broadcast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfirmCloseActionListener
    extends EventListener<UIEditInlineWorkspace> {
        public void execute(Event<UIEditInlineWorkspace> event) throws Exception {
            UIEditInlineWorkspace uiEditInlineWorkspace = (UIEditInlineWorkspace)((Object)event.getSource());
            UIConfirmation uiConfirmation = (UIConfirmation)uiEditInlineWorkspace.getChild(UIConfirmation.class);
            uiConfirmation.createEvent("Close", event.getExecutionPhase(), event.getRequestContext()).broadcast();
            UIPortalComposer uiPortalComposer = (UIPortalComposer)uiEditInlineWorkspace.getChild(UIPortalComposer.class);
            Event abortEvent = uiPortalComposer.createEvent("Abort", event.getExecutionPhase(), event.getRequestContext());
            abortEvent.broadcast();
        }
    }
}

