/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui;

import com.ibm.icu.text.Transliterator;
import java.util.HashMap;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.core.UIPopupWindow;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String TURN_ON_QUICK_EDIT = "turnOnQuickEdit";

    @Deprecated
    public static boolean isEditPortletInCreatePageWizard() {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)portalApplication.getChildById("UIMaskWorkspace");
        return uiMaskWS.getWindowWidth() > 0 && uiMaskWS.getWindowHeight() < 0;
    }

    @Deprecated
    public static boolean isQuickEditMode(UIContainer container, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        if (popupContainer == null) {
            return false;
        }
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.getChildById(popupWindowId);
        return popupWindow != null;
    }

    public static boolean isPortalEditMode() {
        return Util.getUIPortalApplication().getModeState() != 0;
    }

    public static String getRealPortletId(PortletRequestContext portletRequestContext) {
        String portletId = portletRequestContext.getWindowId();
        int modeState = Util.getUIPortalApplication().getModeState();
        switch (modeState) {
            case 0: {
                return portletId;
            }
            case 1: {
                return "UIPortlet-" + portletId;
            }
            case 2: {
                return "EditMode-" + portletId;
            }
        }
        return null;
    }

    public static boolean canEditCurrentPortal(String remoteUser) throws Exception {
        if (remoteUser == null) {
            return false;
        }
        IdentityRegistry identityRegistry = (IdentityRegistry)Util.getUIPortalApplication().getApplicationComponent(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(remoteUser);
        if (identity == null) {
            return false;
        }
        UIPortal uiPortal = Util.getUIPortal();
        String editPermission = uiPortal.getEditPermission();
        MembershipEntry membershipEntry = MembershipEntry.parse((String)editPermission);
        return identity.isMemberOf(membershipEntry);
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '-') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '-';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (i > 0 && !Character.isLetterOrDigit(c) && c != '-') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 45 || cleanedStr.charAt(i - 1) != '-') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static void updatePortal(PortletRequestContext context) {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        PortalRequestContext portalRequestContext = (PortalRequestContext)context.getParentAppRequestContext();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApplication.getChildById("UIWorkingWorkspace");
        portalRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)portalApplication.getChildById("UIMaskWorkspace");
        portalRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        portalRequestContext.setFullRender(true);
    }

    public static Node getViewableNodeByComposer(String repository, String workspace, String nodeIdentifier) {
        return Utils.getViewableNodeByComposer(repository, workspace, nodeIdentifier, null);
    }

    public static Node getViewableNodeByComposer(String repository, String workspace, String nodeIdentifier, String version) {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            String filterLang = Util.getPortalRequestContext().getLocale().getLanguage();
            String country = Util.getPortalRequestContext().getLocale().getCountry();
            if (country != null && country.length() > 0) {
                filterLang = filterLang + "_" + country;
            }
            filters.put("filter-language", filterLang);
            filters.put("filter-mode", Utils.getCurrentMode());
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletMode portletMode = portletRequestContext.getApplicationMode();
            filters.put("portlet-mode", portletMode.toString());
            if (version != null) {
                filters.put("filter-version", version);
            }
            return ((WCMComposer)WCMCoreUtils.getService(WCMComposer.class)).getContent(repository, workspace, nodeIdentifier, filters, WCMCoreUtils.getUserSessionProvider());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCurrentMode() {
        Object isQuickEditable = Util.getPortalRequestContext().getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        if (isQuickEditable == null) {
            return "Live";
        }
        boolean turnOnQuickEdit = Boolean.parseBoolean(isQuickEditable.toString());
        return turnOnQuickEdit ? "Edit" : "Live";
    }

    public static boolean isShowDraft(Node content) {
        if (content == null) {
            return false;
        }
        try {
            if (content.isNodeType("nt:frozenNode")) {
                return false;
            }
            WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
            String contentState = wcmPublicationService.getContentState(content);
            boolean isDraftContent = false;
            if ("draft".equals(contentState)) {
                isDraftContent = true;
            }
            boolean isShowDraft = false;
            if ("Edit".equals(Utils.getCurrentMode())) {
                isShowDraft = true;
            }
            return isDraftContent && isShowDraft;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShowQuickEdit() {
        try {
            boolean isEditMode = false;
            if ("Edit".equals(Utils.getCurrentMode())) {
                isEditMode = true;
            }
            return isEditMode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShowDelete(Node content) {
        return false;
    }

    public static boolean isShowQuickEdit(Node content) {
        if (content == null) {
            return true;
        }
        try {
            boolean isEditMode = false;
            if ("Edit".equals(Utils.getCurrentMode()) || Util.getUIPortalApplication().getModeState() != 0) {
                isEditMode = true;
            }
            ((ExtendedNode)content).checkPermission("set_property");
            ((ExtendedNode)content).checkPermission("add_node");
            ((ExtendedNode)content).checkPermission("remove");
            return isEditMode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getEditLink(Node node, boolean isEditable, boolean isNew) {
        try {
            String itemPath = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName() + '/' + node.getSession().getWorkspace().getName() + '/' + node.getPath();
            return Utils.getEditLink(itemPath, isEditable, isNew);
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public static String getEditLink(String itemPath, boolean isEditable, boolean isNew) {
        StringBuilder link = new StringBuilder();
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String portalURI = pContext.getPortalURI();
        String backto = pContext.getRequestURI();
        WCMConfigurationService configurationService = (WCMConfigurationService)Util.getUIPortalApplication().getApplicationComponent(WCMConfigurationService.class);
        String editorPageURI = configurationService.getRuntimeContextParam("editorPageURI");
        link.append(portalURI).append(editorPageURI).append("?").append("path=/").append(itemPath);
        if (isEditable) {
            link.append("&edit=true");
        }
        if (isNew) {
            link.append("&addNew=true");
        }
        link.append("&").append("backto").append("=").append(backto);
        return link.toString();
    }

    public static void createPopupWindow(UIContainer container, UIComponent component, String popupWindowId, int width) throws Exception {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        popupContainer.removeChildById(popupWindowId);
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.addChild(UIPopupWindow.class, null, popupWindowId);
        popupWindow.setUIComponent(component);
        popupWindow.setWindowSize(width, 0);
        popupWindow.setShow(true);
        popupWindow.setRendered(true);
        popupWindow.setResizable(true);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    public static void closePopupWindow(UIContainer container, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        popupContainer.removeChildById(popupWindowId);
    }

    public static void updatePopupWindow(UIContainer container, UIComponent component, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.getChildById(popupWindowId);
        popupWindow.setUIComponent(component);
    }

    public static UIPopupContainer getPopupContainer(UIContainer container) {
        if (container instanceof UIPortletApplication) {
            return (UIPopupContainer)container.getChild(UIPopupContainer.class);
        }
        UIPortletApplication portletApplication = (UIPortletApplication)container.getAncestorOfType(UIPortletApplication.class);
        return (UIPopupContainer)portletApplication.getChild(UIPopupContainer.class);
    }

    public static void createPopupMessage(UIContainer container, String message, Object[] args, int type) {
        UIApplication application = (UIApplication)container.getAncestorOfType(UIApplication.class);
        application.addMessage(new ApplicationMessage(message, args, type));
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
    }

    @Deprecated
    public static <T> T getService(Class<T> clazz) {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        return clazz.cast(portalApplication.getApplicationComponent(clazz));
    }

    @Deprecated
    public static SessionProvider getSessionProvider() {
        return WCMCoreUtils.getUserSessionProvider();
    }

    @Deprecated
    public static SessionProvider getSystemSessionProvider() {
        return WCMCoreUtils.getSystemSessionProvider();
    }

    public static String getPortletPreference(String preferenceName) {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        return preferences.getValue(preferenceName, null);
    }

    public static PortletPreferences getAllPortletPreferences() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    public static boolean isViewable(Node node) {
        try {
            node.refresh(true);
            ((ExtendedNode)node).checkPermission("read");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Node getRealNode(Node node) throws Exception {
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            return node.getSession().getNodeByUUID(uuid);
        }
        return node;
    }

    public static String getRealNodePath(Node node) throws Exception {
        if (node.isNodeType("nt:frozenNode")) {
            Node realNode = Utils.getRealNode(node);
            return realNode.getPath() + "?version=" + node.getParent().getName();
        }
        return node.getPath();
    }

    public static String getWebdavURL(Node node) throws Exception {
        NodeLocation location = NodeLocation.getNodeLocationByNode((Node)Utils.getRealNode(node));
        String repository = location.getRepository();
        String workspace = location.getWorkspace();
        String currentProtal = PortalContainer.getCurrentRestContextName();
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String originalNodePath = Utils.getRealNodePath(node);
        String imagePath = "/" + portalName + "/" + currentProtal + "/jcr/" + repository + "/" + workspace + originalNodePath;
        imagePath = imagePath.contains("?") ? imagePath + "&time=" : imagePath + "?time=";
        imagePath = imagePath + System.currentTimeMillis();
        return imagePath;
    }

    public static Node getRealNode(String strRepository, String strWorkspace, String strIdentifier, boolean isWCMBase) throws RepositoryException {
        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        Node selectedNode = isWCMBase ? Utils.getViewableNodeByComposer(strRepository, strWorkspace, strIdentifier, "base") : Utils.getViewableNodeByComposer(strRepository, strWorkspace, strIdentifier);
        if (selectedNode != null && !org.exoplatform.ecm.webui.utils.Utils.isInTrash(selectedNode)) {
            if (linkManager.isLink((Item)selectedNode)) {
                if (linkManager.isTargetReachable(selectedNode) && !org.exoplatform.ecm.webui.utils.Utils.isInTrash(selectedNode = linkManager.getTarget(selectedNode))) {
                    return selectedNode;
                }
            } else {
                return selectedNode;
            }
        }
        return null;
    }

    public static boolean hasEditPermissionOnPage() throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApp.getChildById("UIWorkingWorkspace");
        UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
        UIPage uiPage = (UIPage)pageBody.getUIComponent();
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        if (uiPage != null) {
            return userACL.hasEditPermissionOnPage(uiPage.getOwnerType(), uiPage.getOwnerId(), uiPage.getEditPermission());
        }
        UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
        PageNode currentNode = currentUIPortal.getSelectedNode();
        String pageReference = currentNode.getPageReference();
        if (pageReference == null) {
            return false;
        }
        DataStorage dataStorage = (DataStorage)portalApp.getApplicationComponent(DataStorage.class);
        Page page = dataStorage.getPage(pageReference);
        if (page == null) {
            return false;
        }
        return userACL.hasEditPermission(page);
    }

    public static boolean hasEditPermissionOnNavigation() throws Exception {
        PageNavigation selectedNavigation = Utils.getSelectedNavigation();
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        if (selectedNavigation == null || userACL == null) {
            return false;
        }
        if ("portal".equals(selectedNavigation.getOwnerType())) {
            return Utils.hasEditPermissionOnPortal();
        }
        return userACL.hasEditPermission(selectedNavigation);
    }

    public static boolean hasEditPermissionOnPortal() throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        return userACL.hasEditPermissionOnPortal(currentUIPortal.getOwnerType(), currentUIPortal.getOwner(), currentUIPortal.getEditPermission());
    }

    public static PageNavigation getSelectedNavigation() throws Exception {
        return Util.getUIPortal().getSelectedNavigation();
    }

    public static String sanitize(String string) {
        return string.replaceAll("(?i)<script.*?>.*?</script.*?>", "").replaceAll("(?i)<.*?javascript:.*?>.*?</.*?>", "").replaceAll("(?i)<.*?\\s+on.*?>.*?</.*?>", "");
    }
}

