/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.portlet.PortletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.NodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIViewSearchResult
extends UIContainer
implements NodePresentation {
    private Node node_;
    private String language_;
    private static final String COMMENT_COMPONENT = "Comment".intern();
    private static final Log LOG = ExoLogger.getLogger((String)"cms.UIViewSearchResult");

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        try {
            String nodeType = this.node_.getPrimaryNodeType().getName();
            return templateService.getTemplatePathByUser(false, nodeType, userName, uiExplorer.getRepositoryName());
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        NodeIterator childrenIterator = this.node_.getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        int attachData = 0;
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = Utils.getListAllowedFileType((Node)this.node_, (String)this.getRepository(), (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            if (childNode.hasProperty("jcr:data")) {
                attachData = childNode.getProperty("jcr:data").getStream().available();
                if (attachData <= 0) continue;
                attachments.add(childNode);
                continue;
            }
            attachments.add(childNode);
        }
        return attachments;
    }

    public String getAttachmentURL(Node attNode, Parameter[] params) throws Exception {
        return this.event("ChangeNode", Utils.formatNodeName((String)attNode.getPath()), params);
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "UIViewSearchResultRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "UIViewSearchResultRemoveComment");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public Node getNode() throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (this.node_.hasProperty("exo:language")) {
            String defaultLang = this.node_.getProperty("exo:language").getString();
            if (this.language_ == null) {
                this.language_ = defaultLang;
            }
            if (this.node_.hasNode("languages") && !this.language_.equals(defaultLang)) {
                Node curNode = this.node_.getNode("languages" + Utils.SLASH + this.language_);
                return curNode;
            }
            return this.node_;
        }
        return this.node_;
    }

    public Node getOriginalNode() throws Exception {
        return this.node_;
    }

    public String getIcons(Node node, String size) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)size);
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.node_.hasProperty("exo:relation")) {
            Value[] vals = this.node_.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    public boolean isRssLink() {
        return false;
    }

    public String getRssLink() {
        return null;
    }

    public List getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.node_);
    }

    public String getTemplatePath() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public boolean isNodeTypeSupported(String nodeTypeName) {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
            return templateService.isManagedNodeType(nodeTypeName, repository);
        }
        catch (Exception e) {
            return false;
        }
    }

    public UIComponent getCommentComponent() {
        UIViewSearchResult uicomponent = null;
        try {
            UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
            HashMap<String, UIJCRExplorer> context = new HashMap<String, UIJCRExplorer>();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            context.put(UIJCRExplorer.class.getName(), uiExplorer);
            context.put(Node.class.getName(), (UIJCRExplorer)this.node_);
            uicomponent = manager.addUIExtension("org.exoplatform.ecm.dms.UIActionBar", COMMENT_COMPONENT, context, (UIContainer)this);
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurs while checking the action", (Throwable)e);
        }
        return uicomponent != null ? uicomponent : this;
    }

    public boolean hasPropertyContent(Node node, String property) {
        try {
            String value = node.getProperty(property).getString();
            if (value.length() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return false;
    }

    public void setNode(Node node) {
        this.node_ = node;
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        String[] workspaces = manageRepo.getWorkspaceNames();
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        for (String ws : workspaces) {
            try {
                return sessionProvider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.node_, this.language_);
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        return tempServ.getTemplatePath(false, nodeTypeName, templateName, repository);
    }

    public String getLanguage() {
        return this.language_;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(className);
            service = this.getApplicationComponent(clazz);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)ex);
        }
        return service;
    }

    public String getImage(Node node) throws Exception {
        DownloadService downloadService = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource inputResource = new InputStreamDownloadResource(input, "image");
        inputResource.setDownloadName(node.getName());
        return downloadService.getDownloadLink(downloadService.addDownloadResource((DownloadResource)inputResource));
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRepository() throws Exception {
        return ((ManageableRepository)this.node_.getSession().getRepository()).getConfiguration().getName();
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext pRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        PortletRequest pRequest = pRequestContext.getRequest();
        String prefixWebDAV = pRequest.getScheme() + "://" + pRequest.getServerName() + ":" + String.format("%s", pRequest.getServerPort());
        return prefixWebDAV;
    }

    public String getWorkspaceName() throws Exception {
        return this.node_.getSession().getWorkspace().getName();
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
            return null;
        }
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String encodeHTML(String text) throws Exception {
        return Utils.encodeHTML((String)text);
    }

    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage(), this.getRepository());
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, (UIContainer)this);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }

    private Node getFileLangNode(Node currentNode) throws Exception {
        if (currentNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = currentNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.getPrimaryNodeType().getName().equals("nt:file")) continue;
                return ntFile;
            }
            return currentNode;
        }
        return currentNode;
    }

    public boolean isEnableComment() {
        return false;
    }

    public boolean isEnableVote() {
        return false;
    }

    public void setEnableComment(boolean value) {
    }

    public void setEnableVote(boolean value) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIViewSearchResult> {
        public void execute(Event<UIViewSearchResult> event) throws Exception {
            UIViewSearchResult uicomp = (UIViewSearchResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Session session = uiExplorer.getSessionByWorkspace(workspaceName);
            Node selectedNode = (Node)session.getItem(uri);
            uicomp.setNode(selectedNode);
            event.getRequestContext().addUIComponentToUpdateByAjax(uicomp.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadActionListener
    extends EventListener<UIViewSearchResult> {
        public void execute(Event<UIViewSearchResult> event) throws Exception {
            UIViewSearchResult uiComp = (UIViewSearchResult)((Object)event.getSource());
            String downloadLink = uiComp.getDownloadLink(uiComp.getFileLangNode(uiComp.getNode()));
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
            event.getRequestContext().addUIComponentToUpdateByAjax(uiComp.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UIViewSearchResult> {
        public void execute(Event<UIViewSearchResult> event) throws Exception {
            UIViewSearchResult uiViewSearchResult = (UIViewSearchResult)((Object)event.getSource());
            String selectedLanguage = event.getRequestContext().getRequestParameter("objectId");
            uiViewSearchResult.setLanguage(selectedLanguage);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiViewSearchResult.getParent());
        }
    }
}

