/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.connection.impl;

import java.util.Queue;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class HistoryJob
implements Job {
    private static Log log = ExoLogger.getLogger((String)"job.ChatRecordsJob");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        PortalContainer container = HistoryJob.getPortalContainer(context);
        if (container == null) {
            return;
        }
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            int logBatchSize = Integer.parseInt(jdatamap.getString("logBatchSize"));
            HistoryImpl historyImpl = (HistoryImpl)container.getComponentInstanceOfType(HistoryImpl.class);
            Queue<HistoricalMessage> logQueue = historyImpl.getLogQueue();
            for (int index = 0; index <= logBatchSize && !logQueue.isEmpty(); ++index) {
                boolean success;
                HistoricalMessage message = logQueue.poll();
                if (message == null || (success = historyImpl.addHistoricalMessage(message, provider))) continue;
                logQueue.add(message);
            }
        }
        catch (Exception e) {
            log.error((Object)"An exception happened when saving chat message", (Throwable)e);
        }
        finally {
            provider.close();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }

    private static PortalContainer getPortalContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = context.getJobDetail().getGroup();
        if (portalName == null) {
            return null;
        }
        if (portalName.indexOf(":") > 0) {
            portalName = portalName.substring(0, portalName.indexOf(":"));
        }
        return RootContainer.getInstance().getPortalContainer(portalName);
    }
}

