/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.presence.DefaultPresenceStatus;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.xmpp.bean.ConfigRoomBean;
import org.exoplatform.services.xmpp.bean.ContactBean;
import org.exoplatform.services.xmpp.bean.FormBean;
import org.exoplatform.services.xmpp.bean.FullRoomInfoBean;
import org.exoplatform.services.xmpp.bean.HostedRoomBean;
import org.exoplatform.services.xmpp.bean.InitInfoBean;
import org.exoplatform.services.xmpp.bean.InterlocutorListBean;
import org.exoplatform.services.xmpp.bean.JsResourceBundleBean;
import org.exoplatform.services.xmpp.bean.MessageBean;
import org.exoplatform.services.xmpp.bean.MessageListBean;
import org.exoplatform.services.xmpp.connection.XMPPSession;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.connection.impl.XMPPSessionImpl;
import org.exoplatform.services.xmpp.ext.transport.AIMTransport;
import org.exoplatform.services.xmpp.ext.transport.GtalkTransport;
import org.exoplatform.services.xmpp.ext.transport.ICQTransport;
import org.exoplatform.services.xmpp.ext.transport.MSNTransport;
import org.exoplatform.services.xmpp.ext.transport.YahooTransport;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.exoplatform.services.xmpp.userinfo.UserInfo;
import org.exoplatform.services.xmpp.userinfo.UserInfoService;
import org.exoplatform.services.xmpp.util.PresenceUtil;
import org.exoplatform.services.xmpp.util.TransformUtils;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/xmpp")
public class RESTXMPPService
implements ResourceContainer,
Startable {
    private static final Map<String, String> jsResourceBundle = new HashMap<String, String>(){
        {
            this.put("chat.message.xmpp.session.is.null", "chat_message_xmpp_session_is_null");
            this.put("chat.message.room.creation.error", "chat_message_room_creation_error");
            this.put("chat.message.room.show.config", "chat_message_room_show_config");
            this.put("chat.message.room.default.config.commit", "chat_message_room_default_config_commit");
            this.put("chat.message.room.configuration.error", "chat_message_room_configuration_error");
            this.put("chat.message.room.password.error", "chat_message_room_password_error");
            this.put("chat.message.room.not.unlocked.error", "chat_message_room_not_unlocked_error");
            this.put("chat.message.room.user.not.member", "chat_message_room_user_not_member");
            this.put("chat.message.room.name.is.invalid", "chat_message_room_name_is_invalid");
            this.put("chat.message.room.secret.key.to.access", "chat_message_room_secret_key_to_access");
            this.put("chat.message.room.invite.to.join", "chat_message_room_invite_to_join");
            this.put("chat.message.room.user.left", "chat_message_room_user_left");
            this.put("chat.message.room.user.join", "chat_message_room_user_join");
            this.put("chat.message.confirm.allow.to.see.status", "chat_message_confirm_allow_to_see_status");
            this.put("chat.message.confirm.remove.buddy", "chat_message_confirm_remove_buddy");
            this.put("chat.message.system.info", "chat_message_system_info");
            this.put("chat.message.administrative.message", "chat_message_administrative_message");
            this.put("chat.message.file.transport.request", "chat_message_file_transport_request");
            this.put("chat.message.file.transport.response.completed", "chat_message_file_transport_response_completed");
            this.put("chat.message.file.transport.response.denied", "chat_message_file_transport_response_denied");
            this.put("chat.message.file.transport.response.receiver.offline", "chat_message_file_transport_response_receiver_offline");
            this.put("chat.message.file.event.time.out", "chat_message_file_event_time_out");
            this.put("chat.message.file.exchange.waiting.for.authorize", "chat_message_file_exchange_waiting_for_authorize");
            this.put("chat.message.file.exchange.uploading.file.to.server", "chat_message_file_exchange_uploading_file_to_server");
        }
    };
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final Log log = ExoLogger.getLogger((String)"lr.RESTXMPPService");
    private final XMPPMessenger messenger;
    private final UserInfoService organization;
    private final ContinuationServiceDelegate delegate;
    private final ResourceBundleService rbs;
    private ResourceBundle rb;
    private static final String BUNDLE_NAME = "locale.message.chat.serverMessage";
    private final HistoryImpl history;
    private static final CacheControl cc;

    public RESTXMPPService(XMPPMessenger messenger, UserInfoService organization, ContinuationServiceDelegate delegate, HistoryImpl history, ResourceBundleService rbs) {
        this.messenger = messenger;
        this.organization = organization;
        this.delegate = delegate;
        this.history = history;
        this.rbs = rbs;
    }

    public void start() {
        this.loadResourceBundle();
    }

    public void stop() {
    }

    public ResourceBundle loadResourceBundle() {
        this.rb = this.rbs.getResourceBundle(BUNDLE_NAME, Locale.getDefault());
        return this.rb;
    }

    @GET
    @Path(value="/loadJsResourceBundle/{locale}/")
    @Produces(value={"application/json"})
    public Response loadJsResourceBundle(@PathParam(value="locale") String locale) {
        ResourceBundle jsRb = this.rbs.getResourceBundle(BUNDLE_NAME, new Locale(locale));
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("eXo.communication.chatbar.locale.ResourceBundle = {\n");
            for (Map.Entry<String, String> entry : jsResourceBundle.entrySet()) {
                String value = jsRb != null && jsRb.getString(entry.getKey()) != null ? jsRb.getString(entry.getKey()) : entry.getKey();
                sb.append(entry.getValue() + " : \"").append(value).append("\",\n");
            }
            sb.append("chat_message_finish_load_resource_bundle : \"finish load resource bundle\"\n");
            sb.append("};");
            JsResourceBundleBean jsResourceBundleBean = new JsResourceBundleBean();
            jsResourceBundleBean.setScript(sb.toString());
            return Response.ok((Object)jsResourceBundleBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/muc/createroom/{username}/")
    @Produces(value={"application/json"})
    public Response createRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            Response.status((int)400);
            return Response.ok((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            String roomEscape = StringUtils.escapeNode((String)room.toLowerCase());
            try {
                RoomInfo roomInfo = session.getRoomInfo(roomEscape);
                if (roomInfo != null) {
                    return this.joinRoom(username, room, nickname, null);
                }
            }
            catch (XMPPException e) {
                // empty catch block
            }
            try {
                FormBean formBean = session.createRoom(roomEscape, nickname);
                ArrayList<String> values = new ArrayList<String>();
                values.add(room);
                formBean = TransformUtils.changeFieldForm(formBean, "muc#roomconfig_roomname", values);
                formBean = TransformUtils.changeFieldForm(formBean, "muc#roomconfig_roomdesc", values);
                return Response.ok((Object)formBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (Exception e) {
                return Response.status((int)500).entity((Object)(this.rb.getString("chat.message.room.creation.error") + "\n" + e.getMessage())).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @POST
    @Path(value="/muc/configroom/{username}/")
    @Consumes(value={"application/json"})
    public Response configRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room, ConfigRoomBean configRoom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                if (session.getMultiUserChat(room = StringUtils.escapeNode((String)room.toLowerCase())) != null) {
                    session.configRoom(room, configRoom);
                }
                return Response.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
            }
            return Response.status((int)500).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
        }
        catch (XMPPException e) {
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)(this.rb.getString("chat.message.conference.configuration.error") + "\n" + error.getMessage())).build();
        }
    }

    @GET
    @Path(value="/muc/getroomconfig/{username}/")
    @Produces(value={"application/json"})
    public Response getRoomConfigForm(@PathParam(value="username") String username, @QueryParam(value="room") String room) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                FormBean formBean = session.getConfigFormRoom(room);
                if (formBean != null) {
                    return Response.ok((Object)formBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.status((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.conference.configuration.error")).build();
            }
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/getroominfo/{username}/")
    @Produces(value={"application/json"})
    public Response getRoomInfo(@PathParam(value="username") String username, @QueryParam(value="room") String room) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                FullRoomInfoBean infoBean = session.getRoomInfoBean(room.toLowerCase());
                if (infoBean != null) {
                    return Response.ok((Object)infoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.status((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)(this.rb.getString("chat.message.conference.info.error") + "\n" + error.getMessage())).build();
            }
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/joinedrooms/{username}/")
    @Produces(value={"application/json"})
    public Response getJoinedRooms(@PathParam(value="username") String username) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            try {
                ArrayList<FullRoomInfoBean> joinedRooms = new ArrayList<FullRoomInfoBean>();
                List<String> list = session.getJoinedRooms();
                for (String room : list) {
                    joinedRooms.add(session.getRoomInfoBean(room));
                }
                InitInfoBean bean = new InitInfoBean();
                bean.setJoinedRooms(joinedRooms);
                bean.setTotalJoinedRooms(list.size());
                return Response.ok((Object)bean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)(this.rb.getString("chat.message.conference.info.error") + "\n" + error.getMessage())).build();
            }
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @Deprecated
    @GET
    @Path(value="/muc/rooms-old/{username}/")
    @Produces(value={"application/json"})
    public Response getRooms(@PathParam(value="username") String username) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            try {
                XMPPConnection connection = session.getConnection();
                Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
                String mucService = collectionMUCService.toArray()[0].toString();
                ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
                Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
                for (HostedRoom hostedRoom : hostedRooms) {
                    HostedRoomBean roomBean = new HostedRoomBean();
                    RoomInfo roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)connection, (String)hostedRoom.getJid());
                    if (roomInfo != null) {
                        roomBean = new HostedRoomBean(roomInfo);
                    }
                    roomBean.setJid(hostedRoom.getJid());
                    roomBean.setName(hostedRoom.getName());
                    rooms.add(roomBean);
                }
                InitInfoBean infoBean = new InitInfoBean();
                infoBean.setHostedRooms(rooms);
                return Response.ok((Object)infoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)error.getMessage()).build();
            }
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/rooms/{username}/")
    @Produces(value={"application/json"})
    public Response getRooms(@PathParam(value="username") String username, @QueryParam(value="from") Integer from, @QueryParam(value="to") Integer to, @QueryParam(value="sort") String sort) {
        XMPPSessionImpl session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = (XMPPSessionImpl)this.messenger.getSession(username)) != null) {
            try {
                return Response.ok((Object)session.getRooms(from, to, sort), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)(this.rb.getString("chat.message.conference.info.error") + "\n" + error.getMessage())).build();
            }
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/decline/{username}/{inviter}/")
    public Response declineToRoom(@PathParam(value="username") String username, @PathParam(value="inviter") String inviter, @QueryParam(value="room") String room, @QueryParam(value="reason") String reason) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            session.declineRoom(room, inviter, reason);
            return Response.ok().cacheControl(cc).build();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/destroy/{username}/")
    public Response destroyRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="reason") String reason, @QueryParam(value="altroom") String altRoom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.destroyRoom(room, reason, altRoom).booleanValue()) {
                    return Response.ok().cacheControl(cc).build();
                }
                return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.not.found")).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)(this.rb.getString("chat.message.room.destroy.error") + "\n" + error.getMessage())).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/invite/{username}/{invitee}/")
    public Response inviteToRoom(@PathParam(value="username") String username, @PathParam(value="invitee") String invitee, @QueryParam(value="room") String room, @QueryParam(value="reason") String reason) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserInfoService organization = (UserInfoService)container.getComponentInstanceOfType(UserInfoService.class);
        InitInfoBean inviteeBean = new InitInfoBean();
        ContactBean inviteeProfile = new ContactBean();
        inviteeProfile.setUser(invitee);
        UserInfo inviteeInfo = organization.getUserInfo(invitee);
        inviteeProfile.setFullName(inviteeInfo.getFirstName() + " " + inviteeInfo.getLastName());
        inviteeBean.setMyProfile(inviteeProfile);
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.inviteToRoom(room, invitee, reason).booleanValue()) {
                    return Response.ok((Object)inviteeBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.status((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                e.printStackTrace();
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.conference.service.error")).build();
            }
        }
        return Response.status((int)400).cacheControl(cc).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/join/{username}/")
    @Produces(value={"application/json"})
    public Response joinRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="password") String password) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.joinRoom(room, nickname, password);
                return Response.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 401: {
                        em = this.rb.getString("chat.message.password.private.room.error");
                        break;
                    }
                    case 403: {
                        em = this.rb.getString("chat.message.you.have.been.banned");
                        break;
                    }
                    case 404: {
                        em = this.rb.getString("chat.message.no.room.to.join.error");
                        break;
                    }
                    case 407: {
                        em = this.rb.getString("chat.message.room.user.not.member");
                        break;
                    }
                    case 409: {
                        em = this.rb.getString("chat.message.room.nickname.already.exist");
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.status((int)error.getCode()).entity((Object)em).build();
            }
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @GET
    @Path(value="/muc/leaveroom/{username}/")
    public Response leftRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.leaveRoom(room).booleanValue()) {
                    return Response.ok().cacheControl(cc).build();
                }
                return Response.status((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
            }
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @GET
    @Path(value="/muc/changenickname/{username}/{nickname}/")
    public Response changeNickname(@PathParam(value="username") String username, @QueryParam(value="nickname") String nickname, @QueryParam(value="room") String room) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || nickname == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeNickname(room, nickname);
                return Response.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 409: {
                        em = this.rb.getString("chat.message.room.nickname.already.exist");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.status((int)error.getCode()).entity((Object)em).build();
            }
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @GET
    @Path(value="/muc/changestatus/{username}/{mode}/")
    public Response changeAvailabilityStatusInRoom(@PathParam(value="username") String username, @PathParam(value="mode") String mode, @QueryParam(value="room") String room, @QueryParam(value="status") String status) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeAvailabilityStatusInRoom(room, status, mode);
                return Response.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
            }
        }
        return Response.ok((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/changesubject/{username}/")
    public Response changeSubject(@PathParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="subject") String subject) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || subject == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeSubject(room, subject);
                return Response.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.status((int)error.getCode()).entity((Object)error.getMessage()).build();
            }
        }
        return Response.ok((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/muc/managerole/{username}/")
    public Response manageRoleRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="role") String role, @QueryParam(value="command") String command) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || nickname == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.manageRole(room, nickname, role, command);
                return Response.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 403: {
                        em = this.rb.getString("chat.message.forbidden.error");
                        break;
                    }
                    case 400: {
                        em = this.rb.getString("chat.message.user.not.found");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.status((int)error.getCode()).entity((Object)em).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @GET
    @Path(value="/muc/manageaffiliation/{username}/")
    public Response manageAffilationRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="affiliation") String affiliation, @QueryParam(value="command") String command) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || nickname == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.manageAffiliation(room, nickname, affiliation, command);
                return Response.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 403: {
                        em = this.rb.getString("chat.message.forbidden.error");
                        break;
                    }
                    case 400: {
                        em = this.rb.getString("chat.message.user.not.found");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.status((int)error.getCode()).entity((Object)em).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.status((int)404).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @GET
    @Path(value="/muc/kick/{username}/")
    public Response kickUserFromRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="reason") String reason) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || nickname == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.kickUser(room, nickname, reason);
                return Response.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 405: {
                        em = this.rb.getString("chat.message.not.allowed.error");
                    }
                    case 403: {
                        em = this.rb.getString("chat.message.forbidden.error");
                        break;
                    }
                    case 400: {
                        em = this.rb.getString("chat.message.user.not.found");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.status((int)error.getCode()).entity((Object)em).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.status((int)404).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @GET
    @Path(value="/muc/ban/{username}/")
    public Response banUserFromRoom(@PathParam(value="username") String username, @QueryParam(value="room") String room, @QueryParam(value="name") String name, @QueryParam(value="reason") String reason) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (room == null || name == null) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.roomid.null")).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.banUser(room, name, reason);
                return Response.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                String em = new String();
                switch (error.getCode()) {
                    case 405: {
                        em = this.rb.getString("chat.message.not.allowed.error");
                    }
                    case 403: {
                        em = this.rb.getString("chat.message.forbidden.error");
                        break;
                    }
                    case 400: {
                        em = this.rb.getString("chat.message.user.not.found");
                        break;
                    }
                    default: {
                        em = this.rb.getString("chat.message.default.error");
                    }
                }
                return Response.status((int)error.getCode()).entity((Object)em).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.status((int)404).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).cacheControl(cc).build();
    }

    @POST
    @Path(value="/addtransport/")
    public Response addTransport(@QueryParam(value="username") String username, @QueryParam(value="remoteusername") String remoteUser, @QueryParam(value="remotepassword") String remotePassword, @QueryParam(value="transport") String transport) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String serviceName = session.getConnection().getServiceName();
                if (transport.equalsIgnoreCase("yahoo")) {
                    YahooTransport yahooTransport = new YahooTransport(serviceName);
                    session.addTransport(yahooTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("icq")) {
                    ICQTransport icqTransport = new ICQTransport(serviceName);
                    session.addTransport(icqTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("msn")) {
                    MSNTransport msnTransport = new MSNTransport(serviceName);
                    session.addTransport(msnTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("aim")) {
                    AIMTransport aimTransport = new AIMTransport(serviceName);
                    session.addTransport(aimTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("gtalk")) {
                    GtalkTransport gtalkTransport = new GtalkTransport(serviceName);
                    session.addTransport(gtalkTransport, remoteUser, remotePassword, true);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Wrong transport name!");
                }
                return Response.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
            }
            return Response.status((int)403).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/roster/add/{username}/{adduser}/")
    public Response addBoddyToRoster(@PathParam(value="username") String username, @PathParam(value="adduser") String adduser, @QueryParam(value="nickname") String nickname, @QueryParam(value="group") String group) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (nickname == null) {
                    nickname = adduser;
                }
                session.addBuddy(adduser, nickname, group);
                return Response.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
            }
            return Response.status((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
        }
    }

    @GET
    @Path(value="/roster/update/{username}/{upduser}/")
    public Response updateBoddy(@PathParam(value="username") String username, @PathParam(value="upduser") String upduser, @QueryParam(value="nickname") String nickname, @QueryParam(value="group") String group) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (nickname == null) {
                    nickname = upduser;
                }
                session.updateBuddy(upduser, nickname, group);
                return Response.ok().cacheControl(cc).build();
            }
            return Response.status((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
        }
    }

    @GET
    @Path(value="/roster/group/{username}/{group}/")
    public Response createGroup(@PathParam(value="username") String username, @PathParam(value="group") String group) {
        XMPPSessionImpl session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = (XMPPSessionImpl)this.messenger.getSession(username)) != null) {
            session.createGroup(group);
            return Response.ok().cacheControl(cc).build();
        }
        return Response.status((int)500).build();
    }

    @GET
    @Path(value="/askforsubscription/{username}/{askuser}/")
    public Response askForSubscription(@PathParam(value="username") String username, @PathParam(value="askuser") String askuser, @QueryParam(value="nickname") String nickname) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            if (session.getBuddy(askuser) == null) {
                return Response.status((int)400).entity((Object)this.rb.getString("chat.message.user.not.found")).build();
            }
            if (nickname == null) {
                nickname = askuser;
            }
            session.askForSubscription(askuser, nickname);
            return Response.ok().cacheControl(cc).build();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
        }
        return Response.status((int)500).build();
    }

    @GET
    @Path(value="/rosterclean/{username}/")
    public Response cleanBuddylist(@PathParam(value="username") String username) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.cleanBuddiesList();
                return Response.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.rb.getString("chat.message.room.xmppsession.null"));
            }
            return Response.status((int)500).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
        }
    }

    @GET
    @Path(value="/history/getmessages/{usernameto}/{isGroupChat}/")
    @Produces(value={"application/json"})
    public Response getAllHistory(@PathParam(value="usernameto") String usernameto, @PathParam(value="isGroupChat") Boolean isGroupChat, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (usernamefrom == null || usernamefrom.length() == 0) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.history.participant.name.not.set")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                list = session.getAllHistory(usernameto, usernamefrom, isGroupChat);
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (!list.isEmpty()) {
                    for (HistoricalMessage historicalMessage : list) {
                        listBean.add(TransformUtils.messageToBean(historicalMessage));
                    }
                }
                return Response.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/history/getmessages/{usernameto}/{isGroupChat}/{from}/{to}/")
    @Produces(value={"application/json"})
    public Response getHistoryBetweenDate(@PathParam(value="usernameto") String usernameto, @PathParam(value="isGroupChat") Boolean isGroupChat, @PathParam(value="from") String from, @PathParam(value="to") String to, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (usernamefrom == null || usernamefrom.length() == 0) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.history.participant.name.not.set")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                Date dateFrom = new Date(Long.parseLong(from));
                Date dateTo = new Date(Long.parseLong(to));
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (dateFrom.before(dateTo)) {
                    list = session.getHistoryBetweenDate(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo);
                    if (!list.isEmpty()) {
                        for (HistoricalMessage historicalMessage : list) {
                            listBean.add(TransformUtils.messageToBean(historicalMessage));
                        }
                    }
                    return Response.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.status((int)409).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/history/getmessages/{usernameto}/{isGroupChat}/{from}/")
    @Produces(value={"application/json"})
    public Response getHistoryFromDateToNow(@PathParam(value="usernameto") String usernameto, @PathParam(value="isGroupChat") Boolean isGroupChat, @PathParam(value="from") String from, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (usernamefrom == null || usernamefrom.length() == 0) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.history.participant.name.not.set")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                Date dateFrom = new Date(Long.parseLong(from));
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (dateFrom.before(Calendar.getInstance().getTime())) {
                    list = session.getHistoryFromDateToNow(usernameto, usernamefrom, isGroupChat, dateFrom);
                    if (!list.isEmpty()) {
                        for (HistoricalMessage historicalMessage : list) {
                            listBean.add(TransformUtils.messageToBean(historicalMessage));
                        }
                    }
                    return Response.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.status((int)409).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/history/getinterlocutors/{username}/")
    @Produces(value={"application/json"})
    public Response getInterlocutors(@PathParam(value="username") String username) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                return Response.ok((Object)new InterlocutorListBean(session.getInterlocutors(username)), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/history/file/getmessages/{usernameto}/{isGroupChat}/{clientTimezoneOffset}/")
    public Response getAllHistoryFile(@PathParam(value="usernameto") String usernameto, @PathParam(value="isGroupChat") Boolean isGroupChat, @PathParam(value="clientTimezoneOffset") String clientTimezoneOffset, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if (usernamefrom == null || usernamefrom.length() == 0) {
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.history.participant.name.not.set")).build();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernamefrom);
            if (session != null) {
                List<Object> list = new ArrayList();
                list = session.getAllHistory(usernameto, usernamefrom, isGroupChat);
                Integer clientTimeZoneOffset = Integer.valueOf(clientTimezoneOffset);
                for (HistoricalMessage historicalMessage : list) {
                    Date dateSend = historicalMessage.getDateSend();
                    dateSend = TransformUtils.convertToClientTime(dateSend, clientTimeZoneOffset);
                    historicalMessage.setDateSend(dateSend);
                }
                InputStream inputStream = this.historyBeanToStream(list);
                return Response.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", (Object)("attachment; filename=" + usernameto + "-" + usernamefrom + ".txt")).cacheControl(cc).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/history/file/getmessages/{usernameto}/{isGroupChat}/{from}/{clientTimezoneOffset}/")
    public Response getHistoryFromDateToNowFile(@PathParam(value="usernameto") String usernameto, @PathParam(value="isGroupChat") Boolean isGroupChat, @PathParam(value="from") String from, @PathParam(value="clientTimezoneOffset") String clientTimezoneOffset, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernamefrom);
            if (session != null) {
                List<Object> list = new ArrayList();
                Integer clientTimeZoneOffset = Integer.valueOf(clientTimezoneOffset);
                Date dateFrom = new Date(Long.valueOf(from));
                if (dateFrom.before(Calendar.getInstance().getTime())) {
                    list = session.getHistoryFromDateToNow(usernameto, usernamefrom, isGroupChat, dateFrom);
                    for (HistoricalMessage historicalMessage : list) {
                        Date dateSend = historicalMessage.getDateSend();
                        dateSend = TransformUtils.convertToClientTime(dateSend, clientTimeZoneOffset);
                        historicalMessage.setDateSend(dateSend);
                    }
                    InputStream inputStream = this.historyBeanToStream(list);
                    CacheControl cacheControl = new CacheControl();
                    return Response.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", (Object)("attachment; filename=" + usernameto + "-" + usernamefrom + "(" + from + ").txt")).header("Expires", (Object)"Sun, 17 Dec 1989 07:30:00 GMT").cacheControl(cacheControl).build();
                }
                return Response.status((int)409).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/history/file/getmessages/{usernameto}/{isGroupChat}/{from}/{to}/{clientTimezoneOffset}/")
    public Response getHistoryBetweenDateFile(@PathParam(value="usernameto") String usernameto, @PathParam(value="isGroupChat") Boolean isGroupChat, @PathParam(value="from") String from, @PathParam(value="to") String to, @PathParam(value="clientTimezoneOffset") String clientTimezoneOffset, @QueryParam(value="usernamefrom") String usernamefrom) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(usernamefrom);
            if (session != null) {
                Date dateTo;
                List<Object> list = new ArrayList();
                Integer clientTimeZoneOffset = Integer.valueOf(clientTimezoneOffset);
                Date dateFrom = new Date(Long.valueOf(from));
                if (dateFrom.before(dateTo = new Date(Long.valueOf(to)))) {
                    list = session.getHistoryBetweenDate(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo);
                    for (HistoricalMessage historicalMessage : list) {
                        Date dateSend = historicalMessage.getDateSend();
                        dateSend = TransformUtils.convertToClientTime(dateSend, clientTimeZoneOffset);
                        historicalMessage.setDateSend(dateSend);
                    }
                    InputStream inputStream = this.historyBeanToStream(list);
                    return Response.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", (Object)("attachment; filename=" + usernameto + "-" + usernamefrom + "(" + from + "-" + to + ").txt")).cacheControl(cc).build();
                }
                return Response.status((int)409).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)500).build();
        }
    }

    private InputStream historyBeanToStream(List<HistoricalMessage> history) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (!history.isEmpty()) {
                for (HistoricalMessage historicalMessage : history) {
                    String buffer = new String();
                    buffer = buffer.concat(StringUtils.parseBareAddress((String)historicalMessage.getFrom()) + "(" + historicalMessage.getDateSend().toString() + ") : " + historicalMessage.getBody() + "\n");
                    outputStream.write(buffer.getBytes());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }

    @GET
    @Path(value="/getsearchform/{username}/")
    @Produces(value={"application/json"})
    public Response getSearchUsersForm(@PathParam(value="username") String username, @QueryParam(value="searchservice") String searchService) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                Form form = session.getSearchForm(searchService);
                return Response.ok((Object)TransformUtils.formToFormBean(form), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.status((int)403).cacheControl(cc).entity((Object)this.rb.getString("chat.message.xmppsession.null")).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
        }
    }

    @GET
    @Path(value="/getuserinfo/{username}/{needinfo}/")
    @Produces(value={"application/json"})
    public Response getUserInfo(@PathParam(value="username") String username, @PathParam(value="needinfo") String needinfo) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                return Response.ok((Object)session.getUserInfo(needinfo), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)400).entity((Object)this.rb.getString("chat.message.default.error")).build();
        }
    }

    @GET
    @Path(value="/login2/{forcache}/")
    @Produces(value={"application/json"})
    public Response login2(@PathParam(value="forcache") String forcache) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            ConversationState curentState = ConversationState.getCurrent();
            String username = curentState.getIdentity().getUserId();
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)("Userid for login : " + username));
            }
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            UserInfoService organization = (UserInfoService)container.getComponentInstanceOfType(UserInfoService.class);
            String password = organization.providePassword(username);
            this.messenger.login(username, password, organization, this.delegate, this.history, this.rb);
            XMPPSession session = this.messenger.getSession(username);
            XMPPConnection connection = session.getConnection();
            String mainServiceName = session.getConnection().getServiceName();
            List<String> services = session.getSearchServices();
            Form form = session.getSearchForm(services.get(0));
            Roster buddyList = session.getConnection().getRoster();
            Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
            String mucService = collectionMUCService.toArray()[0].toString();
            Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
            ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
            for (HostedRoom hostedRoom : hostedRooms) {
                HostedRoomBean roomBean = new HostedRoomBean();
                roomBean.setJid(hostedRoom.getJid());
                roomBean.setName(hostedRoom.getName());
                rooms.add(roomBean);
            }
            InitInfoBean initInfoBean = new InitInfoBean();
            initInfoBean.setForm(TransformUtils.formToFormBean(form));
            initInfoBean.setMainServiceName(mainServiceName);
            initInfoBean.setMucServicesNames(collectionMUCService);
            initInfoBean.setRoster(TransformUtils.rosterToRosterBean(buddyList));
            try {
                ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                for (ContactBean b : initInfoBean.getRoster()) {
                    UserInfo info = session.getUserInfo(b.getUser().split("@")[0]);
                    b.setFullName(info.getFirstName() + " " + info.getLastName());
                    list.add(b);
                }
                initInfoBean.setRoster(list);
            }
            catch (Exception e) {
                // empty catch block
            }
            ContactBean myProfile = new ContactBean();
            myProfile.setUser(username);
            UserInfo myInfo = organization.getUserInfo(username);
            myProfile.setFullName(myInfo.getFirstName() + " " + myInfo.getLastName());
            initInfoBean.setMyProfile(myProfile);
            session.addFullUserNames(username, myProfile.getFullName());
            initInfoBean.setSearchServicesNames(services);
            initInfoBean.setHostedRooms(rooms);
            initInfoBean.setTotalRooms(rooms.size());
            return Response.ok((Object)initInfoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).header("Set-Cookie", (Object)("userTicket=" + UUID.randomUUID().toString())).build();
        }
        catch (XMPPException e) {
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)error.getMessage()).build();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/logout/{username}/{presencestatus}/")
    public Response logout(@PathParam(value="username") String _username, @PathParam(value="presencestatus") String _presencestatus) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            ExoContainer container;
            XMPPSession session = this.messenger.getSession(_username);
            if (session != null) {
                container = ExoContainerContext.getCurrentContainer();
                DefaultPresenceStatus dps = (DefaultPresenceStatus)container.getComponentInstance(DefaultPresenceStatus.class);
                session.setPresenceStatus_(_presencestatus);
                if (dps != null) {
                    dps.savePresenceStatus(_username, _presencestatus);
                } else {
                    this.log.debug((Object)"Logout: Can not save presence status from logout() service");
                }
                session.removeAllTransport();
            }
            container = Response.ok().cacheControl(cc).build();
            return container;
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            Response response = Response.status((int)error.getCode()).entity((Object)error.getMessage()).build();
            return response;
        }
        finally {
            this.messenger.logout(_username);
        }
    }

    @GET
    @Path(value="/history/messagereceive/{username}/{messageid}/")
    public Response messageReceive(@PathParam(value="username") String username, @PathParam(value="messageid") String messageId) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.messageReceive(messageId);
                return Response.ok().cacheControl(cc).build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/roster/del/{username}/{removeboddy}/")
    public Response removeBuddy(@PathParam(value="username") String username, @PathParam(value="removeboddy") String removeboddy) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                if (session.removeBuddy(removeboddy)) {
                    return Response.ok().cacheControl(cc).build();
                }
                return Response.status((int)404).entity((Object)this.rb.getString("chat.message.user.not.found")).build();
            }
            return Response.status((int)403).entity((Object)this.rb.getString("chat.message.xmppsession.null")).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
        }
    }

    @GET
    @Path(value="/removetransport/{username}/{transport}/")
    public Response removeTransport(@PathParam(value="username") String username, @PathParam(value="transport") String _transport) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String serviceName = session.getConnection().getServiceName();
                if (_transport.equalsIgnoreCase("yahoo")) {
                    YahooTransport yahooTransport = new YahooTransport(serviceName);
                    session.removeTransport(yahooTransport);
                } else if (_transport.equalsIgnoreCase("icq")) {
                    ICQTransport icqTransport = new ICQTransport(serviceName);
                    session.removeTransport(icqTransport);
                } else if (_transport.equalsIgnoreCase("msn")) {
                    MSNTransport msnTransport = new MSNTransport(serviceName);
                    session.removeTransport(msnTransport);
                } else if (_transport.equalsIgnoreCase("aim")) {
                    AIMTransport aimTransport = new AIMTransport(serviceName);
                    session.removeTransport(aimTransport);
                } else if (_transport.equalsIgnoreCase("gtalk")) {
                    GtalkTransport gtalkTransport = new GtalkTransport(serviceName);
                    session.removeTransport(gtalkTransport);
                }
                return Response.ok().cacheControl(cc).build();
            }
            return Response.status((int)403).entity((Object)"sesion is null").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)error.getMessage()).build();
        }
    }

    @GET
    @Path(value="/searchuser/{username}/")
    @Produces(value={"application/json"})
    public Response searchUsers(@PathParam(value="username") String username, @QueryParam(value="search") String search, @QueryParam(value="username") Boolean byUsername, @QueryParam(value="name") Boolean byName, @QueryParam(value="email") Boolean byEmail, @QueryParam(value="searchservice") String searchService) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSession session;
            if (byUsername == null) {
                byUsername = new Boolean(false);
            }
            if (byName == null) {
                byName = new Boolean(false);
            }
            if (byEmail == null) {
                byEmail = new Boolean(false);
            }
            if ((session = this.messenger.getSession(username)) != null) {
                ReportedData reportedData = session.searchUser(search, byUsername, byName, byEmail, searchService);
                return Response.ok((Object)TransformUtils.reportedSateToSearchResultsBean(reportedData), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.status((int)403).entity((Object)"session null").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
        }
    }

    @POST
    @Path(value="/sendmessage/{username}/")
    @Consumes(value={"application/json"})
    public Response sendMessage(@PathParam(value="username") String username, MessageBean messageBean) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            String from = session.getUsername().split("/")[0];
            Message message = new Message(messageBean.getTo(), Message.Type.chat);
            message.setFrom(from);
            message.setBody(messageBean.getBody());
            session.sendMessage(message);
            return Response.ok().cacheControl(cc).build();
        }
        return Response.status((int)400).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @POST
    @Path(value="/muc/sendmessage/{username}/")
    @Consumes(value={"application/json"})
    public Response sendMUCMessage(@PathParam(value="username") String username, MessageBean messageBean) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            String room = messageBean.getTo();
            String body = messageBean.getBody();
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.sendMessageToMUC(room, body);
                return Response.ok().cacheControl(cc).build();
            }
            return Response.status((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.status((int)error.getCode()).entity((Object)this.rb.getString("chat.message.default.error")).build();
        }
    }

    @GET
    @Path(value="/sendstatus/{username}/{status}/")
    public Response setUserStatus(@PathParam(value="username") String username, @PathParam(value="status") String status) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            Presence presence = PresenceUtil.getPresence(status);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            DefaultPresenceStatus dps = (DefaultPresenceStatus)container.getComponentInstance(DefaultPresenceStatus.class);
            session.setPresenceStatus_(status);
            if (dps != null) {
                dps.savePresenceStatus(username, status);
            } else {
                this.log.debug((Object)"Can not save presence status from service sendstatus() method");
            }
            if (presence == null) {
                return Response.status((int)403).entity((Object)"Get unknow status.").build();
            }
            session.sendPresence(presence);
            return Response.ok().cacheControl(cc).build();
        }
        this.log.error((Object)"Can not set status. Cause by session closed.");
        return Response.status((int)500).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/subscribeuser/{username}/{subsuser}/")
    public Response subscribeUser(@PathParam(value="username") String _username, @PathParam(value="subsuser") String _subsuser) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(_username)) != null) {
            session.subscribeUser(_subsuser);
            return Response.ok().cacheControl(cc).build();
        }
        return Response.status((int)500).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/unsubscribeuser/{username}/{unsubsuser}/")
    public Response unsubscribeUser(@PathParam(value="username") String username, @PathParam(value="unsubsuser") String unsubsuser) {
        XMPPSession session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            session.unsubscribeUser(unsubsuser);
            return Response.ok().cacheControl(cc).build();
        }
        return Response.status((int)500).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/fileexchange/accept/{username}/{uuid}/")
    public Response acceptFile(@PathParam(value="username") String username, @PathParam(value="uuid") String uuid) {
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        try {
            XMPPSessionImpl session = (XMPPSessionImpl)this.messenger.getSession(username);
            if (session != null) {
                FileTransferRequest request = session.getFileTransferRequest(uuid);
                String sender = request.getRequestor();
                Presence presence = session.getConnection().getRoster().getPresence(sender);
                if (presence.getType().equals((Object)Presence.Type.available)) {
                    IncomingFileTransfer fileTransfer = request.accept();
                    CacheControl ccIEfixed = new CacheControl();
                    return Response.ok((Object)fileTransfer.recieveFile(), (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", (Object)("attachment; filename=\"" + fileTransfer.getFileName() + "\"")).header("Expires", (Object)"Sun, 17 Dec 1989 07:30:00 GMT").cacheControl(ccIEfixed).build();
                }
                String errorMessage = this.rb.getString("chat.message.filetransfer.sender.accept.offline");
                session.sendErrorMessage(errorMessage.trim(), sender);
                return Response.status((int)404).entity((Object)this.rb.getString("chat.message.filetransfer.sender.accept.offline")).build();
            }
            return Response.status((int)500).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/fileexchange/reject/{username}/{uuid}/")
    public Response rejectFile(@PathParam(value="username") String username, @PathParam(value="uuid") String uuid) {
        XMPPSessionImpl session;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = (XMPPSessionImpl)this.messenger.getSession(username)) != null) {
            FileTransferRequest request = session.getFileTransferRequest(uuid);
            String sender = request.getRequestor();
            Presence presence = session.getConnection().getRoster().getPresence(sender);
            if (presence.getType().equals((Object)Presence.Type.available)) {
                request.reject();
                return Response.ok().cacheControl(cc).build();
            }
            String errorMessage = this.rb.getString("chat.message.filetransfer.sender.reject.offline");
            session.sendErrorMessage(errorMessage.trim(), sender);
            return Response.status((int)404).entity((Object)this.rb.getString("chat.message.filetransfer.sender.reject.offline")).build();
        }
        return Response.status((int)500).entity((Object)this.rb.getString("chat.message.room.xmppsession.null")).build();
    }

    @GET
    @Path(value="/getprevstatus/{username}/")
    public Response getPreviousStatus(@PathParam(value="username") String username) {
        XMPPSession session;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DefaultPresenceStatus dps = null;
        if (this.rb == null) {
            this.loadResourceBundle();
        }
        if ((session = this.messenger.getSession(username)) != null) {
            if (container != null) {
                dps = (DefaultPresenceStatus)container.getComponentInstance(DefaultPresenceStatus.class);
            }
            if (dps != null) {
                String ps = dps.getPreviousStatus(username);
                return Response.ok((Object)ps, (String)"text/plain").build();
            }
        }
        return Response.ok((Object)"server_is_not_available", (String)"text/plain").build();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

