/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagStyleAddAction;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagStyleForm;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagStyleList;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditStyleActionListener.class}), @EventConfig(listeners={AddStyleActionListener.class}), @EventConfig(listeners={RemoveStyleActionListener.class}, confirm="UIFolksonomyManager.msg.confirm-delete")})
public class UITagManager
extends UIContainer {
    public UITagManager() throws Exception {
        this.addChild(UITagStyleList.class, null, null);
        this.addChild(UITagStyleAddAction.class, null, null);
    }

    public void refresh() throws Exception {
        this.update();
    }

    public void update() throws Exception {
        ((UITagStyleList)this.getChild(UITagStyleList.class)).updateGrid();
    }

    public void initTaggingFormPopup(Node selectedTagStyle) throws Exception {
        this.removeChildById("FolksonomyPopup");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "FolksonomyPopup");
        uiPopup.setWindowSize(600, 500);
        UITagStyleForm uiForm = (UITagStyleForm)this.createUIComponent(UITagStyleForm.class, null, null);
        uiForm.setTagStyle(selectedTagStyle);
        uiPopup.setUIComponent((UIComponent)uiForm);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public Node getSelectedTagStyle(String tagStyleName) throws Exception {
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        String workspace = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getDMSSystemWorkspace(repository);
        for (Node tagStyle : newFolksonomyService.getAllTagStyle(repository, workspace)) {
            if (!tagStyle.getName().equals(tagStyleName)) continue;
            return tagStyle;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddStyleActionListener
    extends EventListener<UITagManager> {
        public void execute(Event<UITagManager> event) throws Exception {
            UITagManager uiManager = (UITagManager)((Object)event.getSource());
            String selectedName = event.getRequestContext().getRequestParameter("objectId");
            uiManager.initTaggingFormPopup(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveStyleActionListener
    extends EventListener<UITagManager> {
        public void execute(Event<UITagManager> event) throws Exception {
            UITagManager uiManager = (UITagManager)((Object)event.getSource());
            String selectedName = event.getRequestContext().getRequestParameter("objectId");
            Node selectedTagStyle = uiManager.getSelectedTagStyle(selectedName);
            Node parentNode = selectedTagStyle.getParent();
            selectedTagStyle.remove();
            parentNode.getSession().save();
            ((UITagStyleList)uiManager.getChild(UITagStyleList.class)).updateGrid();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditStyleActionListener
    extends EventListener<UITagManager> {
        public void execute(Event<UITagManager> event) throws Exception {
            UITagManager uiManager = (UITagManager)((Object)event.getSource());
            String selectedName = event.getRequestContext().getRequestParameter("objectId");
            Node selectedTagStyle = uiManager.getSelectedTagStyle(selectedName);
            uiManager.initTaggingFormPopup(selectedTagStyle);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

