/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.common.jcr.LockManager;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.IdentityProviderPlugin;
import org.exoplatform.social.core.identity.model.GlobalId;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileLifeCycle;
import org.exoplatform.social.core.profile.ProfileListener;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.IdentityStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityManager {
    private static final Log LOG = ExoLogger.getExoLogger(IdentityManager.class);
    private static final long SEARCH_LIMIT = 500L;
    private final Map<String, IdentityProvider<?>> identityProviders = new HashMap();
    private IdentityStorage identityStorage;
    private RelationshipManager relationshipManager;
    private final LockManager lockManager;
    private final ExoCache<String, Identity> identityCacheById;
    private final ExoCache<GlobalId, Identity> identityCache;
    private final ExoCache<String, List<Identity>> identityListCache;
    private final ProfileLifeCycle profileLifeCycle = new ProfileLifeCycle();

    public IdentityManager(IdentityStorage identityStorage, IdentityProvider<?> defaultIdentityProvider, CacheService cacheService, LockManager lockManager) {
        this.identityStorage = identityStorage;
        this.addIdentityProvider(defaultIdentityProvider);
        this.identityCacheById = cacheService.getCacheInstance(this.getClass().getName() + "identityCacheById");
        this.identityCache = cacheService.getCacheInstance(this.getClass().getName() + "identityCache");
        this.identityListCache = cacheService.getCacheInstance(this.getClass().getName() + "identityListCache");
        this.lockManager = lockManager;
    }

    public void registerIdentityProviders(IdentityProviderPlugin plugin) {
        List<IdentityProvider<?>> pluginProviders = plugin.getProviders();
        if (pluginProviders != null) {
            for (IdentityProvider<?> identityProvider : pluginProviders) {
                this.addIdentityProvider(identityProvider);
            }
        }
    }

    public Identity getIdentity(String id) {
        return this.getIdentity(id, true);
    }

    public Identity getIdentity(String id, boolean loadProfile) {
        Identity cachedIdentity = null;
        if (GlobalId.isValid(id)) {
            GlobalId globalId = new GlobalId(id);
            String providerId = globalId.getDomain();
            String remoteId = globalId.getLocalId();
            cachedIdentity = (Identity)this.identityCache.get((Serializable)globalId);
            if (cachedIdentity == null) {
                String tempId;
                cachedIdentity = this.getOrCreateIdentity(providerId, remoteId, loadProfile);
                if (cachedIdentity != null) {
                    this.identityCache.put((Serializable)globalId, (Object)cachedIdentity);
                    return cachedIdentity;
                }
                if (cachedIdentity == null && (cachedIdentity = this.identityStorage.findIdentityById(tempId = globalId.getLocalId())) != null) {
                    id = tempId;
                }
            }
        } else {
            cachedIdentity = (Identity)this.identityCacheById.get((Serializable)((Object)id));
            if (cachedIdentity == null) {
                cachedIdentity = this.identityStorage.findIdentityById(id);
            }
        }
        if (cachedIdentity != null) {
            if (loadProfile) {
                this.identityStorage.loadProfile(cachedIdentity.getProfile());
                if (cachedIdentity.getProfile().getFullName().isEmpty()) {
                    this.updateProfileIfNeeded(cachedIdentity);
                }
            }
            this.identityCacheById.put((Serializable)((Object)id), (Object)cachedIdentity);
        }
        if (cachedIdentity == null) {
            LOG.info((Object)("Can not get identity with id: " + id));
        }
        return cachedIdentity;
    }

    public void deleteIdentity(Identity identity) {
        if (identity.getId() == null) {
            LOG.warn((Object)("identity.getId() must not be null of [" + identity + "]"));
            return;
        }
        this.identityStorage.deleteIdentity(identity);
        this.identityCacheById.remove((Serializable)((Object)identity.getId()));
        this.identityCache.remove((Serializable)identity.getGlobalId());
        this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
    }

    public void addIdentityProvider(IdentityProvider<?> idProvider) {
        if (idProvider != null) {
            LOG.debug((Object)("Registering identity provider for " + idProvider.getName() + ": " + idProvider));
            this.identityProviders.put(idProvider.getName(), idProvider);
        }
    }

    public long getIdentitiesCount(String providerId) {
        return this.identityStorage.getIdentitiesCount(providerId);
    }

    public Identity getOrCreateIdentity(String providerId, String remoteId) {
        return this.getOrCreateIdentity(providerId, remoteId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Identity getOrCreateIdentity(String providerId, String remoteId, boolean forceLoadProfile) {
        GlobalId globalIdCacheKey = GlobalId.create(providerId, remoteId);
        Identity cachedIdentity = (Identity)this.identityCache.get((Serializable)globalIdCacheKey);
        if (cachedIdentity != null) {
            if (!forceLoadProfile) return cachedIdentity;
            this.identityStorage.loadProfile(cachedIdentity.getProfile());
            if (!cachedIdentity.getProfile().getFullName().isEmpty()) return cachedIdentity;
            this.updateProfileIfNeeded(cachedIdentity);
            return cachedIdentity;
        }
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        Lock lock = this.lockManager.getLock("Identity", remoteId);
        lock.lock();
        try {
            cachedIdentity = (Identity)this.identityCache.get((Serializable)globalIdCacheKey);
            if (cachedIdentity != null) {
                Identity identity = cachedIdentity;
                return identity;
            }
            Identity identity1 = identityProvider.getIdentityByRemoteId(remoteId);
            Identity result = this.identityStorage.findIdentity(providerId, remoteId);
            if (result == null) {
                if (identity1 == null) {
                    Identity identity = result;
                    return identity;
                }
                this.saveIdentity(identity1);
                this.identityStorage.saveProfile(identity1.getProfile());
                result = identity1;
            } else {
                if (identity1 == null) {
                    LOG.info((Object)("Identity: " + result.getRemoteId() + " does not exist in remote provider." + " Deleting all its relationships and this identity now."));
                    this.relationshipManager = this.getRelationshipManager();
                    try {
                        List<Relationship> allRelationships = this.relationshipManager.getAllRelationships(result);
                        ArrayList<Relationship> copiedAllRelationship = new ArrayList<Relationship>(allRelationships);
                        Collections.copy(copiedAllRelationship, allRelationships);
                        for (Relationship relationship : copiedAllRelationship) {
                            this.relationshipManager.remove(relationship);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to deleted all relationships of :" + result.getRemoteId()), (Throwable)e);
                    }
                    this.identityStorage.deleteIdentity(result);
                    Identity identity = null;
                    return identity;
                }
                if (forceLoadProfile) {
                    this.identityStorage.loadProfile(result.getProfile());
                    if (result.getProfile().getFullName().isEmpty()) {
                        this.updateProfileIfNeeded(result);
                    }
                }
            }
            cachedIdentity = result;
            if (cachedIdentity.getId() == null) return cachedIdentity;
            this.identityCache.put((Serializable)globalIdCacheKey, (Object)cachedIdentity);
            return cachedIdentity;
        }
        finally {
            lock.unlock();
        }
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter) throws Exception {
        return this.identityStorage.getIdentitiesByProfileFilter(providerId, profileFilter, 0L, 500L);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.identityStorage.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit);
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter) throws Exception {
        return this.getIdentitiesByProfileFilter(null, profileFilter, 0L, 500L);
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.getIdentitiesByProfileFilter(null, profileFilter, offset, limit);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter) throws Exception {
        return this.identityStorage.getIdentitiesFilterByAlphaBet(providerId, profileFilter, 0L, 500L);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.identityStorage.getIdentitiesFilterByAlphaBet(providerId, profileFilter, offset, limit);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(ProfileFilter profileFilter) throws Exception {
        return this.getIdentitiesFilterByAlphaBet(null, profileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity getIdentity(String providerId, String remoteId, boolean loadProfile) {
        GlobalId globalIdCacheKey = GlobalId.create(providerId, remoteId);
        Identity cachedIdentity = (Identity)this.identityCache.get((Serializable)globalIdCacheKey);
        if (cachedIdentity == null) {
            IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
            Lock lock = this.lockManager.getLock("Identity", remoteId);
            lock.lock();
            try {
                cachedIdentity = (Identity)this.identityCache.get((Serializable)globalIdCacheKey);
                if (cachedIdentity != null) {
                    Identity identity = cachedIdentity;
                    return identity;
                }
                cachedIdentity = identityProvider.getIdentityByRemoteId(remoteId);
                if (cachedIdentity != null) {
                    Identity storedIdentity = this.identityStorage.findIdentity(providerId, remoteId);
                    if (storedIdentity != null) {
                        cachedIdentity.setId(storedIdentity.getId());
                        if (loadProfile) {
                            this.identityStorage.loadProfile(cachedIdentity.getProfile());
                            if (cachedIdentity.getProfile().getFullName().isEmpty()) {
                                this.updateProfileIfNeeded(cachedIdentity);
                            }
                        }
                    } else {
                        this.identityStorage.saveIdentity(cachedIdentity);
                    }
                }
                this.identityCache.put((Serializable)globalIdCacheKey, (Object)cachedIdentity);
            }
            finally {
                lock.unlock();
            }
        }
        return cachedIdentity;
    }

    public boolean identityExisted(String providerId, String remoteId) {
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        return identityProvider.getIdentityByRemoteId(remoteId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIdentity(Identity identity) {
        Lock lock = this.lockManager.getLock("Identity", identity.getRemoteId());
        lock.lock();
        try {
            this.identityStorage.saveIdentity(identity);
            this.getIdentityProvider(identity.getProviderId()).onSaveIdentity(identity);
            if (identity.getId() != null) {
                this.identityCacheById.remove((Serializable)((Object)identity.getId()));
                this.identityCache.remove((Serializable)identity.getGlobalId());
            }
            this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
        }
        finally {
            lock.unlock();
        }
    }

    public void saveProfile(Profile profile) {
        this.identityStorage.saveProfile(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
        this.removeCacheForProfileChange(profile);
    }

    private void addOrModifyProfileProperties(Profile profile) throws Exception {
        this.identityStorage.addOrModifyProfileProperties(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
        this.removeCacheForProfileChange(profile);
    }

    private Identity getCachedProfile(Identity identity) {
        Identity cachedIdentity;
        if (identity == null) {
            return null;
        }
        String identityId = identity.getId();
        if (identityId != null && (cachedIdentity = (Identity)this.identityCacheById.get((Serializable)((Object)identityId))) != null) {
            return cachedIdentity;
        }
        GlobalId globalId = identity.getGlobalId();
        if (globalId != null && (cachedIdentity = (Identity)this.identityCache.get((Serializable)globalId)) != null) {
            return cachedIdentity;
        }
        String providerId = identity.getProviderId();
        List listIdentity = (List)this.identityListCache.get((Serializable)((Object)providerId));
        if (listIdentity != null) {
            for (Identity identityFromCache : listIdentity) {
                if (!identityFromCache.equals(identity)) continue;
                return identityFromCache;
            }
        }
        return null;
    }

    public void updateAvatar(Profile p) throws Exception {
        this.saveProfile(p);
        this.profileLifeCycle.avatarUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update avatar successfully for user: " + p));
    }

    public void updateBasicInfo(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.basicUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update basic infomation successfully for user: " + p));
    }

    public void updateContactSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.contactUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update contact section successfully for user: " + p));
    }

    public void updateExperienceSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.experienceUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update experience section successfully for user: " + p));
    }

    public void updateHeaderSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.headerUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update header section successfully for user: " + p));
    }

    public List<Identity> getIdentities(String providerId) throws Exception {
        return this.getIdentities(providerId, true);
    }

    public List<Identity> getIdentities(String providerId, boolean loadProfile) {
        IdentityProvider<?> ip = this.getIdentityProvider(providerId);
        List<String> userids = ip.getAllUserId();
        ArrayList<Identity> ids = new ArrayList<Identity>();
        for (String userId : userids) {
            ids.add(this.getOrCreateIdentity(providerId, userId, loadProfile));
        }
        return ids;
    }

    public List<Identity> getConnections(Identity ownerIdentity) throws Exception {
        this.relationshipManager = this.getRelationshipManager();
        return this.relationshipManager.findRelationships(ownerIdentity, Relationship.Type.CONFIRM);
    }

    public IdentityStorage getStorage() {
        return this.identityStorage;
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    private void updateProfileIfNeeded(Identity identity) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        String userName = identity.getRemoteId();
        Profile profile = identity.getProfile();
        if (profile.getId() == null) {
            return;
        }
        try {
            OrganizationService service = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            User user = service.getUserHandler().findUserByName(userName);
            boolean hasChanged = false;
            if (!user.getFirstName().equals((String)profile.getProperty("firstName"))) {
                profile.setProperty("firstName", user.getFirstName());
                hasChanged = true;
            }
            if (!user.getLastName().equals((String)profile.getProperty("lastName"))) {
                profile.setProperty("lastName", user.getLastName());
                hasChanged = true;
            }
            if (!user.getEmail().equals((String)profile.getProperty("lastName"))) {
                profile.setProperty("lastName", user.getLastName());
                hasChanged = true;
            }
            if (hasChanged) {
                this.saveProfile(profile);
                identity.setProfile(profile);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Problems in reseting profile information", (Throwable)e);
        }
    }

    private IdentityProvider<?> getIdentityProvider(String providerId) {
        IdentityProvider<?> provider = this.identityProviders.get(providerId);
        if (provider == null) {
            throw new RuntimeException("No suitable identity provider exists for " + providerId);
        }
        return provider;
    }

    public void registerProfileListener(ProfileListener listener) {
        this.profileLifeCycle.addListener(listener);
    }

    public void unregisterProfileListener(ProfileListener listener) {
        this.profileLifeCycle.removeListener(listener);
    }

    public void addProfileListener(ProfileListenerPlugin plugin) {
        this.registerProfileListener(plugin);
    }

    public IdentityStorage getIdentityStorage() {
        return this.identityStorage;
    }

    private void removeCacheForProfileChange(Profile profile) {
        Identity identity = profile.getIdentity();
        this.identityCacheById.remove((Serializable)((Object)identity.getId()));
        this.identityCache.remove((Serializable)profile.getIdentity().getGlobalId());
        this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = (RelationshipManager)PortalContainer.getInstance().getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }
}

