/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr.info;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.chromattic.core.jcr.info.PropertyDefinitionInfo;

public class NodeTypeInfo {
    private final String name;
    private final Map<String, PropertyDefinitionInfo> propertyDefinitions;

    public NodeTypeInfo(NodeType nodeType) {
        HashMap<String, PropertyDefinitionInfo> propertyDefinitions = new HashMap<String, PropertyDefinitionInfo>();
        for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions()) {
            PropertyDefinitionInfo propertyDefinitionInfo = new PropertyDefinitionInfo(propertyDefinition);
            propertyDefinitions.put(propertyDefinitionInfo.getName(), propertyDefinitionInfo);
        }
        this.name = nodeType.getName();
        this.propertyDefinitions = propertyDefinitions;
    }

    public String getName() {
        return this.name;
    }

    public PropertyDefinitionInfo getPropertyDefinitionInfo(String name) {
        return this.propertyDefinitions.get(name);
    }

    public PropertyDefinitionInfo findPropertyDefinition(String propertyName) {
        PropertyDefinitionInfo propertyDefinitionInfo = this.getPropertyDefinitionInfo(propertyName);
        if (propertyDefinitionInfo == null) {
            return this.getPropertyDefinitionInfo("*");
        }
        return propertyDefinitionInfo;
    }
}

