/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.deployment.plugins;

import java.io.InputStream;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.deployment.DeploymentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class XMLDeploymentPlugin
extends DeploymentPlugin {
    private InitParams initParams;
    private ConfigurationManager configurationManager;
    private RepositoryService repositoryService;
    private Log log = ExoLogger.getLogger(this.getClass());

    public XMLDeploymentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService) {
        this.initParams = initParams;
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
    }

    public void deploy(SessionProvider sessionProvider) throws Exception {
        Iterator iterator = this.initParams.getObjectParamIterator();
        while (iterator.hasNext()) {
            ObjectParameter objectParameter = (ObjectParameter)iterator.next();
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)objectParameter.getObject();
            String sourcePath = deploymentDescriptor.getSourcePath();
            Boolean cleanupPublication = deploymentDescriptor.getCleanupPublication();
            InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
            ManageableRepository repository = this.repositoryService.getRepository(deploymentDescriptor.getTarget().getRepository());
            Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
            session.importXML(deploymentDescriptor.getTarget().getNodePath(), inputStream, 0);
            if (cleanupPublication.booleanValue()) {
                QueryManager manager = session.getWorkspace().getQueryManager();
                String statement = "select * from nt:base where jcr:path LIKE '" + deploymentDescriptor.getTarget().getNodePath() + "/%'";
                Query query = manager.createQuery(statement.toString(), "sql");
                NodeIterator iter = query.execute().getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.hasProperty("publication:liveRevision") || !node.hasProperty("publication:currentState")) continue;
                    this.log.info((Object)("\"" + node.getName() + "\" publication lifecycle has been cleaned up"));
                    node.setProperty("publication:liveRevision", "");
                    node.setProperty("publication:currentState", "published");
                }
            }
            session.save();
            session.logout();
            if (!this.log.isInfoEnabled()) continue;
            this.log.info((Object)(deploymentDescriptor.getSourcePath() + " is deployed succesfully into " + deploymentDescriptor.getTarget().getNodePath()));
        }
    }
}

