/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.scheduler.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.CronJob;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.services.scheduler.PeriodJob;
import org.exoplatform.services.scheduler.QueueTasks;
import org.exoplatform.services.scheduler.Task;
import org.exoplatform.services.scheduler.impl.JobEnvironmentConfigListener;
import org.exoplatform.services.scheduler.impl.QuartzSheduler;
import org.picocontainer.Startable;
import org.quartz.CronTrigger;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class JobSchedulerServiceImpl
implements JobSchedulerService,
Startable {
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.component.common.JobSchedulerServiceImpl");
    static final String STANDALONE_CONTAINER_NAME = "$Standalone";
    private final Scheduler scheduler_;
    private final String containerName_;
    private final QueueTasks qtasks_;

    public JobSchedulerServiceImpl(PortalContainerInfo pinfo, QuartzSheduler quartzSchduler, QueueTasks qtasks) {
        this.scheduler_ = quartzSchduler.getQuartzSheduler();
        this.containerName_ = pinfo.getContainerName();
        this.qtasks_ = qtasks;
    }

    public JobSchedulerServiceImpl(QuartzSheduler quartzSchduler, QueueTasks qtasks) {
        this.scheduler_ = quartzSchduler.getQuartzSheduler();
        this.containerName_ = STANDALONE_CONTAINER_NAME;
        this.qtasks_ = qtasks;
    }

    public void queueTask(Task task) {
        this.qtasks_.add(task);
    }

    public void addJob(JobDetail job, Trigger trigger) throws Exception {
        this.scheduler_.scheduleJob(job, trigger);
    }

    public void addJob(JobInfo jinfo, Trigger trigger) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        JobDetail job = new JobDetail(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJob());
        this.scheduler_.scheduleJob(job, trigger);
    }

    public void addJob(JobInfo jinfo, Date date) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        SimpleTrigger trigger = new SimpleTrigger(jobinfo.getJobName(), jobinfo.getGroupName(), date);
        JobDetail job = new JobDetail(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJob());
        job.setDescription(jinfo.getDescription());
        this.scheduler_.scheduleJob(job, (Trigger)trigger);
    }

    public void addPeriodJob(JobInfo jinfo, int repeatCount, long period) throws Exception {
        int repeat = repeatCount < 0 ? SimpleTrigger.REPEAT_INDEFINITELY : (repeatCount == 0 ? SimpleTrigger.REPEAT_INDEFINITELY : repeatCount - 1);
        JobInfo jobinfo = this.getJobInfo(jinfo);
        SimpleTrigger trigger = new SimpleTrigger(jobinfo.getJobName(), jobinfo.getGroupName(), repeat, period);
        JobDetail job = new JobDetail(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJob());
        job.setDescription(jobinfo.getDescription());
        this.scheduler_.scheduleJob(job, (Trigger)trigger);
    }

    public void addPeriodJob(JobInfo jinfo, PeriodInfo pinfo) throws Exception {
        int repeat = pinfo.getRepeatCount();
        Date start = pinfo.getStartTime();
        JobInfo jobinfo = this.getJobInfo(jinfo);
        if (start == null) {
            start = new Date();
        }
        repeat = repeat <= 0 ? SimpleTrigger.REPEAT_INDEFINITELY : --repeat;
        SimpleTrigger trigger = new SimpleTrigger(jobinfo.getJobName(), jobinfo.getGroupName(), start, pinfo.getEndTime(), repeat, pinfo.getRepeatInterval());
        JobDetail job = new JobDetail(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJob());
        job.setDescription(jobinfo.getDescription());
        this.scheduler_.scheduleJob(job, (Trigger)trigger);
    }

    public void addPeriodJob(ComponentPlugin plugin) throws Exception {
        PeriodJob pjob = (PeriodJob)plugin;
        this.addPeriodJob(pjob.getJobInfo(), pjob.getPeriodInfo(), pjob.getJobDataMap());
    }

    public void addCronJob(JobInfo jinfo, String exp) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        CronTrigger trigger = new CronTrigger(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJobName(), jobinfo.getGroupName(), exp);
        JobDetail job = new JobDetail(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJob());
        job.setDescription(jobinfo.getDescription());
        this.scheduler_.addJob(job, true);
        this.scheduler_.scheduleJob((Trigger)trigger);
    }

    public void addCronJob(ComponentPlugin plugin) throws Exception {
        CronJob cjob = (CronJob)plugin;
        this.addCronJob(cjob.getJobInfo(), cjob.getExpression(), cjob.getJobDataMap());
    }

    public void addCronJob(JobInfo jinfo, String exp, JobDataMap jdatamap) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        CronTrigger trigger = new CronTrigger(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJobName(), jobinfo.getGroupName(), exp);
        JobDetail job = new JobDetail(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJob());
        job.setJobDataMap(jdatamap);
        job.setDescription(jobinfo.getDescription());
        this.scheduler_.addJob(job, true);
        this.scheduler_.scheduleJob((Trigger)trigger);
    }

    public void addPeriodJob(JobInfo jinfo, PeriodInfo pinfo, JobDataMap jdatamap) throws Exception {
        int repeat = pinfo.getRepeatCount();
        Date start = pinfo.getStartTime();
        JobInfo jobinfo = this.getJobInfo(jinfo);
        if (start == null) {
            start = new Date();
        }
        repeat = repeat <= 0 ? SimpleTrigger.REPEAT_INDEFINITELY : --repeat;
        SimpleTrigger trigger = new SimpleTrigger(jobinfo.getJobName(), jobinfo.getGroupName(), start, pinfo.getEndTime(), repeat, pinfo.getRepeatInterval());
        JobDetail job = new JobDetail(jobinfo.getJobName(), jobinfo.getGroupName(), jobinfo.getJob());
        job.setJobDataMap(jdatamap);
        job.setDescription(jobinfo.getDescription());
        this.scheduler_.scheduleJob(job, (Trigger)trigger);
    }

    public boolean removeJob(JobInfo jinfo) throws Exception {
        JobInfo jobinfo = this.getJobInfo(jinfo);
        return this.scheduler_.deleteJob(jobinfo.getJobName(), jobinfo.getGroupName());
    }

    public List getAllExcutingJobs() throws Exception {
        return this.scheduler_.getCurrentlyExecutingJobs();
    }

    public List getAllJobs() throws Exception {
        ArrayList<JobDetail> jlist = new ArrayList<JobDetail>();
        String[] jgroup = this.scheduler_.getJobGroupNames();
        for (int i = 1; i < jgroup.length; ++i) {
            String[] jname = this.scheduler_.getJobNames(jgroup[i]);
            for (int j = 0; j < jname.length; ++j) {
                jlist.add(this.scheduler_.getJobDetail(jname[j], jgroup[i]));
            }
        }
        return jlist;
    }

    public void addGlobalJobListener(ComponentPlugin plugin) throws Exception {
        this.scheduler_.addGlobalJobListener((JobListener)plugin);
    }

    public List getAllGlobalJobListener() throws Exception {
        return this.scheduler_.getGlobalJobListeners();
    }

    public JobListener getGlobalJobListener(String name) throws Exception {
        List listener = this.scheduler_.getGlobalJobListeners();
        ListIterator iterator = listener.listIterator();
        while (iterator.hasNext()) {
            JobListener jlistener = (JobListener)iterator.next();
            if (!jlistener.getName().equals(name)) continue;
            return jlistener;
        }
        return null;
    }

    public boolean removeGlobalJobListener(String name) throws Exception {
        JobListener jlistener = this.getGlobalJobListener(name);
        return this.scheduler_.removeGlobalJobListener(jlistener);
    }

    public void addJobListener(ComponentPlugin plugin) throws Exception {
        this.scheduler_.addJobListener((JobListener)plugin);
    }

    public List getAllJobListener() throws Exception {
        Set jlNames = this.scheduler_.getJobListenerNames();
        ArrayList<JobListener> jlisteners = new ArrayList<JobListener>();
        if (jlNames.isEmpty()) {
            return jlisteners;
        }
        for (Object obj : jlNames.toArray()) {
            jlisteners.add(this.getJobListener(obj.toString()));
        }
        return jlisteners;
    }

    public JobListener getJobListener(String name) throws Exception {
        return this.scheduler_.getJobListener(name);
    }

    public boolean removeJobListener(String name) throws Exception {
        return this.scheduler_.removeJobListener(name);
    }

    public void addGlobalTriggerListener(ComponentPlugin plugin) throws Exception {
        this.scheduler_.addGlobalTriggerListener((TriggerListener)plugin);
    }

    public List getAllGlobalTriggerListener() throws Exception {
        return this.scheduler_.getGlobalTriggerListeners();
    }

    public TriggerListener getGlobalTriggerListener(String name) throws Exception {
        List listener = this.scheduler_.getGlobalTriggerListeners();
        ListIterator iterator = listener.listIterator();
        while (iterator.hasNext()) {
            TriggerListener tlistener = (TriggerListener)iterator.next();
            if (!tlistener.getName().equals(name)) continue;
            return tlistener;
        }
        return null;
    }

    public boolean removeGlobaTriggerListener(String name) throws Exception {
        TriggerListener tlistener = this.getGlobalTriggerListener(name);
        return this.scheduler_.removeGlobalTriggerListener(tlistener);
    }

    public void addTriggerListener(ComponentPlugin plugin) throws Exception {
        this.scheduler_.addTriggerListener((TriggerListener)plugin);
    }

    public List getAllTriggerListener() throws Exception {
        ArrayList<TriggerListener> tlisteners = new ArrayList<TriggerListener>();
        Set tlistenerNames = this.scheduler_.getTriggerListenerNames();
        if (tlistenerNames.isEmpty()) {
            return tlisteners;
        }
        for (Object obj : tlistenerNames.toArray()) {
            tlisteners.add(this.getTriggerListener(obj.toString()));
        }
        return tlisteners;
    }

    public TriggerListener getTriggerListener(String name) throws Exception {
        return this.scheduler_.getTriggerListener(name);
    }

    public boolean removeTriggerListener(String name) throws Exception {
        return this.scheduler_.removeTriggerListener(name);
    }

    private JobInfo getJobInfo(JobInfo jinfo) throws Exception {
        String gname = jinfo.getGroupName() == null ? this.containerName_ : this.containerName_ + ":" + jinfo.getGroupName();
        JobInfo jobInfo = new JobInfo(jinfo.getJobName(), gname, jinfo.getJob());
        jobInfo.setDescription(jinfo.getDescription());
        return jobInfo;
    }

    public void pauseJob(String jobName, String groupName) throws Exception {
        this.scheduler_.pauseJob(jobName, groupName);
    }

    public void resumeJob(String jobName, String groupName) throws Exception {
        this.scheduler_.resumeJob(jobName, groupName);
    }

    public void executeJob(String jname, String jgroup, JobDataMap jdatamap) throws Exception {
        this.scheduler_.triggerJobWithVolatileTrigger(jname, jgroup, jdatamap);
    }

    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws Exception {
        return this.scheduler_.getTriggersOfJob(jobName, groupName);
    }

    public int getTriggerState(String triggerName, String triggerGroup) throws Exception {
        return this.scheduler_.getTriggerState(triggerName, triggerGroup);
    }

    public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        return this.scheduler_.rescheduleJob(triggerName, groupName, newTrigger);
    }

    public void start() {
        try {
            while (this.removeGlobalJobListener("JobContextConfigListener")) {
            }
            this.scheduler_.addGlobalJobListener((JobListener)new JobEnvironmentConfigListener());
        }
        catch (Exception e) {
            log.warn((Object)"Could not remove the GlobalJobListener JobContextConfigListener", (Throwable)e);
        }
    }

    public void stop() {
        try {
            List jobs = this.getAllExcutingJobs();
            for (Object object : jobs) {
                JobExecutionContext ctx = (JobExecutionContext)object;
                Job job = ctx.getJobInstance();
                if (!(job instanceof InterruptableJob)) continue;
                ((InterruptableJob)job).interrupt();
            }
            this.scheduler_.shutdown(true);
        }
        catch (Exception ex) {
            log.warn((Object)"Could not interrupt all the current jobs properly", (Throwable)ex);
        }
    }

    public JobDetail getJob(JobInfo jobInfo) throws Exception {
        JobInfo innerJobInfo = this.getJobInfo(jobInfo);
        return this.scheduler_.getJobDetail(innerJobInfo.getJobName(), innerJobInfo.getGroupName());
    }
}

