/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentProviderUtils {
    public static final int CURRENT_NODE_ITEMS = 0;
    public static final int FAVOURITE_ITEMS = 1;
    public static final int TRASH_ITEMS = 2;
    public static final int OWNED_BY_USER_ITEMS = 3;
    public static final int HIDDEN_ITEMS = 4;
    private static FavoriteService favoriteService_ = null;
    private static TrashService trashService_ = null;

    public List<Node> getItemsBySourceType(int source, UIJCRExplorer uiExplorer) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        switch (source) {
            case 0: {
                return this.getCurrentNodeChildren(uiExplorer);
            }
            case 1: {
                return this.getFavouriteNodeList(uiExplorer);
            }
            case 2: {
                return this.getTrashNodeList(uiExplorer);
            }
            case 3: {
                return this.getOwnedByUserNodeList(uiExplorer);
            }
            case 4: {
                return this.getHiddenNodeList(uiExplorer);
            }
        }
        return ret;
    }

    private List<Node> getCurrentNodeChildren(UIJCRExplorer uiExplorer) throws Exception {
        List<Object> childrenList = new ArrayList();
        Preference pref = uiExplorer.getPreference();
        String currentPath = uiExplorer.getCurrentPath();
        childrenList = !uiExplorer.isViewTag() ? uiExplorer.getChildrenList(currentPath, pref.isShowPreferenceDocuments()) : uiExplorer.getDocumentByTag();
        return childrenList;
    }

    private List<Node> getTrashNodeList(UIJCRExplorer uiExplorer) throws Exception {
        List ret = new ArrayList();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String trashWorkspace = portletPref.getValue(Utils.TRASH_WORKSPACE, "");
        String trashRepository = portletPref.getValue(Utils.TRASH_REPOSITORY, "");
        SessionProvider sessionProvider = uiExplorer.getSessionProvider();
        boolean byUser = uiExplorer.getPreference().isShowItemsByUser();
        ret = !byUser ? trashService_.getAllNodeInTrash(trashWorkspace, trashRepository, sessionProvider) : trashService_.getAllNodeInTrashByUser(trashWorkspace, trashRepository, sessionProvider, uiExplorer.getSession().getUserID());
        return ret;
    }

    private List<Node> getHiddenNodeList(UIJCRExplorer uiExplorer) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        boolean byUser = uiExplorer.getPreference().isShowItemsByUser();
        StringBuilder queryString = new StringBuilder("SELECT * FROM exo:hiddenable");
        if (byUser) {
            queryString.append(" WHERE CONTAINS(").append("exo:owner").append(",'").append(uiExplorer.getSession().getUserID()).append("')");
        }
        Session session = uiExplorer.getSession();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString.toString(), "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (node.isNodeType("exo:restoreLocation")) continue;
            ret.add(node);
        }
        return ret;
    }

    private List<Node> getFavouriteNodeList(UIJCRExplorer uiExplorer) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        List favoriteList = null;
        favoriteList = favoriteService_.getAllFavoriteNodesByUser(uiExplorer.getCurrentWorkspace(), uiExplorer.getRepositoryName(), uiExplorer.getSession().getUserID());
        for (Node node : favoriteList) {
            if (node.isNodeType("exo:restoreLocation")) continue;
            ret.add(node);
        }
        return ret;
    }

    private List<Node> getOwnedByUserNodeList(UIJCRExplorer uiExplorer) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        Session session = uiExplorer.getSession();
        StringBuilder queryString = new StringBuilder("SELECT * FROM ").append("nt:base");
        queryString.append(" WHERE CONTAINS(").append("exo:owner").append(",'").append(uiExplorer.getSession().getUserID()).append("')");
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString.toString(), "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        Node node = null;
        TreeSet<Node> set = new TreeSet<Node>(new NodeComparator());
        while (iter.hasNext()) {
            node = iter.nextNode();
            if (node.getName().equals("jcr:content") || node.isNodeType("exo:restoreLocation")) continue;
            if (node.isNodeType("nt:resource")) {
                node = node.getParent();
            }
            if (set.contains(node)) continue;
            ret.add(node);
            set.add(node);
        }
        return ret;
    }

    static {
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        favoriteService_ = (FavoriteService)myContainer.getComponentInstanceOfType(FavoriteService.class);
        trashService_ = (TrashService)myContainer.getComponentInstanceOfType(TrashService.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                if (o1.isSame((Item)o2)) {
                    return 0;
                }
                int pathComparison = o1.getPath().compareTo(o2.getPath());
                return pathComparison == 0 ? 1 : pathComparison;
            }
            catch (RepositoryException e) {
                return 1;
            }
        }
    }
}

