/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.utils;

import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xcmis.spi.CmisRuntimeException;

public class MimeType {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern WHITESPACE_QOUTE_PATTERN = Pattern.compile("[\\s\"]");
    private final String type;
    private final String subType;
    private final Map<String, String> parameters;

    public static MimeType fromString(String source) {
        if (source == null || source.length() == 0) {
            return new MimeType();
        }
        int p = source.indexOf(47);
        int col = source.indexOf(59);
        String type = null;
        String subType = null;
        if (p < 0 && col < 0) {
            return new MimeType(source, null);
        }
        if (p > 0 && col < 0) {
            return new MimeType(MimeType.removeWhitespaces(source.substring(0, p)), MimeType.removeWhitespaces(source.substring(p + 1)));
        }
        if (p < 0 && col > 0) {
            type = MimeType.removeWhitespaces(source.substring(0, col));
        } else {
            type = MimeType.removeWhitespaces(source.substring(0, p));
            subType = source.substring(p + 1, col);
        }
        try {
            return new MimeType(type, subType, new ParameterParser().parse(source));
        }
        catch (ParseException pe) {
            throw new CmisRuntimeException(pe.getMessage(), pe);
        }
    }

    private static String removeWhitespaces(String s) {
        Matcher m = WHITESPACE_PATTERN.matcher(s);
        if (m.find()) {
            return m.replaceAll("");
        }
        return s;
    }

    public MimeType() {
        this(null, null);
    }

    public MimeType(String type, String subType) {
        String string = type == null || type.length() == 0 ? "*" : (this.type = (type = type.trim()).length() == 0 ? "*" : type.toLowerCase());
        this.subType = subType == null || subType.length() == 0 ? "*" : ((subType = subType.trim()).length() == 0 ? "*" : subType.toLowerCase());
        this.parameters = new HashMap<String, String>();
    }

    public MimeType(String type, String subType, Map<String, String> parameters) {
        String string = type == null || type.length() == 0 ? "*" : (this.type = (type = type.trim()).length() == 0 ? "*" : type.toLowerCase());
        String string2 = subType == null || subType.length() == 0 ? "*" : (this.subType = (subType = subType.trim()).length() == 0 ? "*" : subType.toLowerCase());
        if (parameters == null) {
            this.parameters = new HashMap<String, String>();
        } else {
            TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                map.put(e.getKey().toLowerCase(), e.getValue());
            }
            this.parameters = Collections.unmodifiableMap(map);
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof MimeType)) {
            return false;
        }
        MimeType otherMimeType = (MimeType)other;
        return this.type.equalsIgnoreCase(otherMimeType.type) && this.subType.equalsIgnoreCase(otherMimeType.subType) && ((Object)this.parameters).equals(otherMimeType.parameters);
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public int hashCode() {
        int hash = 9;
        hash = hash * 31 + this.type.hashCode();
        hash = hash * 31 + this.subType.hashCode();
        hash = hash * 31 + ((Object)this.parameters).hashCode();
        return hash;
    }

    public boolean match(MimeType other) {
        if (other == null) {
            return false;
        }
        return this.type.equals("*") || this.type.equalsIgnoreCase(other.type) && (this.subType.equals("*") || this.subType.equalsIgnoreCase(other.subType));
    }

    public String getBaseType() {
        return this.type + "/" + this.subType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getBaseType());
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            sb.append(';').append(entry.getKey()).append('=');
            this.appendWithQuote(sb, entry.getValue());
        }
        return sb.toString();
    }

    private void appendWithQuote(StringBuffer sb, String s) {
        if (s == null) {
            return;
        }
        Matcher m = WHITESPACE_QOUTE_PATTERN.matcher(s);
        if (m.find()) {
            sb.append('\"');
            this.appendEscapeQuote(sb, s);
            sb.append('\"');
            return;
        }
        sb.append(s);
    }

    private void appendEscapeQuote(StringBuffer sb, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    static class ParameterParser {
        private static final char SEPARATOR = ';';
        private static final String SEPARTORS = "()<>@,;:\"\\/[]?={}";
        private int pos = 0;
        private int i1 = 0;
        private int i2 = 0;
        private char[] chars = null;
        private int length = 0;

        ParameterParser() {
        }

        public Map<String, String> parse(String source) throws ParseException {
            this.init(source);
            if (this.pos < 0) {
                return null;
            }
            ++this.pos;
            HashMap<String, String> m = null;
            while (this.hasChars()) {
                String name = this.readToken(new char[]{'=', ';'});
                String value = null;
                if (this.hasChars() && this.chars[this.pos] == '=') {
                    ++this.pos;
                    value = this.chars[this.pos] == '\"' ? this.readQuotedString() : this.readToken(new char[]{';'});
                }
                if (this.hasChars() && this.chars[this.pos] == ';') {
                    ++this.pos;
                }
                if (name == null || name.length() <= 0) continue;
                if (m == null) {
                    m = new HashMap<String, String>();
                }
                m.put(name, value);
            }
            return m;
        }

        private boolean checkChar(char c, char[] chs) {
            for (int i = 0; i < chs.length; ++i) {
                if (c != chs[i]) continue;
                return true;
            }
            return false;
        }

        private String filterEscape(String token) {
            StringBuffer sb = new StringBuffer();
            int strlen = token.length();
            for (int i = 0; i < strlen; ++i) {
                char c = token.charAt(i);
                if (c == '\\' && i < strlen - 1 && token.charAt(i + 1) == '\"') continue;
                sb.append(c);
            }
            return sb.toString();
        }

        private String getToken(boolean removeQuotes) {
            while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
                ++this.i1;
            }
            while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
                --this.i2;
            }
            if (removeQuotes && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
                ++this.i1;
                --this.i2;
            }
            String token = null;
            if (this.i2 > this.i1) {
                token = new String(this.chars, this.i1, this.i2 - this.i1);
            }
            return token;
        }

        private boolean hasChars() {
            return this.pos < this.length;
        }

        private void init(String source) {
            this.pos = source.indexOf(59);
            if (this.pos < 0) {
                return;
            }
            this.chars = source.toCharArray();
            this.length = this.chars.length;
            this.i1 = 0;
            this.i2 = 0;
        }

        private int isToken(String token) {
            for (int i = 0; i < token.length(); ++i) {
                char c = token.charAt(i);
                if (c < '\u007f' && SEPARTORS.indexOf(c) == -1) continue;
                return i;
            }
            return -1;
        }

        private String readQuotedString() throws ParseException {
            char c;
            this.i1 = this.pos;
            this.i2 = this.pos;
            boolean escape = false;
            boolean qoute = false;
            while (this.hasChars() && ((c = this.chars[this.pos]) != ';' || qoute)) {
                if (c == '\"' && !escape) {
                    qoute = !qoute;
                }
                escape = !escape && c == '\\';
                ++this.pos;
                ++this.i2;
            }
            if (qoute) {
                throw new ParseException("String must be ended with qoute.", this.pos);
            }
            String token = this.getToken(true);
            if (token != null) {
                token = this.filterEscape(this.getToken(true));
            }
            return token;
        }

        private String readToken(char[] terminators) throws ParseException {
            char c;
            this.i1 = this.pos;
            this.i2 = this.pos;
            while (this.hasChars() && !this.checkChar(c = this.chars[this.pos], terminators)) {
                ++this.pos;
                ++this.i2;
            }
            String token = this.getToken(false);
            if (token != null) {
                int err = -1;
                err = this.isToken(token);
                if (err != -1) {
                    throw new ParseException("Token '" + token + "' contains not legal characters at " + err, err);
                }
            }
            return token;
        }
    }
}

