/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.ecms.xcmis.sp.DocumentDataImpl;
import org.exoplatform.ecms.xcmis.sp.JcrNodeEntry;
import org.exoplatform.ecms.xcmis.sp.PolicyDataImpl;
import org.exoplatform.ecms.xcmis.sp.RelationshipDataImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.LazyIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectDataVisitor;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.PropertyFilter;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.impl.BooleanProperty;
import org.xcmis.spi.model.impl.DateTimeProperty;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.model.impl.IntegerProperty;
import org.xcmis.spi.model.impl.StringProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseObjectData
implements ObjectData {
    private static final Log LOG = ExoLogger.getLogger(BaseObjectData.class);
    protected JcrNodeEntry entry;

    public BaseObjectData(JcrNodeEntry jcrEntry) {
        this.entry = jcrEntry;
    }

    public void accept(ObjectDataVisitor visitor) {
        visitor.visit((ObjectData)this);
    }

    public void applyPolicy(PolicyData policy) {
        this.entry.applyPolicy(((BaseObjectData)policy).getNodeEntry());
        try {
            this.save();
        }
        catch (StorageException se) {
            throw new CmisRuntimeException("Unable apply policy. " + se.getMessage(), (Throwable)se);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return ((BaseObjectData)obj).getNodeEntry().equals(this.getNodeEntry());
    }

    public List<AccessControlEntry> getACL(boolean onlyBasicPermissions) {
        if (!this.getTypeDefinition().isControllableACL()) {
            return Collections.emptyList();
        }
        return this.entry.getACL();
    }

    public BaseType getBaseType() {
        return this.entry.getBaseType();
    }

    public String getChangeToken() {
        return this.entry.getString("cmis:changeToken");
    }

    public String getCreatedBy() {
        return this.entry.getString("cmis:createdBy");
    }

    public Calendar getCreationDate() {
        return this.entry.getDate("cmis:creationDate");
    }

    public Calendar getLastModificationDate() {
        return this.entry.getDate("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return this.entry.getString("cmis:lastModifiedBy");
    }

    public String getName() {
        return this.entry.getName();
    }

    public String getObjectId() {
        return this.entry.getId();
    }

    public Collection<PolicyData> getPolicies() {
        if (!this.getTypeDefinition().isControllablePolicy()) {
            return Collections.emptyList();
        }
        Collection<JcrNodeEntry> policyEntries = this.entry.getPolicies();
        HashSet<PolicyData> policies = new HashSet<PolicyData>(policyEntries.size());
        for (JcrNodeEntry pe : policyEntries) {
            policies.add(new PolicyDataImpl(pe));
        }
        return policies;
    }

    public Map<String, Property<?>> getProperties() {
        HashMap properties = new HashMap();
        TypeDefinition type = this.getTypeDefinition();
        for (PropertyDefinition definition : type.getPropertyDefinitions()) {
            properties.put(definition.getId(), this.doGetProperty(definition));
        }
        return properties;
    }

    public Map<String, Property<?>> getProperties(PropertyFilter filter) {
        HashMap properties = new HashMap();
        for (PropertyDefinition definition : this.getTypeDefinition().getPropertyDefinitions()) {
            String queryName = definition.getQueryName();
            if (!filter.accept(queryName)) continue;
            String id = definition.getId();
            properties.put(id, this.doGetProperty(definition));
        }
        return properties;
    }

    public Property<?> getProperty(String id) {
        PropertyDefinition definition = this.getTypeDefinition().getPropertyDefinition(id);
        if (definition == null) {
            return null;
        }
        return this.doGetProperty(definition);
    }

    public ItemsIterator<RelationshipData> getRelationships(RelationshipDirection direction, TypeDefinition type, boolean includeSubRelationshipTypes) {
        return new RelationshipIterator(this.entry.getRelationships(direction, type, includeSubRelationshipTypes));
    }

    public TypeDefinition getTypeDefinition() {
        return this.entry.getType();
    }

    public String getTypeId() {
        return this.getTypeDefinition().getId();
    }

    public int hashCode() {
        int hash = 8;
        hash = hash * 31 + this.getNodeEntry().hashCode();
        return hash;
    }

    public void removePolicy(PolicyData policy) {
        this.entry.removePolicy(((BaseObjectData)policy).getNodeEntry());
        try {
            this.save();
        }
        catch (StorageException se) {
            throw new CmisRuntimeException(se.getMessage(), (Throwable)se);
        }
    }

    public void setACL(List<AccessControlEntry> acl) {
        this.entry.setACL(acl);
        try {
            this.save();
        }
        catch (StorageException se) {
            throw new CmisRuntimeException(se.getMessage(), (Throwable)se);
        }
    }

    public void setProperties(Map<String, Property<?>> properties) throws NameConstraintViolationException, UpdateConflictException, VersioningException, StorageException {
        for (Property<?> property : properties.values()) {
            this.doSetProperty(property);
        }
        this.save();
    }

    public void setProperty(Property<?> property) throws NameConstraintViolationException, UpdateConflictException, VersioningException, StorageException {
        this.doSetProperty(property);
        this.save();
    }

    protected Property<?> doGetProperty(PropertyDefinition<?> definition) {
        if (definition.getId().equals("cmis:objectId")) {
            return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getObjectId());
        }
        if (definition.getId().equals("cmis:objectTypeId")) {
            return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getTypeId());
        }
        if (definition.getId().equals("cmis:baseTypeId")) {
            return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getBaseType().value());
        }
        if (definition.getId().equals("cmis:name")) {
            return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getName());
        }
        if (definition.getId().equals("cmis:creationDate")) {
            return new DateTimeProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getCreationDate());
        }
        if (definition.getId().equals("cmis:lastModificationDate")) {
            return new DateTimeProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getLastModificationDate());
        }
        if (definition.getId().equals("cmis:path")) {
            return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((FolderData)this).getPath());
        }
        if (definition.getId().equals("cmis:parentId") && this.getBaseType() == BaseType.FOLDER && !((FolderData)this).isRoot()) {
            try {
                return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getParent().getObjectId());
            }
            catch (ConstraintException never) {
                LOG.error((Object)("Unable get parent id. " + never.getMessage()));
            }
        } else {
            if (definition.getId().equals("cmis:contentStreamId")) {
                return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((DocumentDataImpl)this).getContentStreamId());
            }
            if (definition.getId().equals("cmis:contentStreamFileName")) {
                if (((DocumentData)this).hasContent()) {
                    return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((DocumentDataImpl)this).getContentStreamFileName());
                }
            } else if (definition.getId().equals("cmis:contentStreamMimeType")) {
                if (((DocumentData)this).hasContent()) {
                    return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((DocumentData)this).getContentStreamMimeType());
                }
            } else if (definition.getId().equals("cmis:contentStreamLength")) {
                if (((DocumentData)this).hasContent()) {
                    return new IntegerProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), BigInteger.valueOf(((DocumentDataImpl)this).getContentStreamLength()));
                }
            } else {
                if (definition.getId().equals("cmis:versionSeriesId")) {
                    return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((DocumentData)this).getVersionSeriesId());
                }
                if (definition.getId().equals("cmis:versionLabel")) {
                    return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((DocumentData)this).getVersionLabel());
                }
                if (definition.getId().equals("cmis:isLatestVersion")) {
                    return new BooleanProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), Boolean.valueOf(((DocumentData)this).isLatestVersion()));
                }
                if (definition.getId().equals("cmis:isMajorVersion")) {
                    return new BooleanProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), Boolean.valueOf(((DocumentData)this).isMajorVersion()));
                }
                if (definition.getId().equals("cmis:isLatestMajorVersion")) {
                    return new BooleanProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), Boolean.valueOf(((DocumentData)this).isLatestMajorVersion()));
                }
                if (definition.getId().equals("cmis:isVersionSeriesCheckedOut")) {
                    return new BooleanProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), Boolean.valueOf(((DocumentData)this).isVersionSeriesCheckedOut()));
                }
                if (definition.getId().equals("cmis:isImmutable")) {
                    return new BooleanProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), Boolean.valueOf(false));
                }
            }
        }
        return this.entry.getProperty(definition);
    }

    protected void doSetProperty(Property<?> property) throws NameConstraintViolationException {
        PropertyDefinition definition = this.getTypeDefinition().getPropertyDefinition(property.getId());
        Updatability updatability = definition.getUpdatability();
        if (updatability == Updatability.READWRITE || updatability == Updatability.WHENCHECKEDOUT && this.getBaseType() == BaseType.DOCUMENT && ((DocumentData)this).isPWC()) {
            Iterator i = property.getValues().iterator();
            while (i.hasNext()) {
                Object v = i.next();
                if (v != null) continue;
                i.remove();
            }
            this.entry.setProperty(property);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Property " + property.getId() + " is not updatable."));
        }
    }

    JcrNodeEntry getNodeEntry() {
        return this.entry;
    }

    protected void save() throws StorageException {
        this.entry.save(true);
    }

    public abstract void delete() throws StorageException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RelationshipIterator
    extends LazyIterator<RelationshipData> {
        private final Iterator<JcrNodeEntry> iter;
        private final int size;

        public RelationshipIterator(Collection<JcrNodeEntry> relationships) {
            this.size = relationships.size();
            this.iter = relationships.iterator();
            this.fetchNext();
        }

        public int size() {
            return this.size;
        }

        protected void fetchNext() {
            this.next = null;
            if (this.iter.hasNext()) {
                this.next = new RelationshipDataImpl(this.iter.next());
            }
        }
    }
}

