/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.service.gatein;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.io.IOUtils;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.rest.impl.uri.UriComponent;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetListingService
implements Startable {
    public static final String GADGET_MIME_TYPE = "application/x-google-gadget";
    private final String workspaceName;
    private final String host;
    private final String port;
    private final String context;
    private String baseUrl;
    private final String country;
    private final String language;
    private final String moduleId;
    private final String gadgetHostName;

    public GadgetListingService(InitParams params, GadgetRegistryService gadgetService) {
        this.country = gadgetService.getCountry();
        this.language = gadgetService.getLanguage();
        this.moduleId = gadgetService.getModuleId();
        this.gadgetHostName = gadgetService.getHostName();
        if (params != null) {
            ValueParam workspaceParam = params.getValueParam("workspace");
            this.workspaceName = workspaceParam != null ? workspaceParam.getValue() : null;
            ValueParam hostParam = params.getValueParam("host");
            this.host = hostParam != null ? hostParam.getValue() : "127.0.0.1";
            ValueParam portParam = params.getValueParam("port");
            this.port = portParam != null ? portParam.getValue() : null;
            ValueParam contextParam = params.getValueParam("context");
            this.context = contextParam != null ? contextParam.getValue() : "/rest/jcr";
        } else {
            this.workspaceName = "production";
            this.host = "127.0.0.1";
            this.port = "";
            this.context = "/rest/jcr";
        }
        this.baseUrl = "http://" + this.host;
        if (this.port != null && !this.port.equals("")) {
            this.baseUrl = this.baseUrl + ":" + this.port;
        }
    }

    public Gadget createGadget(String name, String path, boolean isLocal) throws Exception {
        Gadget gadget = new Gadget();
        gadget.setName(name);
        gadget.setUrl(path);
        gadget.setLocal(Boolean.valueOf(isLocal));
        Map<String, String> metaData = this.getMapMetadata(path);
        if (metaData.containsKey("errors")) {
            throw new Exception("error on the server: " + metaData.get("errors"));
        }
        String title = metaData.get("directoryTitle");
        if (title == null || title.trim().length() < 1) {
            title = metaData.get("title");
        }
        if (title == null || title.trim().length() < 1) {
            title = gadget.getName();
        }
        gadget.setTitle(title);
        gadget.setDescription(metaData.get("description"));
        gadget.setReferenceUrl(metaData.get("titleUrl"));
        gadget.setThumbnail(metaData.get("thumbnail"));
        return gadget;
    }

    public Map<String, String> getMapMetadata(String url) throws JSONException {
        HashMap<String, String> mapMetaData = new HashMap<String, String>();
        String metadata = this.fetchGagdetMetadata(url);
        metadata = metadata.substring(metadata.indexOf("[") + 1, metadata.lastIndexOf("]"));
        JSONObject jsonObj = new JSONObject(metadata);
        Iterator iter = jsonObj.keys();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            mapMetaData.put(element, jsonObj.get(element).toString());
        }
        return mapMetaData;
    }

    public String fetchGagdetMetadata(String urlStr) {
        String result = null;
        try {
            String data = "{\"context\":{\"country\":\"" + this.country + "\",\"language\":\"" + this.language + "\"},\"gadgets\":[" + "{\"moduleId\":" + this.moduleId + ",\"url\":\"" + urlStr + "\",\"prefs\":[]}]}";
            String gadgetServer = this.baseUrl + "/" + this.gadgetHostName;
            URL url = new URL(gadgetServer + (gadgetServer.endsWith("/") ? "" : "/") + "metadata");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            result = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
            wr.close();
        }
        catch (IOException ioexc) {
            return "{}";
        }
        return result;
    }

    private void addlistener() throws UnsupportedRepositoryOperationException, RepositoryException, RepositoryConfigurationException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        RepositoryImpl repository = (RepositoryImpl)repositoryService.getDefaultRepository();
        final String repositoryName = repository.getName();
        final SessionImpl session = (SessionImpl)repository.login(this.workspaceName);
        WorkspaceImpl workspace = session.getWorkspace();
        ObservationManager observationManager = workspace.getObservationManager();
        observationManager.addEventListener(new EventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(EventIterator events) {
                while (events.hasNext()) {
                    Event event = (Event)events.next();
                    try {
                        if (!event.getPath().contains("jcr:data")) continue;
                        Property property = (Property)session.getItem(event.getPath());
                        Node node = property.getParent();
                        String url = GadgetListingService.this.baseUrl + GadgetListingService.this.context + "/" + repositoryName + "/" + GadgetListingService.this.workspaceName + node.getParent().getPath();
                        String urlEnc = UriComponent.encode((String)url, (int)5, (boolean)false);
                        String name = "gadget" + event.getPath().hashCode();
                        Gadget gadget = GadgetListingService.this.createGadget(name, urlEnc, false);
                        ExoContainer container = ExoContainerContext.getCurrentContainer();
                        RequestLifeCycle.begin((ExoContainer)container, (boolean)true);
                        try {
                            GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
                            gadgetService.saveGadget(gadget);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                    catch (RepositoryException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 4, null, true, null, new String[]{"exo:googleGadget"}, false);
    }

    private void removelistener() throws UnsupportedRepositoryOperationException, RepositoryException, RepositoryConfigurationException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        RepositoryImpl repository = (RepositoryImpl)repositoryService.getDefaultRepository();
        SessionImpl session = (SessionImpl)repository.login(this.workspaceName);
        WorkspaceImpl workspace = session.getWorkspace();
        ObservationManager observationManager = workspace.getObservationManager();
        observationManager.addEventListener(new EventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(EventIterator events) {
                while (events.hasNext()) {
                    Event event = (Event)events.next();
                    try {
                        if (!event.getPath().contains("jcr:data")) continue;
                        String name = "gadget" + event.getPath().hashCode();
                        ExoContainer container = ExoContainerContext.getCurrentContainer();
                        RequestLifeCycle.begin((ExoContainer)container, (boolean)true);
                        try {
                            GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
                            gadgetService.removeGadget(name);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                    catch (RepositoryException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 8, null, true, null, new String[]{"exo:googleGadget"}, false);
    }

    public void start() {
        try {
            this.addlistener();
            this.removelistener();
        }
        catch (UnsupportedRepositoryOperationException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (RepositoryConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }
}

